/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.util.definition;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.exception.LSStdlibCacheException;
import org.ballerinalang.model.elements.PackageID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.util.Name;

public class LSStdLibCacheUtil {
    private static final String ZIPENTRY_FILE_SEPARATOR = "/";
    private static final String DIR_VALIDATION_PATTERN = "src/src/";
    private static final String TOML_CONTENT = "[project]\norg-name= \"lsbalorg\"\nversion=\"1.1.0\"\n\n[dependencies]";
    private static final Logger logger = LoggerFactory.getLogger(LSStdLibCacheUtil.class);
    private static final Path STD_LIB_SOURCE_ROOT = Paths.get(CommonUtil.BALLERINA_HOME, new String[0]).resolve("lib").resolve("repo");

    private LSStdLibCacheUtil() {
    }

    protected static void extractSourceForImportModule(String orgName, BLangImportPackage module) throws LSStdlibCacheException {
        String moduleName = module.getPackageName().stream().map(BLangIdentifier::getValue).collect(Collectors.joining("."));
        String version = module.getPackageVersion().getValue().isEmpty() ? "0.0.0" : module.getPackageVersion().getValue();
        String cacheableKey = LSStdLibCacheUtil.getCacheableKey(module);
        Path baloPath = STD_LIB_SOURCE_ROOT.resolve(orgName).resolve(moduleName).resolve(version).resolve(moduleName + ".zip");
        Path destinationRoot = CommonUtil.LS_STDLIB_CACHE_DIR.resolve(cacheableKey).resolve("src");
        LSStdLibCacheUtil.extract(baloPath, destinationRoot, moduleName, cacheableKey);
    }

    protected static void extractSourceForCacheableKey(String cacheableKey) throws LSStdlibCacheException {
        int versionSeparator = cacheableKey.lastIndexOf("_");
        int modNameSeparator = cacheableKey.indexOf("_");
        String version = cacheableKey.substring(versionSeparator + 1);
        String moduleName = cacheableKey.substring(modNameSeparator + 1, versionSeparator);
        String orgName = cacheableKey.substring(0, modNameSeparator);
        Path baloPath = STD_LIB_SOURCE_ROOT.resolve(orgName).resolve(moduleName).resolve(version).resolve(moduleName + ".zip");
        Path destinationRoot = CommonUtil.LS_STDLIB_CACHE_DIR.resolve(cacheableKey).resolve("src");
        LSStdLibCacheUtil.extract(baloPath, destinationRoot, moduleName, cacheableKey);
    }

    private static void extract(Path baloPath, Path destinationRoot, String moduleName, String cacheableKey) throws LSStdlibCacheException {
        FileInputStream baloFileInputStream;
        Path destinationPath;
        if (Files.exists(destinationRoot, new LinkOption[0])) {
            return;
        }
        if (!Files.exists(baloPath, new LinkOption[0])) {
            throw new LSStdlibCacheException("Invalid module source root provided for module: [" + cacheableKey + "]");
        }
        try {
            LSStdLibCacheUtil.createProjectForModule(cacheableKey);
            destinationPath = Files.createDirectories(destinationRoot.resolve(cacheableKey), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new LSStdlibCacheException(e.getMessage(), e);
        }
        String moduleDirValidationPattern = DIR_VALIDATION_PATTERN + moduleName + ZIPENTRY_FILE_SEPARATOR;
        byte[] buffer = new byte[1024];
        try {
            baloFileInputStream = new FileInputStream(baloPath.toAbsolutePath().toString());
        }
        catch (FileNotFoundException e) {
            throw new LSStdlibCacheException(e.getMessage(), e);
        }
        try (ZipInputStream zis = new ZipInputStream(baloFileInputStream);){
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                String fileName = zipEntry.getName().replace(moduleDirValidationPattern, "");
                if (zipEntry.isDirectory()) {
                    if (!zipEntry.getName().equals(moduleDirValidationPattern) && zipEntry.getName().startsWith(moduleDirValidationPattern)) {
                        Files.createDirectories(destinationPath.resolve(fileName), new FileAttribute[0]);
                    }
                    zipEntry = zis.getNextEntry();
                    continue;
                }
                if (!fileName.endsWith(".bir") && !fileName.endsWith("Module.md")) {
                    File newFile = destinationPath.resolve(fileName).toFile();
                    try (FileOutputStream fos = new FileOutputStream(newFile);){
                        int length;
                        while ((length = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, length);
                        }
                        boolean readOnly = newFile.setReadOnly();
                        if (!readOnly) {
                            logger.warn("Failed to set the cached source read only");
                        }
                    }
                }
                zipEntry = zis.getNextEntry();
            }
        }
        catch (IOException e) {
            throw new LSStdlibCacheException(e.getMessage(), e);
        }
        finally {
            try {
                baloFileInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected static synchronized String getCacheableKey(BLangImportPackage module) {
        String moduleName = module.getPackageName().stream().map(BLangIdentifier::getValue).collect(Collectors.joining("."));
        String version = module.getPackageVersion().getValue();
        String orgName = module.orgName.value;
        return LSStdLibCacheUtil.getCacheableKey(orgName, moduleName, version);
    }

    protected static synchronized String getCacheableKey(PackageID packageID) {
        String moduleName = packageID.getNameComps().stream().map(Name::getValue).collect(Collectors.joining("."));
        String version = packageID.getPackageVersion().getValue();
        String orgName = packageID.orgName.value;
        return LSStdLibCacheUtil.getCacheableKey(orgName, moduleName, version);
    }

    private static String getCacheableKey(String orgName, String moduleName, String version) {
        return orgName + "_" + moduleName + "_" + (version.isEmpty() ? "0.0.0" : version);
    }

    private static void createProjectForModule(String projectDir) throws IOException {
        Path cachedProjectPath = CommonUtil.LS_STDLIB_CACHE_DIR.resolve(projectDir);
        Path projectPath = Files.createDirectories(cachedProjectPath, new FileAttribute[0]);
        Path manifestPath = projectPath.resolve("Ballerina.toml");
        Files.write(manifestPath, Collections.singletonList(TOML_CONTENT), new OpenOption[0]);
    }
}

