## Module Overview

This module provides the API for Java interoperability in Ballerina. It includes a set of Ballerina annotations with which Java constructors, methods, and fields can provide implementations of Ballerina functions with external function bodies.  

For information on the operations, which you can perform with the Java module, see the below **Functions**. For examples on the usage of the operations, see the following.
- [Create Java Objects Example](https://ballerina.io/1.2/learn/by-example/create-java-objects.html)
- [Invoke Java Methods Example](https://ballerina.io/1.2/learn/by-example/invoke-java-methods.html) 
- [Access/Mutate Java Fields Example](https://ballerina.io/1.2/learn/by-example/access-mutate-java-fields.html)
- [Java Varargs Example](https://ballerina.io/1.2/learn/by-example/java-varargs.html)
- [Overloaded Methods/Constructors Example](https://ballerina.io/1.2/learn/by-example/overloaded-methods-constructors.html)
- [Java Exceptions Example](https://ballerina.io/1.2/learn/by-example/java-exceptions.html)
