// Copyright (c) 2017 WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
//
// WSO2 Inc. licenses this file to you under the Apache License,
// Version 2.0 (the "License"); you may not use this file except
// in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

import ballerina/java;

# WritableByteChannel represents an output resource (i.e file). which could be used to sink bytes.
public type WritableByteChannel object {

    # Adding default __init function to prevent object getting initialized from the user code.
    function __init() {}

# Sinks bytes from a given input/output resource.
#
# This operation will be asynchronous. Writing might return without writing all the content.
# ```ballerina
# int|io:Error result = writableByteChannel.write(record, 0);
# ```
#
# + content - Block of bytes, which should be written
# + offset - Offset, which should be kept when writing bytes.
# + return - Number of bytes written or else `io:Error`
    public function write(byte[] content, int offset) returns int|Error {
        return byteWriteExtern(self, content, offset);
    }

# Closes a given byte channel.
# ```ballerina
# io:Error err = writableByteChannel.close();
# ```
#
# + return - `io:Error` or else `()`
    public function close() returns Error? {
        return closeWritableByteChannelExtern(self);
    }
};

function byteWriteExtern(WritableByteChannel byteChannel, byte[] content, int offset) returns int|Error = @java:Method {
    name: "write",
    class: "org.ballerinalang.stdlib.io.nativeimpl.ByteChannelUtils"
} external;

function closeWritableByteChannelExtern(WritableByteChannel byteChannel) returns Error? = @java:Method {
    name: "closeByteChannel",
    class: "org.ballerinalang.stdlib.io.nativeimpl.ByteChannelUtils"
} external;
