# README

Ballerina is a programming language for network distributed applications.

Ballerina allows you to code with a statically-typed programming language where listeners, services, client endpoints, and streams are first-class constructs. You can use your preferred IDE and CI/CD tools. Discover, consume, and share modules that integrate endpoints with Ballerina Central. Build binaries, containers, and Kubernetes artifacts and deploy as chaos-ready services on cloud and serverless infrastructure. Integrate distributed endpoints with a simple syntax for resiliency, circuit breakers, transactions, and events.

## Table of contents

- [Getting started](#getting-started)
- [License](#license)
- [Useful links](#useful-links)

## Getting started

You can use one of the following options to try out Ballerina.

- [Getting Started](https://ballerina.io/learn/getting-started/)
- [Quick Tour](https://ballerina.io/learn/quick-tour/)
- [Ballerina by Example](https://ballerina.io/learn/by-example/)
- [Ballerina by Guide](https://ballerina.io/learn/by-guide/)

## License

Ballerina code is distributed under [Apache license 2.0](https://github.com/ballerina-platform/ballerina-lang/blob/master/LICENSE).

## Useful links

- The ballerina-dev@googlegroups.com mailing list is for discussing code changes to the Ballerina project.
- Chat live with us on our [Slack channel](https://ballerina-platform.slack.com/).
- Technical questions should be posted on Stack Overflow with the [#ballerina](https://stackoverflow.com/questions/tagged/ballerina) tag.