/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.yaml;

import io.ballerina.lib.data.yaml.emitter.Emitter;
import io.ballerina.lib.data.yaml.io.BallerinaByteBlockInputStream;
import io.ballerina.lib.data.yaml.parser.YamlParser;
import io.ballerina.lib.data.yaml.serializer.Serializer;
import io.ballerina.lib.data.yaml.utils.DataReader;
import io.ballerina.lib.data.yaml.utils.DiagnosticLog;
import io.ballerina.lib.data.yaml.utils.OptionsUtils;
import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BStream;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.List;

public class Native {
    private Native() {
    }

    public static Object parseString(BString yaml, BMap<BString, Object> options, BTypedesc typed) {
        try {
            return YamlParser.compose(new StringReader(yaml.getValue()), options, typed);
        }
        catch (BError e) {
            return e;
        }
    }

    public static Object parseBytes(BArray yaml, BMap<BString, Object> options, BTypedesc typed) {
        try {
            return YamlParser.compose(new InputStreamReader(new ByteArrayInputStream(yaml.getBytes())), options, typed);
        }
        catch (BError e) {
            return e;
        }
    }

    public static Object parseStream(Environment env, BStream yaml, BMap<BString, Object> options, BTypedesc typed) {
        BObject iteratorObj = yaml.getIteratorObj();
        try {
            BallerinaByteBlockInputStream byteBlockSteam = new BallerinaByteBlockInputStream(env, iteratorObj, DataReader.resolveNextMethod(iteratorObj), DataReader.resolveCloseMethod(iteratorObj));
            Object result = YamlParser.compose(new InputStreamReader(byteBlockSteam), options, typed);
            if (byteBlockSteam.getError() != null) {
                return byteBlockSteam.getError();
            }
            return result;
        }
        catch (Exception e) {
            return DiagnosticLog.getYamlError("Error occurred while reading the stream: " + e.getMessage());
        }
    }

    public static Object toYamlStringArray(Object yamlValue, BMap<BString, Object> config) {
        OptionsUtils.WriteConfig writeConfig = OptionsUtils.resolveWriteOptions(config);
        char delimiter = writeConfig.useSingleQuotes() ? (char)'\'' : '\"';
        Serializer.SerializerState serializerState = new Serializer.SerializerState(delimiter, writeConfig.forceQuotes(), writeConfig.blockLevel(), writeConfig.flowStyle(), writeConfig.isStream());
        Serializer.serialize(serializerState, yamlValue);
        Emitter.EmitterState emitterState = new Emitter.EmitterState(serializerState.getEvents(), writeConfig.indentationPolicy(), writeConfig.canonical());
        List<BString> content = Emitter.emit(emitterState, writeConfig.isStream());
        return ValueCreator.createArrayValue((BString[])content.toArray(new BString[0]));
    }
}

