/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.yaml.utils;

import io.ballerina.lib.data.yaml.common.Types;
import io.ballerina.lib.data.yaml.parser.ParserUtils;
import io.ballerina.lib.data.yaml.parser.Values;
import io.ballerina.lib.data.yaml.utils.Constants;
import io.ballerina.lib.data.yaml.utils.DiagnosticErrorCode;
import io.ballerina.lib.data.yaml.utils.DiagnosticLog;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.TupleType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.utils.ValueUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;

public class JsonTraverse {
    private static final ThreadLocal<JsonTree> tlJsonTree = ThreadLocal.withInitial(JsonTree::new);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object traverse(Object json, BMap<BString, Object> options, Type type, Types.YAMLSchema schema) {
        JsonTree jsonTree = tlJsonTree.get();
        try {
            Object allowDataProjection = options.get((Object)Constants.ALLOW_DATA_PROJECTION);
            jsonTree.schema = schema;
            if (allowDataProjection instanceof Boolean) {
                jsonTree.allowDataProjection = false;
            } else if (allowDataProjection instanceof BMap) {
                jsonTree.allowDataProjection = true;
                jsonTree.absentAsNilableType = (Boolean)((BMap)allowDataProjection).get((Object)Constants.ABSENT_AS_NILABLE_TYPE);
                jsonTree.nilAsOptionalField = (Boolean)((BMap)allowDataProjection).get((Object)Constants.NIL_AS_OPTIONAL_FIELD);
            }
            Object object = jsonTree.traverseJson(json, type);
            return object;
        }
        finally {
            jsonTree.reset();
        }
    }

    private static class JsonTree {
        Field currentField;
        Stack<Map<String, Field>> fieldHierarchy = new Stack();
        Stack<Type> restType = new Stack();
        Deque<String> fieldNames = new ArrayDeque<String>();
        Type rootArray;
        boolean allowDataProjection = true;
        boolean nilAsOptionalField = false;
        boolean absentAsNilableType = false;
        Types.YAMLSchema schema = Types.YAMLSchema.CORE_SCHEMA;

        private JsonTree() {
        }

        void reset() {
            this.currentField = null;
            this.fieldHierarchy.clear();
            this.restType.clear();
            this.fieldNames.clear();
            this.rootArray = null;
            this.allowDataProjection = true;
            this.nilAsOptionalField = false;
            this.absentAsNilableType = false;
        }

        private Object traverseJson(Object json, Type type) {
            Type referredType = TypeUtils.getReferredType((Type)type);
            switch (referredType.getTag()) {
                case 24: {
                    RecordType recordType = (RecordType)referredType;
                    this.fieldHierarchy.push(ParserUtils.getAllFieldsInRecord(recordType));
                    this.restType.push(recordType.getRestFieldType());
                    return this.traverseMapJsonOrArrayJson(json, ValueCreator.createRecordValue((Module)type.getPackage(), (String)type.getName()), referredType);
                }
                case 32: {
                    this.rootArray = referredType;
                    return this.traverseMapJsonOrArrayJson(json, ValueCreator.createArrayValue((ArrayType)((ArrayType)referredType)), referredType);
                }
                case 44: {
                    this.rootArray = referredType;
                    return this.traverseMapJsonOrArrayJson(json, ValueCreator.createTupleValue((TupleType)((TupleType)referredType)), referredType);
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 46: {
                    return Values.fromStringWithType(Values.convertValueToBString(json), referredType, this.schema);
                }
                case 33: {
                    for (Type memberType : ((UnionType)referredType).getMemberTypes()) {
                        try {
                            Object result = this.traverseJson(json, memberType);
                            if (result instanceof BError) continue;
                            return result;
                        }
                        catch (Exception exception) {
                        }
                    }
                    throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_TYPE, type, PredefinedTypes.TYPE_ANYDATA);
                }
                case 15: 
                case 23: {
                    return json;
                }
                case 27: {
                    MapType mapType = (MapType)referredType;
                    this.fieldHierarchy.push(new HashMap());
                    this.restType.push(mapType.getConstrainedType());
                    return this.traverseMapJsonOrArrayJson(json, ValueCreator.createMapValue((MapType)mapType), referredType);
                }
                case 34: {
                    for (Type constituentType : ((IntersectionType)referredType).getConstituentTypes()) {
                        if (constituentType.getTag() == 51) continue;
                        return Values.constructReadOnlyValue(this.traverseJson(json, constituentType));
                    }
                    throw DiagnosticLog.error(DiagnosticErrorCode.UNSUPPORTED_TYPE, type);
                }
            }
            throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_TYPE, type, PredefinedTypes.TYPE_ANYDATA);
        }

        private Object traverseMapJsonOrArrayJson(Object json, Object currentJsonNode, Type type) {
            if (json instanceof BMap) {
                BMap bMap = (BMap)json;
                return this.traverseMapValue((BMap<BString, Object>)bMap, currentJsonNode);
            }
            if (json instanceof BArray) {
                BArray bArray = (BArray)json;
                return this.traverseArrayValue(bArray, currentJsonNode);
            }
            if (type.getTag() == 24) {
                this.fieldHierarchy.pop();
                this.restType.pop();
            }
            if (this.fieldNames.isEmpty()) {
                throw DiagnosticLog.error(DiagnosticErrorCode.INCOMPATIBLE_TYPE, type, json);
            }
            throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_TYPE_FOR_FIELD, this.getCurrentFieldPath());
        }

        private Object traverseMapValue(BMap<BString, Object> map, Object currentJsonNode) {
            block3: for (BString key : (BString[])map.getKeys()) {
                this.currentField = this.fieldHierarchy.peek().remove(key.toString());
                if (this.currentField == null) {
                    if (this.restType.peek() != null) {
                        Type restFieldType = TypeUtils.getReferredType((Type)this.restType.peek());
                        this.addRestField(restFieldType, key, map.get((Object)key), currentJsonNode);
                    }
                    if (this.allowDataProjection) continue;
                    throw DiagnosticLog.error(DiagnosticErrorCode.UNDEFINED_FIELD, key);
                }
                String fieldName = this.currentField.getFieldName();
                this.fieldNames.push(fieldName);
                Type currentFieldType = TypeUtils.getReferredType((Type)this.currentField.getFieldType());
                int currentFieldTypeTag = currentFieldType.getTag();
                Object mapValue = map.get((Object)key);
                if (this.nilAsOptionalField && !currentFieldType.isNilable() && mapValue == null && SymbolFlags.isFlagOn((long)this.currentField.getFlags(), (long)4096L)) continue;
                switch (currentFieldTypeTag) {
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 14: {
                        BString bStringVal = StringUtils.fromString((String)mapValue.toString());
                        Object value = Values.fromStringWithType(bStringVal, currentFieldType, this.schema);
                        ((BMap)currentJsonNode).put((Object)StringUtils.fromString((String)this.fieldNames.pop()), value);
                        continue block3;
                    }
                    default: {
                        ((BMap)currentJsonNode).put((Object)StringUtils.fromString((String)fieldName), this.traverseJson(mapValue, currentFieldType));
                    }
                }
            }
            Map<String, Field> currentField = this.fieldHierarchy.pop();
            this.checkOptionalFieldsAndLogError(currentField);
            this.restType.pop();
            return currentJsonNode;
        }

        /*
         * Unable to fully structure code
         */
        private Object traverseArrayValue(BArray array, Object currentJsonNode) {
            switch (this.rootArray.getTag()) {
                case 32: {
                    arrayType = (ArrayType)this.rootArray;
                    expectedArraySize = arrayType.getSize();
                    sourceArraySize = array.getLength();
                    if (!this.allowDataProjection && (long)expectedArraySize < sourceArraySize) {
                        throw DiagnosticLog.error(DiagnosticErrorCode.ARRAY_SIZE_MISMATCH, new Object[0]);
                    }
                    elementType = arrayType.getElementType();
                    if (expectedArraySize == -1 || (long)expectedArraySize > sourceArraySize) {
                        this.traverseArrayMembers(array.getLength(), array, elementType, currentJsonNode);
                        break;
                    }
                    this.traverseArrayMembers(expectedArraySize, array, elementType, currentJsonNode);
                    break;
                }
                case 44: {
                    tupleType = (TupleType)this.rootArray;
                    restType = tupleType.getRestType();
                    expectedTupleTypeCount = tupleType.getTupleTypes().size();
                    i = 0;
                    while ((long)i < array.getLength()) {
                        jsonMember = array.get((long)i);
                        if (i >= expectedTupleTypeCount) ** GOTO lbl24
                        nextJsonNode = this.traverseJson(jsonMember, (Type)tupleType.getTupleTypes().get(i));
                        ** GOTO lbl29
lbl24:
                        // 1 sources

                        if (restType == null) {
                            if (!this.allowDataProjection) {
                                throw DiagnosticLog.error(DiagnosticErrorCode.ARRAY_SIZE_MISMATCH, new Object[0]);
                            }
                        } else {
                            nextJsonNode = this.traverseJson(jsonMember, restType);
lbl29:
                            // 2 sources

                            ((BArray)currentJsonNode).add((long)i, nextJsonNode);
                        }
                        ++i;
                    }
                    break;
                }
            }
            return currentJsonNode;
        }

        private void traverseArrayMembers(long length, BArray array, Type elementType, Object currentJsonNode) {
            int i = 0;
            while ((long)i < length) {
                ((BArray)currentJsonNode).add((long)i, this.traverseJson(array.get((long)i), elementType));
                ++i;
            }
        }

        private void addRestField(Type restFieldType, BString key, Object jsonMember, Object currentJsonNode) {
            switch (restFieldType.getTag()) {
                case 15: 
                case 23: {
                    ((BMap)currentJsonNode).put((Object)key, jsonMember);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    ((BMap)currentJsonNode).put((Object)key, this.convertToBasicType(jsonMember, restFieldType));
                    break;
                }
                default: {
                    Object nextJsonValue = this.traverseJson(jsonMember, restFieldType);
                    ((BMap)currentJsonNode).put((Object)key, nextJsonValue);
                }
            }
        }

        private void checkOptionalFieldsAndLogError(Map<String, Field> currentField) {
            currentField.values().forEach(field -> {
                if (field.getFieldType().isNilable() && this.absentAsNilableType) {
                    return;
                }
                if (SymbolFlags.isFlagOn((long)field.getFlags(), (long)256L)) {
                    throw DiagnosticLog.error(DiagnosticErrorCode.REQUIRED_FIELD_NOT_PRESENT, field.getFieldName());
                }
            });
        }

        private Object convertToBasicType(Object json, Type targetType) {
            try {
                return ValueUtils.convert((Object)json, (Type)targetType);
            }
            catch (BError e) {
                if (this.fieldNames.isEmpty()) {
                    throw DiagnosticLog.error(DiagnosticErrorCode.INCOMPATIBLE_TYPE, targetType, String.valueOf(json));
                }
                throw DiagnosticLog.error(DiagnosticErrorCode.INCOMPATIBLE_VALUE_FOR_FIELD, String.valueOf(json), targetType, this.getCurrentFieldPath());
            }
        }

        private String getCurrentFieldPath() {
            Iterator<String> itr = this.fieldNames.descendingIterator();
            StringBuilder sb = new StringBuilder(itr.hasNext() ? itr.next() : "");
            while (itr.hasNext()) {
                sb.append(".").append(itr.next());
            }
            return sb.toString();
        }
    }
}

