/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.ballerinalang.langserver.BallerinaLanguageServer;
import org.ballerinalang.langserver.LSClientLogger;
import org.ballerinalang.langserver.LSContextOperation;
import org.ballerinalang.langserver.command.LSCommandExecutorProvidersHolder;
import org.ballerinalang.langserver.commons.DidChangeWatchedFilesContext;
import org.ballerinalang.langserver.commons.ExecuteCommandContext;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.WorkspaceServiceContext;
import org.ballerinalang.langserver.commons.capability.LSClientCapabilities;
import org.ballerinalang.langserver.commons.command.CommandArgument;
import org.ballerinalang.langserver.commons.command.LSCommandExecutorException;
import org.ballerinalang.langserver.commons.command.spi.LSCommandExecutor;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.config.LSClientConfigHolder;
import org.ballerinalang.langserver.contexts.ContextBuilder;
import org.ballerinalang.langserver.diagnostic.DiagnosticsHelper;
import org.ballerinalang.langserver.exception.UserErrorException;
import org.ballerinalang.langserver.telemetry.TelemetryUtil;
import org.ballerinalang.langserver.workspace.BallerinaWorkspaceManagerProxy;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.services.WorkspaceService;

public class BallerinaWorkspaceService
implements WorkspaceService {
    private final BallerinaLanguageServer languageServer;
    private final LSClientConfigHolder configHolder;
    private LSClientCapabilities clientCapabilities;
    private final BallerinaWorkspaceManagerProxy workspaceManagerProxy;
    private final LanguageServerContext serverContext;
    private final LSClientLogger clientLogger;

    BallerinaWorkspaceService(BallerinaLanguageServer languageServer, BallerinaWorkspaceManagerProxy workspaceManagerProxy, LanguageServerContext serverContext) {
        this.languageServer = languageServer;
        this.workspaceManagerProxy = workspaceManagerProxy;
        this.serverContext = serverContext;
        this.configHolder = LSClientConfigHolder.getInstance(this.serverContext);
        this.clientLogger = LSClientLogger.getInstance(this.serverContext);
    }

    public void setClientCapabilities(LSClientCapabilities clientCapabilities) {
        this.clientCapabilities = clientCapabilities;
    }

    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        Object object = params.getSettings();
        if (!(object instanceof JsonObject)) {
            return;
        }
        JsonObject settings = (JsonObject)object;
        if (settings.get("ballerina") != null) {
            this.configHolder.updateConfig(settings.get("ballerina"));
        } else {
            this.configHolder.updateConfig((JsonElement)settings);
        }
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        try {
            List paths = this.workspaceManagerProxy.get().didChangeWatched(params);
            LSClientCapabilities lsClientCapabilities = (LSClientCapabilities)this.serverContext.get(LSClientCapabilities.class);
            if (!lsClientCapabilities.getInitializationOptions().isEnableLightWeightMode()) {
                DidChangeWatchedFilesContext context = ContextBuilder.buildDidChangeWatchedFilesContext(this.workspaceManagerProxy.get(), this.serverContext);
                DiagnosticsHelper diagnosticsHelper = DiagnosticsHelper.getInstance(this.serverContext);
                for (Path projectRoot : paths) {
                    diagnosticsHelper.schedulePublishDiagnostics(this.languageServer.getClient(), (WorkspaceServiceContext)context, projectRoot);
                }
            }
        }
        catch (WorkspaceDocumentException e) {
            String msg = "Operation 'workspace/didChangeWatchedFiles' failed!";
            this.clientLogger.logError(LSContextOperation.WS_WF_CHANGED, msg, e, null, new Position[]{null});
        }
    }

    public CompletableFuture<Object> executeCommand(ExecuteCommandParams params) {
        return CompletableFuture.supplyAsync(() -> {
            List<CommandArgument> commandArguments = params.getArguments().stream().map(CommandArgument::from).toList();
            ExecuteCommandContext context = ContextBuilder.buildExecuteCommandContext(this.workspaceManagerProxy.get(), this.serverContext, commandArguments, this.clientCapabilities, this.languageServer);
            try {
                Optional<LSCommandExecutor> executor = LSCommandExecutorProvidersHolder.getInstance(this.serverContext).getCommandExecutor(params.getCommand());
                if (executor.isPresent()) {
                    LSCommandExecutor commandExecutor = executor.get();
                    Object result = commandExecutor.execute(context);
                    TelemetryUtil.featureUsageEventFromCommandExecutor(commandExecutor).ifPresent(lsFeatureUsageTelemetryEvent -> TelemetryUtil.sendTelemetryEvent(context.languageServercontext(), lsFeatureUsageTelemetryEvent));
                    return result;
                }
            }
            catch (UserErrorException e) {
                this.clientLogger.notifyUser("Execute Command", e);
            }
            catch (Throwable e) {
                String msg = "Operation 'workspace/executeCommand' failed!";
                this.clientLogger.logError(LSContextOperation.WS_EXEC_CMD, msg, e, null, new Position[]{null});
            }
            this.clientLogger.logError(LSContextOperation.WS_EXEC_CMD, "Operation 'workspace/executeCommand' failed!", (Throwable)new LSCommandExecutorException("No command executor found for '" + params.getCommand() + "'"), null, new Position[]{null});
            return false;
        });
    }
}

