/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction;

import io.ballerina.compiler.syntax.tree.AnnotationDeclarationNode;
import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.BinaryExpressionNode;
import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.BracedExpressionNode;
import io.ballerina.compiler.syntax.tree.CheckExpressionNode;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.CompoundAssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.ConstantDeclarationNode;
import io.ballerina.compiler.syntax.tree.DoStatementNode;
import io.ballerina.compiler.syntax.tree.EnumDeclarationNode;
import io.ballerina.compiler.syntax.tree.ErrorConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.FieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.ForEachStatementNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyBlockNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.IfElseStatementNode;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.IndexedExpressionNode;
import io.ballerina.compiler.syntax.tree.LetExpressionNode;
import io.ballerina.compiler.syntax.tree.ListConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.ListenerDeclarationNode;
import io.ballerina.compiler.syntax.tree.LockStatementNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MatchStatementNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.MethodDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModuleXMLNamespaceDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ObjectConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.ObjectTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.QueryExpressionNode;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.ReturnStatementNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.TableConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.TemplateExpressionNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TrapExpressionNode;
import io.ballerina.compiler.syntax.tree.TypeCastExpressionNode;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeTestExpressionNode;
import io.ballerina.compiler.syntax.tree.TypeofExpressionNode;
import io.ballerina.compiler.syntax.tree.UnaryExpressionNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.WhileStatementNode;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.eclipse.lsp4j.Range;

public class CodeActionNodeAnalyzer
extends NodeVisitor {
    private final int startPositionOffset;
    private final int endPositionOffset;
    private NonTerminalNode codeActionNode;
    private SyntaxKind syntaxKind;
    private StatementNode statementNode;
    private NonTerminalNode documentableNode;
    private NonTerminalNode enclosingDocumentableNode;

    private CodeActionNodeAnalyzer(int startPositionOffset, int endPositionOffset) {
        this.startPositionOffset = startPositionOffset;
        this.endPositionOffset = endPositionOffset;
    }

    public static CodeActionNodeAnalyzer analyze(Range range, SyntaxTree syntaxTree) {
        int startPositionOffset = PositionUtil.getPositionOffset(range.getStart(), syntaxTree);
        int endPositionOffset = PositionUtil.getPositionOffset(range.getEnd(), syntaxTree);
        CodeActionNodeAnalyzer analyzer = new CodeActionNodeAnalyzer(startPositionOffset, endPositionOffset);
        NonTerminalNode node = CommonUtil.findNode(range, syntaxTree);
        if (node.kind() == SyntaxKind.LIST) {
            if (CodeActionNodeAnalyzer.hasChildStatement(node)) {
                analyzer.checkAndSetCodeActionNode(node);
                analyzer.checkAndSetSyntaxKind(node.kind());
            }
            node.parent().accept((NodeVisitor)analyzer);
        } else {
            node.accept((NodeVisitor)analyzer);
        }
        return analyzer;
    }

    public void visit(ImportDeclarationNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        this.visitSyntaxNode((Node)node);
    }

    public void visit(ListenerDeclarationNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.visitSyntaxNode((Node)node);
    }

    public void visit(ServiceDeclarationNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        int serviceKwStart = node.serviceKeyword().textRange().startOffset();
        int openBraceEnd = node.openBraceToken().textRange().endOffset();
        int closeBraceEnd = node.closeBraceToken().textRange().endOffset();
        if (this.isWithinRange(serviceKwStart, closeBraceEnd)) {
            this.checkAndSetEnclosingDocumentableNode((NonTerminalNode)node);
            if (this.isWithinRange(serviceKwStart, openBraceEnd)) {
                this.checkAndSetDocumentableNode((NonTerminalNode)node);
                return;
            }
        }
        this.visitSyntaxNode((Node)node);
    }

    public void visit(FunctionDefinitionNode node) {
        if (node.functionBody().kind() != SyntaxKind.FUNCTION_BODY_BLOCK) {
            return;
        }
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        NodeList qualifiers = node.qualifierList();
        int startOffset = !qualifiers.isEmpty() ? ((Token)qualifiers.get(0)).textRange().startOffset() : node.functionKeyword().textRange().startOffset();
        FunctionBodyBlockNode functionBody = (FunctionBodyBlockNode)node.functionBody();
        int openBraceEnd = functionBody.openBraceToken().textRange().endOffset();
        int closeBraceEnd = functionBody.closeBraceToken().textRange().endOffset();
        if (this.isWithinRange(startOffset, closeBraceEnd)) {
            this.checkAndSetEnclosingDocumentableNode((NonTerminalNode)node);
            if (this.isWithinRange(startOffset, openBraceEnd)) {
                this.checkAndSetDocumentableNode((NonTerminalNode)node);
                return;
            }
        }
        this.visitSyntaxNode((Node)node);
    }

    public void visit(TypeDefinitionNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.typeDescriptor().kind());
        Optional qualifier = node.visibilityQualifier();
        int startOffset = qualifier.isEmpty() ? node.typeKeyword().textRange().startOffset() : ((Token)qualifier.get()).textRange().startOffset();
        int typeNameEnd = node.typeName().textRange().endOffset();
        int nodeEnd = node.textRange().endOffset();
        if (this.isWithinRange(startOffset, nodeEnd)) {
            this.checkAndSetEnclosingDocumentableNode((NonTerminalNode)node);
            if (this.isWithinRange(startOffset, typeNameEnd)) {
                this.checkAndSetDocumentableNode((NonTerminalNode)node);
                return;
            }
        }
        this.visitSyntaxNode((Node)node);
    }

    public void visit(ClassDefinitionNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        Optional qualifier = node.visibilityQualifier();
        int startOffset = qualifier.isEmpty() ? node.classKeyword().textRange().startOffset() : ((Token)qualifier.get()).textRange().startOffset();
        int openBraceEnd = node.openBrace().textRange().endOffset();
        int closeBraceEnd = node.closeBrace().textRange().endOffset();
        if (this.isWithinRange(startOffset, closeBraceEnd)) {
            this.checkAndSetEnclosingDocumentableNode((NonTerminalNode)node);
            if (this.isWithinRange(startOffset, openBraceEnd)) {
                this.checkAndSetDocumentableNode((NonTerminalNode)node);
                return;
            }
        }
        this.visitSyntaxNode((Node)node);
    }

    public void visit(ModuleVariableDeclarationNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        Optional visibilityQualifier = node.visibilityQualifier();
        NodeList qualifiers = node.qualifiers();
        int startOffset = visibilityQualifier.isPresent() ? ((Token)visibilityQualifier.get()).textRange().startOffset() : (!qualifiers.isEmpty() ? ((Token)qualifiers.get(0)).textRange().startOffset() : node.typedBindingPattern().textRange().startOffset());
        int bpEnd = node.typedBindingPattern().bindingPattern().textRange().endOffset();
        int nodeEnd = node.textRange().endOffset();
        if (this.isWithinRange(startOffset, nodeEnd)) {
            this.checkAndSetEnclosingDocumentableNode((NonTerminalNode)node);
            if (this.isWithinRange(startOffset, bpEnd)) {
                this.checkAndSetDocumentableNode((NonTerminalNode)node);
                return;
            }
        }
        this.visitSyntaxNode((Node)node);
    }

    public void visit(ConstantDeclarationNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        Optional visibilityQualifier = node.visibilityQualifier();
        int startOffset = visibilityQualifier.map(token -> token.textRange().startOffset()).orElseGet(() -> node.constKeyword().textRange().startOffset());
        int varNameEnd = node.variableName().textRange().endOffset();
        int nodeEnd = node.textRange().endOffset();
        if (this.isWithinRange(startOffset, nodeEnd)) {
            this.checkAndSetEnclosingDocumentableNode((NonTerminalNode)node);
            if (this.isWithinRange(startOffset, varNameEnd)) {
                this.checkAndSetDocumentableNode((NonTerminalNode)node);
                return;
            }
        }
        this.visitSyntaxNode((Node)node);
    }

    public void visit(EnumDeclarationNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        int startOffset = node.qualifier().map(token -> token.textRange().startOffset()).orElseGet(() -> node.enumKeywordToken().textRange().startOffset());
        int openBraceEnd = node.openBraceToken().textRange().endOffset();
        int closeBraceEnd = node.closeBraceToken().textRange().endOffset();
        if (this.isWithinRange(startOffset, closeBraceEnd)) {
            this.checkAndSetEnclosingDocumentableNode((NonTerminalNode)node);
            if (this.isWithinRange(startOffset, openBraceEnd)) {
                this.checkAndSetDocumentableNode((NonTerminalNode)node);
                return;
            }
        }
        this.visitSyntaxNode((Node)node);
    }

    public void visit(ModuleXMLNamespaceDeclarationNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        int startOffset = node.xmlnsKeyword().textRange().startOffset();
        int endOffset = node.semicolonToken().textRange().endOffset();
        if (this.isWithinRange(startOffset, endOffset)) {
            this.checkAndSetEnclosingDocumentableNode((NonTerminalNode)node);
            this.checkAndSetDocumentableNode((NonTerminalNode)node);
            return;
        }
        this.visitSyntaxNode((Node)node);
    }

    public void visit(AnnotationDeclarationNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        int startOffset = node.visibilityQualifier().map(token -> token.textRange().startOffset()).orElseGet(() -> node.constKeyword().map(token -> token.textRange().startOffset()).orElseGet(() -> node.annotationKeyword().textRange().startOffset()));
        int annotationNameEnd = node.annotationTag().textRange().endOffset();
        int endOffset = node.semicolonToken().textRange().endOffset();
        if (this.isWithinRange(startOffset, endOffset)) {
            this.checkAndSetEnclosingDocumentableNode((NonTerminalNode)node);
            if (this.isWithinRange(startOffset, annotationNameEnd)) {
                this.checkAndSetDocumentableNode((NonTerminalNode)node);
                return;
            }
        }
        this.visitSyntaxNode((Node)node);
    }

    public void visit(MethodDeclarationNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        NodeList qualifierList = node.qualifierList();
        int startOffset = !qualifierList.isEmpty() ? ((Token)qualifierList.get(0)).textRange().startOffset() : node.functionKeyword().textRange().startOffset();
        int endOffset = node.textRange().endOffset();
        if (this.isWithinRange(startOffset, endOffset)) {
            this.checkAndSetEnclosingDocumentableNode((NonTerminalNode)node);
            this.checkAndSetDocumentableNode((NonTerminalNode)node);
        }
        this.visitSyntaxNode((Node)node);
    }

    public void visit(RecordTypeDescriptorNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        this.visitSyntaxNode((Node)node);
    }

    public void visit(BasicLiteralNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        this.visitSyntaxNode((Node)node);
    }

    public void visit(BracedExpressionNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        this.visitSyntaxNode((Node)node);
    }

    public void visit(ObjectTypeDescriptorNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        this.visitSyntaxNode((Node)node);
    }

    public void visit(VariableDeclarationNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        this.visitSyntaxNode((Node)node);
    }

    public void visit(AssignmentStatementNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        this.visitSyntaxNode((Node)node);
    }

    public void visit(BinaryExpressionNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        this.visitSyntaxNode((Node)node);
    }

    public void visit(QualifiedNameReferenceNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        this.visitSyntaxNode((Node)node);
    }

    public void visit(IndexedExpressionNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        this.visitSyntaxNode((Node)node);
    }

    public void visit(FieldAccessExpressionNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        this.visitSyntaxNode((Node)node);
    }

    public void visit(MethodCallExpressionNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        this.visitSyntaxNode((Node)node);
    }

    public void visit(MappingConstructorExpressionNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        this.visitSyntaxNode((Node)node);
    }

    public void visit(TypeofExpressionNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        this.visitSyntaxNode((Node)node);
    }

    public void visit(TypeTestExpressionNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        this.visitSyntaxNode((Node)node);
    }

    public void visit(ListConstructorExpressionNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        this.visitSyntaxNode((Node)node);
    }

    public void visit(TypeCastExpressionNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        this.visitSyntaxNode((Node)node);
    }

    public void visit(TableConstructorExpressionNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        this.visitSyntaxNode((Node)node);
    }

    public void visit(LetExpressionNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        this.visitSyntaxNode((Node)node);
    }

    public void visit(ImplicitNewExpressionNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        this.visitSyntaxNode((Node)node);
    }

    public void visit(ExplicitNewExpressionNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        this.visitSyntaxNode((Node)node);
    }

    public void visit(ObjectConstructorExpressionNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        this.visitSyntaxNode((Node)node);
    }

    public void visit(ErrorConstructorExpressionNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        this.visitSyntaxNode((Node)node);
    }

    public void visit(FunctionCallExpressionNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        this.visitSyntaxNode((Node)node);
    }

    public void visit(IfElseStatementNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        this.visitSyntaxNode((Node)node);
    }

    public void visit(CheckExpressionNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        this.visitSyntaxNode((Node)node);
    }

    public void visit(CompoundAssignmentStatementNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        this.visitSyntaxNode((Node)node);
    }

    public void visit(WhileStatementNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        this.visitSyntaxNode((Node)node);
    }

    public void visit(UnaryExpressionNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        this.visitSyntaxNode((Node)node);
    }

    public void visit(ReturnStatementNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        this.visitSyntaxNode((Node)node);
    }

    public void visit(LockStatementNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        this.visitSyntaxNode((Node)node);
    }

    public void visit(ForEachStatementNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        this.visitSyntaxNode((Node)node);
    }

    public void visit(MatchStatementNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        this.visitSyntaxNode((Node)node);
    }

    public void visit(DoStatementNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        this.visitSyntaxNode((Node)node);
    }

    public void visit(TrapExpressionNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        this.visitSyntaxNode((Node)node);
    }

    public void visit(QueryExpressionNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        this.visitSyntaxNode((Node)node);
    }

    public void visit(TemplateExpressionNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        this.visitSyntaxNode((Node)node);
    }

    public void visit(ObjectFieldNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        int startOffset = node.visibilityQualifier().map(token -> token.textRange().startOffset()).or(() -> node.qualifierList().stream().findFirst().map(token -> token.textRange().startOffset())).orElseGet(() -> node.typeName().textRange().startOffset());
        int endOffset = node.semicolonToken().textRange().endOffset();
        if (this.isWithinRange(startOffset, endOffset)) {
            this.checkAndSetEnclosingDocumentableNode((NonTerminalNode)node);
            this.checkAndSetDocumentableNode((NonTerminalNode)node);
        }
    }

    public void visit(SpecificFieldNode node) {
        this.checkAndSetCodeActionNode((NonTerminalNode)node);
        this.checkAndSetSyntaxKind(node.kind());
        this.visitSyntaxNode((Node)node);
    }

    public void visit(Node node) {
        if (node == null) {
            return;
        }
        node.accept((NodeVisitor)this);
    }

    private static boolean hasChildStatement(NonTerminalNode node) {
        for (Node childNode : node.children()) {
            if (childNode.kind().compareTo((Enum)SyntaxKind.BLOCK_STATEMENT) < 0 || childNode.kind().compareTo((Enum)SyntaxKind.BINARY_EXPRESSION) >= 0) continue;
            return true;
        }
        return false;
    }

    private void checkAndSetCodeActionNode(NonTerminalNode node) {
        if (this.codeActionNode == null) {
            this.codeActionNode = node;
        }
    }

    private void checkAndSetSyntaxKind(SyntaxKind kind) {
        if (this.syntaxKind == null) {
            this.syntaxKind = kind;
        }
    }

    private void checkAndSetStatementNode(StatementNode node) {
        if (this.statementNode == null) {
            this.statementNode = node;
        }
    }

    private void checkAndSetDocumentableNode(NonTerminalNode node) {
        if (this.documentableNode == null) {
            this.documentableNode = node;
        }
    }

    private void checkAndSetEnclosingDocumentableNode(NonTerminalNode node) {
        if (this.enclosingDocumentableNode == null) {
            this.enclosingDocumentableNode = node;
        }
    }

    private boolean isWithinRange(int startOffSet, int endOffset) {
        return this.startPositionOffset > startOffSet && this.endPositionOffset <= endOffset;
    }

    protected void visitSyntaxNode(Node node) {
        if (node instanceof StatementNode) {
            StatementNode statementNode = (StatementNode)node;
            if (!(node instanceof BlockStatementNode)) {
                this.checkAndSetStatementNode(statementNode);
            }
        }
        if (node.parent() != null) {
            node.parent().accept((NodeVisitor)this);
        }
    }

    public Optional<NonTerminalNode> getCodeActionNode() {
        return Optional.ofNullable(this.codeActionNode);
    }

    public SyntaxKind getSyntaxKind() {
        return this.syntaxKind != null ? this.syntaxKind : SyntaxKind.NONE;
    }

    public Optional<StatementNode> getStatementNode() {
        return Optional.ofNullable(this.statementNode);
    }

    public Optional<NonTerminalNode> getDocumentableNode() {
        return Optional.ofNullable(this.documentableNode);
    }

    public Optional<NonTerminalNode> getEnclosingDocumentableNode() {
        return Optional.ofNullable(this.enclosingDocumentableNode);
    }
}

