/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.text.LinePosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.codeaction.FailStatementResolver;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagBasedPositionDetails;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagnosticBasedCodeActionProvider;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class AddOnFailCodeAction
implements DiagnosticBasedCodeActionProvider {
    public static final String NAME = "Add on-fail clause";

    public boolean validate(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        return (DiagnosticErrorCode.CHECKED_EXPR_NO_MATCHING_ERROR_RETURN_IN_ENCL_INVOKABLE.diagnosticId().equals(diagnostic.diagnosticInfo().code()) || DiagnosticErrorCode.FAIL_EXPR_NO_MATCHING_ERROR_RETURN_IN_ENCL_INVOKABLE.diagnosticId().equals(diagnostic.diagnosticInfo().code())) && CodeActionNodeValidator.validate(context.nodeAtRange());
    }

    public List<CodeAction> getCodeActions(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        String commandTitle;
        NonTerminalNode nodeAtDiagnostic = positionDetails.matchedNode();
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        FailStatementResolver finder = new FailStatementResolver(diagnostic);
        Optional<Node> failStatementResolverNode = finder.getRegularCompoundStatementNode((Node)nodeAtDiagnostic);
        if (failStatementResolverNode.isPresent() && failStatementResolverNode.get().kind() == SyntaxKind.WHILE_KEYWORD) {
            while (nodeAtDiagnostic.kind() == SyntaxKind.WHILE_STATEMENT) {
                nodeAtDiagnostic = nodeAtDiagnostic.parent();
            }
            edits.add(this.getSurroundWithOnFailEditText((Node)nodeAtDiagnostic));
            String commandTitle2 = "Surround with do/on-fail";
            return Collections.singletonList(CodeActionUtil.createCodeAction(commandTitle2, edits, context.fileUri(), "quickfix"));
        }
        if (failStatementResolverNode.isPresent()) {
            LinePosition regularCompoundStmtLinePosition = failStatementResolverNode.get().lineRange().endLine();
            Position onFailPosLine = new Position(regularCompoundStmtLinePosition.line(), regularCompoundStmtLinePosition.offset());
            String spaces = " ".repeat(regularCompoundStmtLinePosition.offset() - 1);
            String editText = " on fail var e {" + CommonUtil.LINE_SEPARATOR + spaces + "\t" + CommonUtil.LINE_SEPARATOR + spaces + "}";
            edits.add(new TextEdit(new Range(onFailPosLine, onFailPosLine), editText));
            commandTitle = "Create on fail clause";
        } else {
            edits.add(this.getSurroundWithOnFailEditText((Node)nodeAtDiagnostic));
            commandTitle = "Surround with do/on-fail";
        }
        return Collections.singletonList(CodeActionUtil.createCodeAction(commandTitle, edits, context.fileUri(), "quickfix"));
    }

    public TextEdit getSurroundWithOnFailEditText(Node node) {
        while (!StatementNode.class.isAssignableFrom(node.getClass())) {
            node = node.parent();
        }
        LinePosition startLinePosition = node.lineRange().startLine();
        LinePosition endLinePosition = node.lineRange().endLine();
        Position positionDo = new Position(startLinePosition.line(), startLinePosition.offset());
        Position posCheckLineStart = new Position(endLinePosition.line(), endLinePosition.offset());
        String spaces = " ".repeat(startLinePosition.offset());
        String insideDoStatement = node.toSourceCode();
        String tabShiftedDoStatement = insideDoStatement.substring(0, insideDoStatement.length() - 1).replace("\n", "\n\t") + "\n";
        String editTextDo = "do {" + CommonUtil.LINE_SEPARATOR + "\t" + tabShiftedDoStatement + spaces + "} on fail var e {" + CommonUtil.LINE_SEPARATOR + spaces + "\t" + CommonUtil.LINE_SEPARATOR + spaces + "}";
        return new TextEdit(new Range(positionDo, posCheckLineStart), editTextDo);
    }

    public String getName() {
        return NAME;
    }
}

