/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagBasedPositionDetails;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagnosticBasedCodeActionProvider;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class CloneValueCodeAction
implements DiagnosticBasedCodeActionProvider {
    private static final String NAME = "Clone the value";
    private static final String DIAGNOSTIC_CODE_3959 = "BCE3959";
    private static final Set<String> DIAGNOSTIC_CODES = Set.of("BCE3959", "BCE3960");
    private static final String CLONE_METHOD = ".clone()";
    private static final String CLONE_READONLY_METHOD = ".cloneReadOnly()";

    public boolean validate(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        return DIAGNOSTIC_CODES.contains(diagnostic.diagnosticInfo().code()) && CodeActionNodeValidator.validate(context.nodeAtRange());
    }

    public List<CodeAction> getCodeActions(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        NonTerminalNode matchedNode = positionDetails.matchedNode();
        if (CommonUtil.hasMultipleDiagnostics(context, matchedNode, diagnostic, DIAGNOSTIC_CODES, DIAGNOSTIC_CODE_3959)) {
            return Collections.emptyList();
        }
        Optional optTypeSymbol = context.currentSemanticModel().flatMap(semanticModel -> semanticModel.typeOf((Node)positionDetails.matchedNode()));
        if (optTypeSymbol.isEmpty()) {
            assert (false) : "The diagnostic cannot be produced for a node without a type symbol.";
            return Collections.emptyList();
        }
        TypeSymbol typeSymbol = (TypeSymbol)optTypeSymbol.get();
        if (!CloneValueCodeAction.isStructuredType(typeSymbol)) {
            return Collections.emptyList();
        }
        Position position = PositionUtil.toPosition(matchedNode.lineRange().endLine());
        Range range = new Range(position, position);
        String fileUri = context.fileUri();
        return List.of(CloneValueCodeAction.getCodeAction(NAME, CLONE_METHOD, range, fileUri), CloneValueCodeAction.getCodeAction("Clone as a readonly value", CLONE_READONLY_METHOD, range, fileUri));
    }

    private static CodeAction getCodeAction(String commandName, String methodName, Range range, String fileUri) {
        return CodeActionUtil.createCodeAction(commandName, Collections.singletonList(new TextEdit(range, methodName)), fileUri, "quickfix");
    }

    private static boolean isStructuredType(TypeSymbol typeSymbol) {
        return switch (typeSymbol.typeKind()) {
            case TypeDescKind.RECORD, TypeDescKind.MAP, TypeDescKind.ARRAY, TypeDescKind.TABLE, TypeDescKind.TUPLE, TypeDescKind.JSON, TypeDescKind.ANYDATA, TypeDescKind.UNION -> true;
            case TypeDescKind.TYPE_REFERENCE -> CloneValueCodeAction.isStructuredType(((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor());
            default -> false;
        };
    }

    public String getName() {
        return NAME;
    }
}

