/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.BracedExpressionNode;
import io.ballerina.compiler.syntax.tree.CompoundAssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.FieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.Document;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LineRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.ballerinalang.formatter.core.Formatter;
import org.ballerinalang.formatter.core.FormatterException;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.codeaction.ExpressionNodeValidator;
import org.ballerinalang.langserver.codeaction.ExtractToFunctionStatementAnalyzer;
import org.ballerinalang.langserver.command.visitors.IsolatedBlockResolver;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.FunctionGenerator;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.capability.LSClientCapabilities;
import org.ballerinalang.langserver.commons.codeaction.spi.RangeBasedCodeActionProvider;
import org.ballerinalang.langserver.commons.codeaction.spi.RangeBasedPositionDetails;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class ExtractToFunctionCodeAction
implements RangeBasedCodeActionProvider {
    public static final String NAME = "Extract to function";
    private static final String EXTRACTED_PREFIX = "extracted";
    private static final Set<SyntaxKind> unSupportedModuleLevelSyntaxKinds = Set.of(SyntaxKind.CONST_DECLARATION, SyntaxKind.MODULE_XML_NAMESPACE_DECLARATION, SyntaxKind.ENUM_DECLARATION, SyntaxKind.TYPE_DEFINITION);

    public boolean validate(CodeActionContext context, RangeBasedPositionDetails positionDetails) {
        return context.currentSemanticModel().isPresent() && context.currentDocument().isPresent() && positionDetails.matchedCodeActionNode().parent().kind() != SyntaxKind.MATCH_CLAUSE && (!ExtractToFunctionCodeAction.isExpressionNode(positionDetails.matchedCodeActionNode()) || this.isExpressionExtractable(positionDetails)) && CodeActionNodeValidator.validate((Node)positionDetails.matchedCodeActionNode());
    }

    public List<SyntaxKind> getSyntaxKinds() {
        ArrayList<SyntaxKind> supportedSyntaxKinds = new ArrayList<SyntaxKind>();
        supportedSyntaxKinds.addAll(ExtractToFunctionCodeAction.getSupportedStatementSyntaxKindsList());
        supportedSyntaxKinds.addAll(ExtractToFunctionCodeAction.getSupportedExpressionSyntaxKindsList());
        return supportedSyntaxKinds;
    }

    public List<CodeAction> getCodeActions(CodeActionContext context, RangeBasedPositionDetails posDetails) {
        if (ExtractToFunctionCodeAction.isExpressionNode(posDetails.matchedCodeActionNode())) {
            return this.getCodeActionsForExpressions(context, posDetails);
        }
        return this.getCodeActionsForStatements(context, posDetails);
    }

    private List<CodeAction> getCodeActionsForStatements(CodeActionContext context, RangeBasedPositionDetails posDetails) {
        Optional<List<Symbol>> argsSymbolsForExtractFunction;
        NonTerminalNode matchedCodeActionNode = posDetails.matchedCodeActionNode();
        Node enclosingNode = this.findEnclosingModulePartNode(matchedCodeActionNode);
        if (!this.isWithinFunctionDefinitionNode(matchedCodeActionNode)) {
            return Collections.emptyList();
        }
        SemanticModel semanticModel = (SemanticModel)context.currentSemanticModel().get();
        ExtractToFunctionStatementAnalyzer statementAnalyzer = new ExtractToFunctionStatementAnalyzer(context.range(), semanticModel);
        statementAnalyzer.analyze(matchedCodeActionNode);
        if (!statementAnalyzer.isExtractable()) {
            return Collections.emptyList();
        }
        Pair<Boolean, Optional<VariableSymbol>> isExtractableAndUpdatingVarPair = this.isExtractableAndUpdatingVar(statementAnalyzer, enclosingNode, context);
        if (((Boolean)isExtractableAndUpdatingVarPair.getLeft()).equals(Boolean.FALSE)) {
            return Collections.emptyList();
        }
        Optional updatedVar = (Optional)isExtractableAndUpdatingVarPair.getRight();
        Optional<Object> possibleTypeOfUpdatedVar = Optional.empty();
        String returnTypeDescriptor = "";
        if (updatedVar.isPresent()) {
            Optional<String> posType = CodeActionUtil.getPossibleType(((VariableSymbol)updatedVar.get()).typeDescriptor(), context);
            if (posType.isEmpty()) {
                return Collections.emptyList();
            }
            possibleTypeOfUpdatedVar = posType;
            returnTypeDescriptor = String.format("returns %s", possibleTypeOfUpdatedVar.get());
        }
        if ((argsSymbolsForExtractFunction = this.getVarAndParamSymbolsWithinRangeForStmts(context, enclosingNode)).isEmpty()) {
            return Collections.emptyList();
        }
        Optional<ArgListsHolder> argLists = this.getArgLists(context, argsSymbolsForExtractFunction.get(), matchedCodeActionNode);
        if (argLists.isEmpty()) {
            return Collections.emptyList();
        }
        List<String> argsForExtractFunction = argLists.get().extractFunctionArgs;
        List<String> argsForReplaceFunctionCall = argLists.get().replaceFunctionCallArgs;
        String functionName = this.getFunctionName(context, (Node)matchedCodeActionNode);
        String returnStatement = "";
        if (updatedVar.isPresent() && ((VariableSymbol)updatedVar.get()).getName().isPresent()) {
            returnStatement = String.format("return %s;", ((VariableSymbol)updatedVar.get()).getName().get());
        }
        List<Node> selectedNodes = statementAnalyzer.getSelectedNodes();
        String funcBody = selectedNodes.stream().map(Node::toSourceCode).collect(Collectors.joining(""));
        boolean newLineAtEnd = this.addNewLineAtEnd(enclosingNode);
        Range extractFunctionInsertRange = PositionUtil.toRange(enclosingNode.lineRange().endLine());
        IsolatedBlockResolver isolatedBlockResolver = new IsolatedBlockResolver();
        Boolean isIsolated = isolatedBlockResolver.findIsolatedBlock((Node)matchedCodeActionNode);
        Object extractFunction = FunctionGenerator.generateFunction(functionName, argsForExtractFunction, returnTypeDescriptor, returnStatement, newLineAtEnd, isIsolated, funcBody);
        try {
            extractFunction = CommonUtil.LINE_SEPARATOR + Formatter.format((String)extractFunction).stripTrailing();
        }
        catch (FormatterException e) {
            return Collections.emptyList();
        }
        String replaceFunctionCall = this.getReplaceFunctionCall(argsForReplaceFunctionCall, functionName, false);
        if (updatedVar.isPresent() && ((VariableSymbol)updatedVar.get()).getName().isPresent()) {
            String varName = (String)((VariableSymbol)updatedVar.get()).getName().get();
            replaceFunctionCall = String.format("%s %s = %s", possibleTypeOfUpdatedVar.get(), varName, replaceFunctionCall);
        }
        Position replaceFuncCallStartPos = PositionUtil.toPosition(selectedNodes.get(0).lineRange().startLine());
        Position replaceFuncCallEndPos = PositionUtil.toPosition(selectedNodes.get(selectedNodes.size() - 1).lineRange().endLine());
        Range replaceFuncCallInsertRange = new Range(replaceFuncCallStartPos, replaceFuncCallEndPos);
        TextEdit extractFunctionEdit = new TextEdit(extractFunctionInsertRange, (String)extractFunction);
        TextEdit replaceFunctionCallEdit = new TextEdit(replaceFuncCallInsertRange, replaceFunctionCall);
        CodeAction codeAction = CodeActionUtil.createCodeAction(NAME, List.of(extractFunctionEdit, replaceFunctionCallEdit), context.fileUri(), "refactor.extract");
        CodeActionUtil.addRenamePopup(context, codeAction, "Rename function", replaceFuncCallStartPos);
        return List.of(codeAction);
    }

    private Pair<Boolean, Optional<VariableSymbol>> isExtractableAndUpdatingVar(ExtractToFunctionStatementAnalyzer analyzer, Node enclosingNode, CodeActionContext context) {
        boolean isRangeExtractable;
        SemanticModel semanticModel = (SemanticModel)context.currentSemanticModel().get();
        List<Symbol> updatedSymbols = analyzer.getUpdatedSymbols();
        List<Symbol> declaredVariableSymbols = analyzer.getDeclaredVariableSymbols();
        HashSet<Symbol> updatedOrDeclaredLocVarSymbolsInRange = new HashSet<Symbol>(updatedSymbols);
        updatedOrDeclaredLocVarSymbolsInRange.addAll(declaredVariableSymbols);
        List<Symbol> updatedModVarSymbols = updatedSymbols.stream().filter(symbol -> symbol.getLocation().isPresent() && !PositionUtil.isWithinLineRange(((Location)symbol.getLocation().get()).lineRange(), enclosingNode.lineRange())).toList();
        List<Symbol> updatedButNotDeclaredLocVarSymbolsInRange = updatedSymbols.stream().filter(symbol -> symbol.getLocation().isPresent() && !PositionUtil.isRangeWithinRange(PositionUtil.toRange(((Location)symbol.getLocation().get()).lineRange()), context.range())).filter(symbol -> !updatedModVarSymbols.contains(symbol)).toList();
        List<VariableSymbol> localVarSymbols = updatedOrDeclaredLocVarSymbolsInRange.stream().filter(symbol -> !updatedModVarSymbols.contains(symbol)).filter(symbol -> semanticModel.references(symbol).stream().anyMatch(location -> PositionUtil.isRangeWithinRange(PositionUtil.toRange(location.lineRange()), this.getRangeAfterHighlightedRange(context, enclosingNode)))).map(symbol -> (VariableSymbol)symbol).toList();
        boolean bl = isRangeExtractable = updatedButNotDeclaredLocVarSymbolsInRange.isEmpty() && localVarSymbols.size() <= 1;
        if (!isRangeExtractable) {
            return Pair.of((Object)Boolean.FALSE, Optional.empty());
        }
        Optional<Object> updatedVar = Optional.empty();
        if (localVarSymbols.size() == 1) {
            updatedVar = localVarSymbols.stream().findFirst();
        }
        return Pair.of((Object)Boolean.TRUE, updatedVar);
    }

    private Range getRangeAfterHighlightedRange(CodeActionContext context, Node enclosingNode) {
        Position endPosOfEnclosingNode = PositionUtil.toPosition(enclosingNode.lineRange().endLine());
        Position endPosOfStatements = new Position(endPosOfEnclosingNode.getLine(), endPosOfEnclosingNode.getCharacter() - 1);
        return new Range(context.range().getEnd(), endPosOfStatements);
    }

    private Optional<List<Symbol>> getVarAndParamSymbolsWithinRangeForStmts(CodeActionContext context, Node enclosingNode) {
        ArrayList argsSymbolsForExtractFunction = new ArrayList();
        List<Symbol> visibleSymbols = this.getVisibleSymbols(context, context.range().getStart());
        List<Symbol> localVarSymbols = visibleSymbols.stream().filter(symbol -> symbol.kind() == SymbolKind.VARIABLE && symbol.getLocation().isPresent()).filter(symbol -> PositionUtil.isWithinLineRange(((Location)symbol.getLocation().get()).lineRange(), enclosingNode.lineRange())).toList();
        HashSet paramAndLocVarSymbolsVisibleToRange = visibleSymbols.stream().filter(symbol -> symbol.kind() == SymbolKind.PARAMETER).collect(Collectors.toCollection(HashSet::new));
        paramAndLocVarSymbolsVisibleToRange.addAll(localVarSymbols);
        paramAndLocVarSymbolsVisibleToRange.forEach(symbol -> {
            Optional<Location> anyLocationReferred = ((SemanticModel)context.currentSemanticModel().get()).references(symbol).stream().filter(location -> PositionUtil.isRangeWithinRange(PositionUtil.getRangeFromLineRange(location.lineRange()), context.range())).findAny();
            if (anyLocationReferred.isPresent()) {
                argsSymbolsForExtractFunction.add(symbol);
            }
        });
        if (argsSymbolsForExtractFunction.stream().anyMatch(symbol -> symbol.getLocation().isEmpty())) {
            return Optional.empty();
        }
        return Optional.of(argsSymbolsForExtractFunction.stream().sorted(Comparator.comparingInt(symbol -> ((Location)symbol.getLocation().get()).textRange().startOffset())).toList());
    }

    private List<CodeAction> getCodeActionsForExpressions(CodeActionContext context, RangeBasedPositionDetails posDetails) {
        NonTerminalNode matchedCodeActionNode = posDetails.matchedCodeActionNode();
        Node enclosingNode = this.findEnclosingModulePartNode(matchedCodeActionNode);
        boolean newLineAtEnd = this.addNewLineAtEnd(enclosingNode);
        Range functionInsertRange = PositionUtil.toRange(enclosingNode.lineRange().endLine());
        LSClientCapabilities lsClientCapabilities = (LSClientCapabilities)context.languageServercontext().get(LSClientCapabilities.class);
        if (CodeActionUtil.isRangeSelection(context.range()) || !lsClientCapabilities.getInitializationOptions().isQuickPickSupported()) {
            Optional typeSymbol = ((SemanticModel)context.currentSemanticModel().get()).typeOf((Node)matchedCodeActionNode);
            if (typeSymbol.isEmpty() || ((TypeSymbol)typeSymbol.get()).typeKind() == TypeDescKind.COMPILATION_ERROR) {
                return Collections.emptyList();
            }
            Optional<List<Symbol>> varAndParamSymbolsWithinRange = this.getVarAndParamSymbolsWithinRangeForExprs(matchedCodeActionNode.lineRange(), context);
            if (varAndParamSymbolsWithinRange.isEmpty()) {
                return Collections.emptyList();
            }
            Optional<ArgListsHolder> argLists = this.getArgLists(context, varAndParamSymbolsWithinRange.get(), matchedCodeActionNode);
            if (argLists.isEmpty()) {
                return Collections.emptyList();
            }
            List<String> argsForExtractFunction = argLists.get().extractFunctionArgs;
            List<String> argsForReplaceFunctionCall = argLists.get().replaceFunctionCallArgs;
            List<TextEdit> textEdits = this.getTextEdits(context, (Node)matchedCodeActionNode, newLineAtEnd, (TypeSymbol)typeSymbol.get(), argsForExtractFunction, argsForReplaceFunctionCall, functionInsertRange);
            CodeAction codeAction = CodeActionUtil.createCodeAction(NAME, textEdits, context.fileUri(), "refactor.extract");
            CodeActionUtil.addRenamePopup(context, codeAction, "Rename function", textEdits.get(1).getRange().getStart());
            return Collections.singletonList(codeAction);
        }
        ExpressionNodeValidator nodeValidator = new ExpressionNodeValidator();
        matchedCodeActionNode.accept((NodeVisitor)nodeValidator);
        if (nodeValidator.isInvalidNode().booleanValue()) {
            return Collections.emptyList();
        }
        LinkedHashMap textEditMap = new LinkedHashMap();
        LinkedHashMap renamePositionMap = new LinkedHashMap();
        List<NonTerminalNode> nodeList = this.getPossibleExpressionNodes(matchedCodeActionNode);
        nodeList.forEach(extractableNode -> {
            Optional tSymbol = context.currentSemanticModel().flatMap(semanticModel -> semanticModel.typeOf((Node)extractableNode));
            if (tSymbol.isEmpty() || ((TypeSymbol)tSymbol.get()).typeKind() == TypeDescKind.COMPILATION_ERROR) {
                return;
            }
            String key = extractableNode.toSourceCode().strip();
            Optional<List<Symbol>> varAndParamSymbolsWithinRange = this.getVarAndParamSymbolsWithinRangeForExprs(extractableNode.lineRange(), context);
            if (varAndParamSymbolsWithinRange.isEmpty()) {
                return;
            }
            Optional<ArgListsHolder> argListsHolder = this.getArgLists(context, varAndParamSymbolsWithinRange.get(), (NonTerminalNode)extractableNode);
            if (argListsHolder.isEmpty()) {
                return;
            }
            textEditMap.put(key, this.getTextEdits(context, (Node)extractableNode, newLineAtEnd, (TypeSymbol)tSymbol.get(), argListsHolder.get().extractFunctionArgs, argListsHolder.get().replaceFunctionCallArgs, functionInsertRange));
            renamePositionMap.put(key, PositionUtil.toRange(extractableNode.lineRange()).getStart());
        });
        if (lsClientCapabilities.getInitializationOptions().isPositionalRefactorRenameSupported()) {
            return Collections.singletonList(CodeActionUtil.createCodeAction(NAME, new Command(NAME, "ballerina.action.extract", List.of(NAME, context.filePath().toString(), textEditMap, renamePositionMap)), "refactor.extract"));
        }
        return Collections.singletonList(CodeActionUtil.createCodeAction(NAME, new Command(NAME, "ballerina.action.extract", List.of(NAME, context.filePath().toString(), textEditMap)), "refactor.extract"));
    }

    private String getFunctionName(CodeActionContext context, Node matchedNode) {
        List<Symbol> visibleSymbols = this.getVisibleSymbols(context, PositionUtil.toPosition(matchedNode.lineRange().endLine()));
        return FunctionGenerator.generateFunctionName(EXTRACTED_PREFIX, visibleSymbols);
    }

    private List<NonTerminalNode> getPossibleExpressionNodes(NonTerminalNode node) {
        ExpressionNodeValidator nodeValidator = new ExpressionNodeValidator();
        ArrayList<NonTerminalNode> nodeList = new ArrayList<NonTerminalNode>();
        while (node != null && !ExtractToFunctionCodeAction.isStatementOrModuleMemberDeclarationNode(node) && node.kind() != SyntaxKind.OBJECT_FIELD && !nodeValidator.isInvalidNode().booleanValue()) {
            nodeList.add(node);
            node = node.parent();
            node.accept((NodeVisitor)nodeValidator);
        }
        return nodeList;
    }

    private static boolean isStatementOrModuleMemberDeclarationNode(NonTerminalNode node) {
        return node instanceof StatementNode || node instanceof ModuleMemberDeclarationNode;
    }

    private List<TextEdit> getTextEdits(CodeActionContext context, Node matchedCodeActionNode, boolean newLineAtEnd, TypeSymbol typeSymbol, List<String> argsForExtractFunction, List<String> argsForReplaceFunctionCall, Range functionInsertRange) {
        String functionName = this.getFunctionName(context, matchedCodeActionNode);
        String function = this.getFunction(context, matchedCodeActionNode, newLineAtEnd, typeSymbol, functionName, argsForExtractFunction);
        String replaceFunctionCall = this.getReplaceFunctionCall(argsForReplaceFunctionCall, functionName, true);
        TextEdit extractFunctionEdit = new TextEdit(functionInsertRange, function);
        TextEdit replaceEdit = new TextEdit(PositionUtil.toRange(matchedCodeActionNode.lineRange()), replaceFunctionCall);
        return List.of(extractFunctionEdit, replaceEdit);
    }

    private List<Symbol> getVisibleSymbols(CodeActionContext context, Position position) {
        return ((SemanticModel)context.currentSemanticModel().get()).visibleSymbols((Document)context.currentDocument().get(), PositionUtil.getLinePosition(position));
    }

    private String getReplaceFunctionCall(List<String> varSymbolNames, String functionName, boolean isExpr) {
        String funcCall = functionName + "(" + String.join((CharSequence)", ", varSymbolNames) + ")";
        return isExpr ? funcCall : funcCall + ";";
    }

    private String getFunction(CodeActionContext context, Node matchedNode, boolean newLineEnd, TypeSymbol typeSymbol, String functionName, List<String> args) {
        String returnsClause = String.format("returns %s", FunctionGenerator.getReturnTypeAsString((DocumentServiceContext)context, typeSymbol.signature()));
        String returnStatement = matchedNode.kind() == SyntaxKind.BRACED_EXPRESSION ? String.format("return %s;", ((BracedExpressionNode)matchedNode).expression().toString().strip()) : String.format("return %s;", matchedNode.toString().strip());
        IsolatedBlockResolver isolatedBlockResolver = new IsolatedBlockResolver();
        Boolean isIsolated = isolatedBlockResolver.findIsolatedBlock(matchedNode);
        return FunctionGenerator.generateFunction(functionName, args, returnsClause, returnStatement, newLineEnd, isIsolated, "");
    }

    private Optional<List<Symbol>> getVarAndParamSymbolsWithinRangeForExprs(LineRange matchedLineRange, CodeActionContext context) {
        List<Symbol> varAndParamSymbols = this.getVisibleSymbols(context, PositionUtil.toPosition(matchedLineRange.endLine())).stream().filter(symbol -> symbol.kind() == SymbolKind.VARIABLE || symbol.kind() == SymbolKind.PARAMETER).filter(symbol -> ((SemanticModel)context.currentSemanticModel().get()).references(symbol).stream().anyMatch(location -> PositionUtil.isRangeWithinRange(PositionUtil.getRangeFromLineRange(location.lineRange()), PositionUtil.toRange(matchedLineRange)))).toList();
        if (varAndParamSymbols.stream().anyMatch(symbol -> symbol.getLocation().isEmpty())) {
            return Optional.empty();
        }
        return Optional.of(varAndParamSymbols.stream().filter(symbol -> !PositionUtil.isWithinLineRange(((Location)symbol.getLocation().get()).lineRange(), matchedLineRange)).sorted(Comparator.comparingInt(symbol -> ((Location)symbol.getLocation().get()).textRange().startOffset())).toList());
    }

    private Optional<ArgListsHolder> getArgLists(CodeActionContext context, List<Symbol> symbolsList, NonTerminalNode matchedCodeActionNode) {
        ArrayList<String> argsForExtractFunction = new ArrayList<String>();
        ArrayList<String> argsForReplaceFunctionCall = new ArrayList<String>();
        ArrayList<String> symbolNamesList = new ArrayList<String>();
        for (Symbol symbol : symbolsList) {
            if (symbol.getName().isEmpty()) {
                return Optional.empty();
            }
            symbolNamesList.add((String)symbol.getName().get());
        }
        ExtractToFunctionTypeFinder typeFinder = new ExtractToFunctionTypeFinder(symbolNamesList);
        typeFinder.findType(matchedCodeActionNode);
        Map<String, NonTerminalNode> symbolTypes = typeFinder.getSymbolTypes();
        ArrayList<String> sortedSymbolNames = new ArrayList<String>();
        for (Map.Entry<String, NonTerminalNode> entry : symbolTypes.entrySet()) {
            sortedSymbolNames.add(entry.getKey());
        }
        sortedSymbolNames.sort(Comparator.comparing(symbolNamesList::indexOf));
        for (String symbolName : sortedSymbolNames) {
            Optional typeSymbol = ((SemanticModel)context.currentSemanticModel().get()).typeOf((Node)symbolTypes.get(symbolName));
            if (typeSymbol.isEmpty()) {
                return Optional.empty();
            }
            Optional<String> possibleType = CodeActionUtil.getPossibleType((TypeSymbol)typeSymbol.get(), context);
            if (possibleType.isEmpty()) {
                return Optional.empty();
            }
            argsForExtractFunction.add(String.format("%s %s", possibleType.get(), symbolName));
            argsForReplaceFunctionCall.add(symbolName);
        }
        ArgListsHolder argListsHolder = new ArgListsHolder();
        argListsHolder.extractFunctionArgs = argsForExtractFunction;
        argListsHolder.replaceFunctionCallArgs = argsForReplaceFunctionCall;
        return Optional.of(argListsHolder);
    }

    private Node findEnclosingModulePartNode(NonTerminalNode node) {
        NonTerminalNode reference = node;
        while (reference.parent() != null && reference.parent().kind() != SyntaxKind.MODULE_PART) {
            reference = reference.parent();
        }
        return reference;
    }

    private boolean isWithinFunctionDefinitionNode(NonTerminalNode node) {
        for (NonTerminalNode reference = node; reference != null && reference.parent() != null; reference = reference.parent()) {
            SyntaxKind parentKind = reference.parent().kind();
            if (parentKind != SyntaxKind.FUNCTION_DEFINITION && parentKind != SyntaxKind.RESOURCE_ACCESSOR_DEFINITION && parentKind != SyntaxKind.OBJECT_METHOD_DEFINITION) continue;
            return true;
        }
        return false;
    }

    private boolean addNewLineAtEnd(Node enclosingNode) {
        for (Node node : enclosingNode.parent().children()) {
            if (node.lineRange().startLine().line() != enclosingNode.lineRange().endLine().line() + 1) continue;
            return true;
        }
        return false;
    }

    private static boolean isExpressionNode(NonTerminalNode node) {
        return node.kind().compareTo((Enum)SyntaxKind.BINARY_EXPRESSION) >= 0 && node.kind().compareTo((Enum)SyntaxKind.TYPE_DESC) < 0;
    }

    private boolean isExpressionExtractable(RangeBasedPositionDetails positionDetails) {
        NonTerminalNode node = positionDetails.matchedCodeActionNode();
        Node enclosingModulePartNode = this.findEnclosingModulePartNode(node);
        SyntaxKind nodeKind = node.kind();
        SyntaxKind parentKind = node.parent().kind();
        return !(unSupportedModuleLevelSyntaxKinds.contains(enclosingModulePartNode.kind()) || nodeKind == SyntaxKind.MAPPING_CONSTRUCTOR && parentKind == SyntaxKind.TABLE_CONSTRUCTOR || nodeKind == SyntaxKind.STRING_LITERAL && parentKind == SyntaxKind.SPECIFIC_FIELD || nodeKind == SyntaxKind.QUALIFIED_NAME_REFERENCE && parentKind == SyntaxKind.FUNCTION_CALL || nodeKind == SyntaxKind.FIELD_ACCESS && (((FieldAccessExpressionNode)node).expression().toSourceCode().strip().equals("self") || parentKind == SyntaxKind.ASSIGNMENT_STATEMENT && ((AssignmentStatementNode)node.parent()).varRef().equals(node) || parentKind == SyntaxKind.COMPOUND_ASSIGNMENT_STATEMENT && ((CompoundAssignmentStatementNode)node.parent()).lhsExpression().equals(node)));
    }

    public static List<SyntaxKind> getSupportedExpressionSyntaxKindsList() {
        return List.of(SyntaxKind.BINARY_EXPRESSION, SyntaxKind.BRACED_EXPRESSION, SyntaxKind.QUALIFIED_NAME_REFERENCE, SyntaxKind.INDEXED_EXPRESSION, SyntaxKind.FIELD_ACCESS, SyntaxKind.METHOD_CALL, SyntaxKind.MAPPING_CONSTRUCTOR, SyntaxKind.TYPEOF_EXPRESSION, SyntaxKind.UNARY_EXPRESSION, SyntaxKind.TYPE_TEST_EXPRESSION, SyntaxKind.SIMPLE_NAME_REFERENCE, SyntaxKind.LIST_CONSTRUCTOR, SyntaxKind.TYPE_CAST_EXPRESSION, SyntaxKind.TABLE_CONSTRUCTOR, SyntaxKind.LET_EXPRESSION, SyntaxKind.IMPLICIT_NEW_EXPRESSION, SyntaxKind.EXPLICIT_NEW_EXPRESSION, SyntaxKind.STRING_LITERAL, SyntaxKind.NUMERIC_LITERAL, SyntaxKind.BOOLEAN_LITERAL, SyntaxKind.ERROR_CONSTRUCTOR);
    }

    public static List<SyntaxKind> getSupportedStatementSyntaxKindsList() {
        return List.of(SyntaxKind.LIST, SyntaxKind.LOCAL_VAR_DECL, SyntaxKind.ASSIGNMENT_STATEMENT, SyntaxKind.IF_ELSE_STATEMENT, SyntaxKind.WHILE_STATEMENT, SyntaxKind.COMPOUND_ASSIGNMENT_STATEMENT, SyntaxKind.LOCK_STATEMENT, SyntaxKind.FOREACH_STATEMENT, SyntaxKind.MATCH_STATEMENT, SyntaxKind.DO_STATEMENT);
    }

    public String getName() {
        return NAME;
    }

    private static class ArgListsHolder {
        private List<String> extractFunctionArgs;
        private List<String> replaceFunctionCallArgs;

        private ArgListsHolder() {
        }
    }

    static class ExtractToFunctionTypeFinder
    extends NodeVisitor {
        List<String> symbolNamesList;
        Map<String, NonTerminalNode> nodeList = new LinkedHashMap<String, NonTerminalNode>();

        public ExtractToFunctionTypeFinder(List<String> symbolNamesList) {
            this.symbolNamesList = symbolNamesList;
        }

        public Map<String, NonTerminalNode> getSymbolTypes() {
            return this.nodeList;
        }

        public void findType(NonTerminalNode matchedCodeActionNode) {
            if (matchedCodeActionNode.kind() == SyntaxKind.LIST) {
                for (Node node : matchedCodeActionNode.children()) {
                    node.accept((NodeVisitor)this);
                }
                return;
            }
            matchedCodeActionNode.accept((NodeVisitor)this);
        }

        public void visit(SimpleNameReferenceNode simpleNameReferenceNode) {
            this.symbolNamesList.stream().filter(symbolName -> !this.nodeList.containsKey(symbolName) && symbolName.equals(simpleNameReferenceNode.name().text())).findFirst().ifPresent(symbolName -> this.nodeList.put((String)symbolName, (NonTerminalNode)simpleNameReferenceNode));
        }
    }
}

