/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.FieldBindingPatternVarnameNode;
import io.ballerina.compiler.syntax.tree.LetVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.common.utils.SymbolUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagBasedPositionDetails;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagnosticBasedCodeActionProvider;
import org.ballerinalang.langserver.references.ReferencesUtil;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.ballerinalang.util.diagnostic.DiagnosticWarningCode;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class IgnoreUnusedVariableCodeAction
implements DiagnosticBasedCodeActionProvider {
    private static final String NAME = "IGNORE_VARIABLE";
    private static final Set<String> DIAGNOSTIC_CODES = Set.of(DiagnosticWarningCode.UNUSED_LOCAL_VARIABLE.diagnosticId(), DiagnosticErrorCode.NO_NEW_VARIABLES_VAR_ASSIGNMENT.diagnosticId());

    public boolean validate(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        return DIAGNOSTIC_CODES.contains(diagnostic.diagnosticInfo().code()) && CodeActionNodeValidator.validate(context.nodeAtRange());
    }

    public List<CodeAction> getCodeActions(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        Range range = PositionUtil.toRange(diagnostic.location().lineRange());
        Optional nonTerminalNode = context.currentSyntaxTree().flatMap(syntaxTree -> Optional.ofNullable(CommonUtil.findNode(range, syntaxTree)));
        if (nonTerminalNode.isEmpty()) {
            return Collections.emptyList();
        }
        NonTerminalNode node = (NonTerminalNode)nonTerminalNode.get();
        if (node.kind() == SyntaxKind.SIMPLE_NAME_REFERENCE) {
            node = node.parent();
        }
        BindingPatternNode bindingPatternNode = null;
        if (node.kind() == SyntaxKind.LOCAL_VAR_DECL) {
            VariableDeclarationNode varDeclNode = (VariableDeclarationNode)node;
            if (varDeclNode.initializer().isPresent()) {
                bindingPatternNode = varDeclNode.typedBindingPattern().bindingPattern();
            }
        } else if (node.kind() == SyntaxKind.TYPED_BINDING_PATTERN) {
            TypedBindingPatternNode typedBindingPatternNode = (TypedBindingPatternNode)node;
            bindingPatternNode = typedBindingPatternNode.bindingPattern();
        } else if (node.kind() == SyntaxKind.CAPTURE_BINDING_PATTERN || node.kind() == SyntaxKind.FIELD_BINDING_PATTERN || node.kind() == SyntaxKind.MAPPING_BINDING_PATTERN || node.kind() == SyntaxKind.LIST_BINDING_PATTERN) {
            bindingPatternNode = (BindingPatternNode)node;
        } else if (node.kind() == SyntaxKind.LET_VAR_DECL) {
            bindingPatternNode = ((LetVariableDeclarationNode)node).typedBindingPattern().bindingPattern();
        }
        if (bindingPatternNode == null) {
            return Collections.emptyList();
        }
        if (bindingPatternNode.kind() == SyntaxKind.CAPTURE_BINDING_PATTERN && !this.isSubTypeOfAny(bindingPatternNode, context)) {
            return Collections.emptyList();
        }
        if (bindingPatternNode.kind() == SyntaxKind.CAPTURE_BINDING_PATTERN) {
            BindingPatternNode finalBindingPatternNode = bindingPatternNode;
            Optional<Integer> refCount = context.currentSemanticModel().flatMap(semanticModel -> semanticModel.symbol((Node)finalBindingPatternNode)).flatMap(symbol -> context.workspace().project(context.filePath()).map(project -> ReferencesUtil.getReferences(project, symbol))).map(modRefMap -> modRefMap.values().stream().map(List::size).reduce(0, Integer::sum));
            if (refCount.isPresent() && refCount.get() > 1) {
                return Collections.emptyList();
            }
        }
        TextEdit textEdit = null;
        if (bindingPatternNode.kind() == SyntaxKind.CAPTURE_BINDING_PATTERN || bindingPatternNode.kind() == SyntaxKind.MAPPING_BINDING_PATTERN || bindingPatternNode.kind() == SyntaxKind.LIST_BINDING_PATTERN) {
            Range editRange = PositionUtil.toRange(bindingPatternNode.lineRange());
            textEdit = new TextEdit(editRange, "_");
        } else if (bindingPatternNode.kind() == SyntaxKind.FIELD_BINDING_PATTERN && bindingPatternNode instanceof FieldBindingPatternVarnameNode) {
            FieldBindingPatternVarnameNode fieldBindingPattern = (FieldBindingPatternVarnameNode)bindingPatternNode;
            Position position = PositionUtil.toPosition(fieldBindingPattern.variableName().lineRange().endLine());
            Range editRange = new Range(position, position);
            textEdit = new TextEdit(editRange, ": _");
        }
        if (textEdit == null) {
            return Collections.emptyList();
        }
        return List.of(CodeActionUtil.createCodeAction("Ignore unused variable", List.of(textEdit), context.fileUri(), "quickfix"));
    }

    private boolean isSubTypeOfAny(BindingPatternNode bindingPatternNode, CodeActionContext context) {
        Optional semanticModel = context.currentSemanticModel();
        if (semanticModel.isEmpty()) {
            return false;
        }
        Optional typeSymbol = ((SemanticModel)semanticModel.get()).symbol((Node)bindingPatternNode).flatMap(SymbolUtil::getTypeDescriptor);
        if (typeSymbol.isEmpty()) {
            return false;
        }
        return ((TypeSymbol)typeSymbol.get()).subtypeOf(((SemanticModel)semanticModel.get()).types().ANY);
    }

    public String getName() {
        return NAME;
    }
}

