/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.codeaction.spi.RangeBasedCodeActionProvider;
import org.ballerinalang.langserver.commons.codeaction.spi.RangeBasedPositionDetails;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.TextEdit;

public class SetterCodeAction
implements RangeBasedCodeActionProvider {
    public static final String NAME = "Setter";

    public List<SyntaxKind> getSyntaxKinds() {
        return List.of(SyntaxKind.OBJECT_FIELD);
    }

    public List<CodeAction> getCodeActions(CodeActionContext context, RangeBasedPositionDetails posDetails) {
        if (CodeActionUtil.getObjectFieldNode(context, posDetails).isEmpty()) {
            return Collections.emptyList();
        }
        ObjectFieldNode objectFieldNode = CodeActionUtil.getObjectFieldNode(context, posDetails).get();
        if (CodeActionUtil.isImmutableObjectField(objectFieldNode)) {
            return Collections.emptyList();
        }
        String fieldName = String.valueOf(objectFieldNode.fieldName().text());
        String commandTitle = String.format("Create a setter for \"%s\"", fieldName);
        String typeName = String.valueOf(objectFieldNode.typeName()).trim();
        String extractedFieldName = CodeActionUtil.removeQuotedIdentifier(fieldName);
        String functionName = "set" + extractedFieldName.substring(0, 1).toUpperCase(Locale.ROOT) + extractedFieldName.substring(1);
        if (CodeActionUtil.isFunctionDefined(functionName, objectFieldNode)) {
            return Collections.emptyList();
        }
        Optional<FunctionDefinitionNode> initNode = CodeActionUtil.getInitNode(objectFieldNode);
        List<TextEdit> edits = CodeActionUtil.getGetterSetterCodeEdits(objectFieldNode, initNode, fieldName, typeName, NAME);
        return Collections.singletonList(CodeActionUtil.createCodeAction(commandTitle, edits, context.fileUri(), "source"));
    }

    public String getName() {
        return NAME;
    }
}

