/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers.createvar;

import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Qualifiable;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.projects.Module;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.codeaction.providers.createvar.CreateVariableCodeAction;
import org.ballerinalang.langserver.common.ImportsAcceptor;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagBasedPositionDetails;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class ErrorHandleOutsideCodeAction
extends CreateVariableCodeAction {
    public static final String NAME = "Error Handle Outside";

    @Override
    public int priority() {
        return 998;
    }

    @Override
    public boolean validate(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        return diagnostic.message().contains("variable assignment is required") && CodeActionNodeValidator.validate(context.nodeAtRange());
    }

    @Override
    public List<CodeAction> getCodeActions(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        String uri = context.fileUri();
        Optional<TypeSymbol> typeSymbol = this.getExpectedTypeSymbol(positionDetails);
        if (typeSymbol.isEmpty() || typeSymbol.get().typeKind() != TypeDescKind.UNION || this.isCompilationErrorTyped((UnionTypeSymbol)typeSymbol.get())) {
            return Collections.emptyList();
        }
        UnionTypeSymbol unionTypeDesc = (UnionTypeSymbol)typeSymbol.get();
        List<TypeSymbol> errorMemberTypes = CommonUtil.extractErrorTypesFromUnion(unionTypeDesc);
        Path path = Path.of(URI.create(uri.replace("expr:///", "file:///")));
        Optional module = context.workspace().module(path);
        if (module.isPresent() && ErrorHandleOutsideCodeAction.containsModuleLevelPrivateTypes(((Module)module.get()).moduleName().toString(), errorMemberTypes)) {
            return Collections.emptyList();
        }
        long nonErrorNonNilMemberCount = unionTypeDesc.memberTypeDescriptors().stream().filter(member -> CommonUtil.getRawType(member).typeKind() != TypeDescKind.ERROR && member.typeKind() != TypeDescKind.NIL).count();
        if (errorMemberTypes.isEmpty() || nonErrorNonNilMemberCount == 0L) {
            return Collections.emptyList();
        }
        ImportsAcceptor importsAcceptor = new ImportsAcceptor((DocumentServiceContext)context);
        CreateVariableCodeAction.CreateVariableOut modifiedTextEdits = this.getModifiedCreateVarTextEdits(diagnostic, unionTypeDesc, positionDetails, typeSymbol.get(), context, importsAcceptor);
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>(modifiedTextEdits.edits);
        List<TextEdit> addCheckTextEdits = CodeActionUtil.getAddCheckTextEdits(PositionUtil.toRange(diagnostic.location().lineRange()).getStart(), positionDetails.matchedNode(), context, errorMemberTypes, importsAcceptor);
        edits.addAll(addCheckTextEdits);
        edits.addAll(importsAcceptor.getNewImportTextEdits());
        CodeAction codeAction = CodeActionUtil.createCodeAction("Create variable and check error", edits, uri, "quickfix");
        this.addRenamePopup(context, codeAction, modifiedTextEdits.varRenamePosition.get(0), modifiedTextEdits.imports.size());
        return Collections.singletonList(codeAction);
    }

    private static boolean containsModuleLevelPrivateTypes(String currentModule, List<TypeSymbol> errorMemberTypes) {
        for (TypeSymbol errorMemType : errorMemberTypes) {
            Qualifiable qualifiable;
            Symbol typeDef;
            Optional module;
            if (errorMemType.typeKind() != TypeDescKind.TYPE_REFERENCE || (module = errorMemType.getModule()).isEmpty() || currentModule.equals(((ModuleSymbol)module.get()).id().moduleName()) || !((typeDef = ((TypeReferenceTypeSymbol)errorMemType).definition()) instanceof Qualifiable) || (qualifiable = (Qualifiable)typeDef).qualifiers().contains(Qualifier.PUBLIC)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return NAME;
    }

    private CreateVariableCodeAction.CreateVariableOut getModifiedCreateVarTextEdits(Diagnostic diagnostic, UnionTypeSymbol unionTypeDesc, DiagBasedPositionDetails positionDetails, TypeSymbol typeSymbol, CodeActionContext context, ImportsAcceptor importsAcceptor) {
        Range range = PositionUtil.toRange(diagnostic.location().lineRange());
        CreateVariableCodeAction.CreateVariableOut createVarTextEdits = this.getCreateVariableTextEdits(range, positionDetails, typeSymbol, context, importsAcceptor);
        String typeWithError = createVarTextEdits.types.get(0);
        String typeWithoutError = this.getTypeWithoutError(unionTypeDesc, context, importsAcceptor);
        int lengthDiff = typeWithError.length() - typeWithoutError.length();
        Position varRenamePosition = createVarTextEdits.varRenamePosition.get(0);
        varRenamePosition.setCharacter(varRenamePosition.getCharacter() - lengthDiff);
        Integer renamePos = createVarTextEdits.renamePositions.get(0);
        createVarTextEdits.renamePositions.add(0, renamePos - lengthDiff);
        TextEdit textEdit = createVarTextEdits.edits.get(0);
        textEdit.setNewText(typeWithoutError + textEdit.getNewText().substring(typeWithError.length()));
        return createVarTextEdits;
    }

    private String getTypeWithoutError(UnionTypeSymbol unionTypeDesc, CodeActionContext context, ImportsAcceptor importsAcceptor) {
        return unionTypeDesc.memberTypeDescriptors().stream().filter(member -> CommonUtil.getRawType(member).typeKind() != TypeDescKind.ERROR).map(typeDesc -> CodeActionUtil.getPossibleType(typeDesc, context, importsAcceptor).orElseThrow()).collect(Collectors.joining("|"));
    }
}

