/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers.createvar;

import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.codeaction.providers.createvar.CreateVariableCodeAction;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagBasedPositionDetails;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class IgnoreReturnCodeAction
extends CreateVariableCodeAction {
    public static final String NAME = "Ignore Return Type";

    @Override
    public boolean validate(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        return diagnostic.message().contains("variable assignment is required") && CodeActionNodeValidator.validate(context.nodeAtRange());
    }

    @Override
    public List<CodeAction> getCodeActions(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        Optional<TypeSymbol> typeDescriptor = this.getExpectedTypeSymbol(positionDetails);
        if (typeDescriptor.isEmpty()) {
            return Collections.emptyList();
        }
        String uri = context.fileUri();
        Position pos = PositionUtil.toRange(diagnostic.location().lineRange()).getStart();
        if (!this.hasErrorType(typeDescriptor.get())) {
            String commandTitle = "Ignore return value";
            return Collections.singletonList(CodeActionUtil.createCodeAction(commandTitle, IgnoreReturnCodeAction.getIgnoreCodeActionEdits(pos), uri, "quickfix"));
        }
        return Collections.emptyList();
    }

    @Override
    public String getName() {
        return NAME;
    }

    private boolean hasErrorType(TypeSymbol typeSymbol) {
        if (typeSymbol.typeKind() == TypeDescKind.ERROR) {
            return true;
        }
        if (typeSymbol.typeKind() == TypeDescKind.UNION) {
            UnionTypeSymbol unionType = (UnionTypeSymbol)typeSymbol;
            return CodeActionUtil.hasErrorMemberType(unionType);
        }
        return false;
    }

    private static List<TextEdit> getIgnoreCodeActionEdits(Position position) {
        String editText = "_ = ";
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        edits.add(new TextEdit(new Range(position, position), editText));
        return edits;
    }
}

