/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers.imports;

import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagBasedPositionDetails;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagnosticBasedCodeActionProvider;
import org.ballerinalang.langserver.commons.command.CommandArgument;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;

public class PullModuleCodeAction
implements DiagnosticBasedCodeActionProvider {
    public static final String NAME = "Pull Module";
    private static final int MISSING_MODULE_NAME_INDEX = 0;

    public boolean validate(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        return CodeActionNodeValidator.validate(context.nodeAtRange());
    }

    public List<CodeAction> getCodeActions(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        Optional<String> moduleName = PullModuleCodeAction.getMissingModuleNameFromDiagnostic(diagnostic);
        if (moduleName.isEmpty()) {
            return Collections.emptyList();
        }
        CommandArgument uriArg = CommandArgument.from((String)"doc.uri", (Object)context.fileUri());
        ArrayList<CommandArgument> args = new ArrayList<CommandArgument>();
        args.add(uriArg);
        args.add(CommandArgument.from((String)"module", (Object)moduleName.get()));
        String commandTitle = "Pull unresolved modules";
        Command command = new Command(commandTitle, "PULL_MODULE", args);
        CodeAction action = CodeActionUtil.createCodeAction(commandTitle, command, "quickfix");
        return Collections.singletonList(action);
    }

    public String getName() {
        return NAME;
    }

    public static Optional<String> getMissingModuleNameFromDiagnostic(Diagnostic diagnostic) {
        if (!DiagnosticErrorCode.MODULE_NOT_FOUND.diagnosticId().equals(diagnostic.diagnosticInfo().code())) {
            return Optional.empty();
        }
        List properties = diagnostic.properties();
        if (properties.size() <= 0) {
            return Optional.empty();
        }
        DiagnosticProperty diagnosticProperty = (DiagnosticProperty)properties.get(0);
        return Optional.of((String)diagnosticProperty.value());
    }
}

