/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.command.spi.LSCommandExecutor;

public class LSCommandExecutorProvidersHolder {
    private static final Map<String, LSCommandExecutor> executors = new HashMap<String, LSCommandExecutor>();
    private static final LanguageServerContext.Key<LSCommandExecutorProvidersHolder> CMD_EXEC_PROVIDERS_HOLDER_KEY = new LanguageServerContext.Key();

    public static LSCommandExecutorProvidersHolder getInstance(LanguageServerContext serverContext) {
        LSCommandExecutorProvidersHolder executorProvidersHolder = (LSCommandExecutorProvidersHolder)serverContext.get(CMD_EXEC_PROVIDERS_HOLDER_KEY);
        if (executorProvidersHolder == null) {
            executorProvidersHolder = new LSCommandExecutorProvidersHolder(serverContext);
        }
        return executorProvidersHolder;
    }

    private LSCommandExecutorProvidersHolder(LanguageServerContext serverContext) {
        serverContext.put(CMD_EXEC_PROVIDERS_HOLDER_KEY, (Object)this);
        this.loadServices();
    }

    private void loadServices() {
        ServiceLoader<LSCommandExecutor> loader = ServiceLoader.load(LSCommandExecutor.class);
        for (LSCommandExecutor executor : loader) {
            if (executor == null) continue;
            executors.put(executor.getCommand(), executor);
        }
    }

    public Optional<LSCommandExecutor> getCommandExecutor(String command) {
        return Optional.ofNullable(executors.get(command));
    }

    public List<String> getCommandsList() {
        return new ArrayList<String>(executors.keySet());
    }
}

