/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Trie {
    public TrieNode root = new TrieNode();

    public Trie(List<String> words) {
        for (String word : words) {
            this.root.insert(word);
        }
    }

    public boolean find(String prefix, boolean exact) {
        TrieNode lastNode = this.root;
        for (char character : prefix.toCharArray()) {
            lastNode = lastNode.children.get(Character.valueOf(character));
            if (lastNode != null) continue;
            return false;
        }
        return !exact || lastNode.isWord;
    }

    public boolean find(String prefix) {
        return this.find(prefix, false);
    }

    public void suggestHelper(TrieNode root, List<String> list, StringBuilder stringBuilder) {
        if (root.isWord) {
            list.add(stringBuilder.toString());
        }
        if (root.children == null || root.children.isEmpty()) {
            return;
        }
        for (TrieNode child : root.children.values()) {
            stringBuilder.append(child.character);
            this.suggestHelper(child, list, stringBuilder);
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
    }

    public List<String> suggest(String prefix) {
        ArrayList<String> list = new ArrayList<String>();
        TrieNode lastNode = this.root;
        StringBuilder stringBuilder = new StringBuilder();
        for (char character : prefix.toCharArray()) {
            lastNode = lastNode.children.get(Character.valueOf(character));
            if (lastNode == null) {
                return list;
            }
            stringBuilder.append(character);
        }
        this.suggestHelper(lastNode, list, stringBuilder);
        return list;
    }

    public static class TrieNode {
        Map<Character, TrieNode> children;
        char character;
        boolean isWord;

        public TrieNode(char character) {
            this.character = character;
            this.children = new HashMap<Character, TrieNode>();
        }

        public TrieNode() {
            this.children = new HashMap<Character, TrieNode>();
        }

        public void insert(String word) {
            if (word == null || word.isEmpty()) {
                return;
            }
            char firstCharacter = word.charAt(0);
            TrieNode child = this.children.get(Character.valueOf(firstCharacter));
            if (child == null) {
                child = new TrieNode(firstCharacter);
                this.children.put(Character.valueOf(firstCharacter), child);
            }
            if (word.length() > 1) {
                child.insert(word.substring(1));
            } else {
                child.isWord = true;
            }
        }
    }
}

