/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.common.utils;

import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxInfo;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.tools.text.TextRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.RawTypeSymbolWrapper;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;

public final class NameUtil {
    private NameUtil() {
    }

    public static String generateName(int value, Set<String> argNames) {
        StringBuilder result = new StringBuilder();
        int index = value;
        while (--index >= 0) {
            result.insert(0, (char)(97 + index % 26));
            index /= 26;
        }
        while (argNames.contains(result.toString())) {
            result = new StringBuilder(NameUtil.generateName(++value, argNames));
        }
        return result.toString();
    }

    public static String generateVariableName(Symbol symbol, TypeSymbol typeSymbol, Set<String> names) {
        if (symbol != null && symbol.getName().isPresent() && !((String)symbol.getName().get()).isEmpty()) {
            return NameUtil.generateVariableName(1, (String)symbol.getName().get(), names);
        }
        if (typeSymbol != null) {
            String name;
            if (typeSymbol.typeKind() == TypeDescKind.TYPE_REFERENCE && typeSymbol.getName().isPresent() && !((String)typeSymbol.getName().get()).startsWith("$")) {
                name = (String)typeSymbol.getName().get();
            } else {
                TypeSymbol rawType = CommonUtil.getRawType(typeSymbol);
                name = NameUtil.generateNameForRawType(rawType.typeKind());
            }
            return NameUtil.generateVariableName(1, name, names);
        }
        return NameUtil.generateName(1, names);
    }

    public static String generateVariableName(String signature, Set<String> names) {
        try {
            TypeDescKind typeDescKind = TypeDescKind.valueOf((String)signature);
            return NameUtil.generateVariableName(1, NameUtil.generateNameForRawType(typeDescKind), names);
        }
        catch (IllegalArgumentException ignored) {
            String camelCase = NameUtil.toCamelCase(signature);
            return NameUtil.generateVariableName(1, camelCase, names);
        }
    }

    public static String generateTypeName(String prefix, Set<String> visibleSymbolNames) {
        Object typeName = prefix;
        int idx = 0;
        while (visibleSymbolNames.contains(typeName) || CommonUtil.BALLERINA_KEYWORDS.contains(typeName)) {
            typeName = prefix + ++idx;
        }
        return typeName;
    }

    public static String generateParameterName(String arg, int position, TypeSymbol type, Set<String> visibleNames) {
        if (arg.isEmpty() || !SyntaxInfo.isIdentifier((String)arg)) {
            String typeName;
            String string = typeName = type != null ? type.typeKind().getName() : "";
            if (!typeName.isEmpty()) {
                String newName = typeName.substring(0, 1).toLowerCase(Locale.getDefault());
                return NameUtil.toCamelCase(NameUtil.getValidatedSymbolName(visibleNames, newName));
            }
            return NameUtil.generateName(position, visibleNames);
        }
        return NameUtil.toCamelCase(NameUtil.getValidatedSymbolName(visibleNames, arg));
    }

    public static String getValidatedSymbolName(Set<String> visibleNames, String symbolName) {
        if (!visibleNames.contains(symbolName)) {
            return symbolName;
        }
        List<Integer> suffixList = visibleNames.parallelStream().map(sName -> {
            if (sName == null) {
                return -2;
            }
            if (sName.equals(symbolName)) {
                return 0;
            }
            String modifiedName = sName.replaceFirst(symbolName, "");
            if (!modifiedName.isEmpty() && modifiedName.chars().allMatch(Character::isDigit)) {
                return Integer.parseInt(modifiedName);
            }
            return -3;
        }).filter(integer -> integer >= 0).sorted().toList();
        for (int i = 0; i < suffixList.size(); ++i) {
            Integer suffix = suffixList.get(i);
            if (i != suffixList.size() - 1 && suffix + 1 == suffixList.get(i + 1)) continue;
            return symbolName + (suffix + 1);
        }
        return symbolName;
    }

    public static String getValidatedSymbolName(PositionedOperationContext context, String symbolName) {
        List symbols = context.visibleSymbols(context.getCursorPosition());
        Set<String> visibleSymbolNames = symbols.stream().map(Symbol::getName).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        return NameUtil.getValidatedSymbolName(visibleSymbolNames, symbolName);
    }

    public static String getModifiedTypeName(DocumentServiceContext context, TypeSymbol typeSymbol) {
        String typeSignature = typeSymbol.typeKind() == TypeDescKind.COMPILATION_ERROR ? "" : typeSymbol.signature();
        return CommonUtil.getModifiedSignature(context, typeSignature);
    }

    public static String getRecordTypeName(DocumentServiceContext context, RawTypeSymbolWrapper<RecordTypeSymbol> wrapper) {
        if (wrapper.getRawType().getName().isPresent()) {
            return NameUtil.getModifiedTypeName(context, (TypeSymbol)wrapper.getRawType());
        }
        if (wrapper.getBroaderType().getName().isPresent()) {
            return NameUtil.getModifiedTypeName(context, wrapper.getBroaderType());
        }
        return wrapper.getRawType().signature();
    }

    public static List<String> getDefinedArgumentNames(BallerinaCompletionContext context, List<ParameterSymbol> params, SeparatedNodeList<FunctionArgumentNode> argumentNodeList) {
        ArrayList<String> existingArgNames = new ArrayList<String>();
        int cursorPosition = context.getCursorPositionInTree();
        int index = 1;
        for (Node child : argumentNodeList) {
            TextRange textRange = child.textRange();
            int startOffset = textRange.startOffset();
            int endOffset = textRange.endOffset();
            if (startOffset > cursorPosition || endOffset < cursorPosition) {
                if (child.kind() == SyntaxKind.NAMED_ARG) {
                    existingArgNames.add(((NamedArgumentNode)child).argumentName().name().text());
                } else if (child.kind() == SyntaxKind.POSITIONAL_ARG && index - 1 < params.size()) {
                    ParameterSymbol parameterSymbol = params.get(index - 1);
                    existingArgNames.add(parameterSymbol.getName().orElse(""));
                }
            }
            ++index;
        }
        return existingArgNames;
    }

    private static String generateNameForRawType(TypeDescKind rawType) {
        return switch (rawType) {
            case TypeDescKind.RECORD -> "mappingResult";
            case TypeDescKind.TUPLE, TypeDescKind.ARRAY -> "listResult";
            default -> rawType.getName() + "Result";
        };
    }

    private static String toCamelCase(String text) {
        String[] words = text.split("[\\W_]+");
        StringBuilder result = new StringBuilder();
        if (words.length == 1) {
            if (!StringUtils.isAllUpperCase((CharSequence)words[0])) {
                Object word = words[0];
                word = Character.toLowerCase(((String)word).charAt(0)) + ((String)word).substring(1);
                return word;
            }
            return words[0];
        }
        for (int i = 0; i < words.length; ++i) {
            Object word = words[i];
            if (((String)word).isEmpty()) continue;
            word = i == 0 ? ((String)word).toLowerCase() : Character.toUpperCase(((String)word).charAt(0)) + ((String)word).substring(1).toLowerCase();
            result.append((String)word);
        }
        return result.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String generateVariableName(int suffix, String name, Set<String> names) {
        names.addAll(CommonUtil.BALLERINA_KEYWORDS);
        Object newName = name.replaceAll(".+[\\:\\.]", "");
        if (suffix == 1 && !name.isEmpty()) {
            BiFunction<String, String, String> replacer = (search, text) -> text.startsWith((String)search) ? text.replaceFirst((String)search, "") : text;
            newName = replacer.apply("get", (String)newName);
            newName = replacer.apply("put", (String)newName);
            newName = replacer.apply("delete", (String)newName);
            newName = replacer.apply("update", (String)newName);
            newName = replacer.apply("set", (String)newName);
            newName = replacer.apply("add", (String)newName);
            newName = replacer.apply("create", (String)newName);
            newName = replacer.apply("to", (String)newName);
            while (((String)newName).contains("_")) {
                String[] parts = ((String)newName).split("_");
                List<String> restParts = Arrays.stream(parts, 1, parts.length).toList();
                newName = parts[0] + StringUtils.capitalize((String)String.join((CharSequence)"", restParts));
            }
            if (((String)newName).isEmpty()) {
                newName = name;
            }
            newName = ((String)newName).substring(0, 1).toLowerCase(Locale.getDefault()) + ((String)newName).substring(1);
            boolean alreadyExists = false;
            String[] specialSuffixes = new String[]{"Result", "Out", "Value"};
            boolean[] flagSpecialSuffixes = new boolean[specialSuffixes.length];
            boolean addNoSpecialSuffix = false;
            for (String currentSuffix : specialSuffixes) {
                if (!((String)newName).endsWith(currentSuffix)) continue;
                addNoSpecialSuffix = true;
                break;
            }
            for (String nextName : names) {
                if (nextName.equals(newName)) {
                    alreadyExists = true;
                    continue;
                }
                if (addNoSpecialSuffix) continue;
                for (int i = 0; i < specialSuffixes.length; ++i) {
                    String currentSuffix;
                    currentSuffix = specialSuffixes[i];
                    if (!nextName.equals((String)newName + currentSuffix)) continue;
                    flagSpecialSuffixes[i] = true;
                }
            }
            if (alreadyExists) {
                if (addNoSpecialSuffix) return NameUtil.generateVariableName(++suffix, (String)newName, names);
                for (int i = 0; i < flagSpecialSuffixes.length; ++i) {
                    if (flagSpecialSuffixes[i]) continue;
                    newName = (String)newName + specialSuffixes[i];
                    break;
                }
            }
        } else {
            newName = (String)newName + suffix;
        }
        while (names.contains(newName)) {
            newName = NameUtil.generateName(++suffix, names);
        }
        return newName;
    }
}

