/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.common.utils;

import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ParameterKind;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.NewExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.RemoteMethodCallActionNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.DocumentServiceContext;

public final class TypeResolverUtil {
    private TypeResolverUtil() {
    }

    public static Optional<TypeSymbol> getPositionalArgumentTypeForFunction(NodeList<FunctionArgumentNode> argumentNodes, NonTerminalNode functionOrMethodCallExpr, DocumentServiceContext context, int cursorPosition) {
        Optional<FunctionTypeSymbol> langLibMethod;
        FunctionTypeSymbol functionTypeSymbol = null;
        boolean isLangLibMethod = false;
        if (functionOrMethodCallExpr.kind() == SyntaxKind.METHOD_CALL && (langLibMethod = TypeResolverUtil.findMethodInLangLibFunctions((MethodCallExpressionNode)functionOrMethodCallExpr, context)).isPresent()) {
            functionTypeSymbol = langLibMethod.get();
            isLangLibMethod = true;
        }
        if (functionTypeSymbol == null) {
            functionTypeSymbol = context.currentSemanticModel().flatMap(semanticModel -> semanticModel.symbol((Node)functionOrMethodCallExpr)).filter(symbol -> symbol.kind() == SymbolKind.FUNCTION || symbol.kind() == SymbolKind.METHOD || symbol.kind() == SymbolKind.RESOURCE_METHOD).map(symbol -> ((FunctionSymbol)symbol).typeDescriptor()).orElse(null);
        }
        if (functionTypeSymbol == null) {
            return Optional.empty();
        }
        return TypeResolverUtil.resolveParameterTypeSymbol(functionTypeSymbol, argumentNodes, isLangLibMethod, cursorPosition);
    }

    public static Optional<TypeSymbol> getPositionalArgumentTypeForNewExpr(NodeList<FunctionArgumentNode> argumentNodes, NewExpressionNode newExpressionNode, DocumentServiceContext context, int cursorPosition) {
        Optional methodSymbol = context.currentSemanticModel().flatMap(semanticModel -> semanticModel.typeOf((Node)newExpressionNode)).flatMap(typeSymbol -> Optional.of(CommonUtil.getRawType(typeSymbol))).map(typeSymbol -> {
            Optional<TypeSymbol> classType;
            if (typeSymbol.typeKind() == TypeDescKind.UNION && (classType = ((UnionTypeSymbol)typeSymbol).memberTypeDescriptors().stream().map(CommonUtil::getRawType).filter(member -> member instanceof ClassSymbol).findFirst()).isPresent()) {
                return classType.get();
            }
            return typeSymbol;
        }).filter(typeSymbol -> typeSymbol instanceof ClassSymbol).flatMap(typeSymbol -> ((ClassSymbol)typeSymbol).initMethod());
        if (methodSymbol.isEmpty()) {
            return Optional.empty();
        }
        return TypeResolverUtil.resolveParameterTypeSymbol(((MethodSymbol)methodSymbol.get()).typeDescriptor(), argumentNodes, cursorPosition);
    }

    public static Optional<TypeSymbol> resolveParameterTypeSymbol(FunctionTypeSymbol functionTypeSymbol, NodeList<FunctionArgumentNode> arguments, int cursorPosition) {
        return TypeResolverUtil.resolveParameterTypeSymbol(functionTypeSymbol, arguments, false, cursorPosition);
    }

    public static Optional<TypeSymbol> resolveParameterTypeSymbol(FunctionTypeSymbol functionTypeSymbol, NodeList<FunctionArgumentNode> arguments, boolean isLangLibFunction, int cursorPosition) {
        Optional<ParameterSymbol> parameterSymbol = TypeResolverUtil.resolveParameterSymbol(functionTypeSymbol, arguments, isLangLibFunction, cursorPosition);
        if (parameterSymbol.isEmpty()) {
            return Optional.empty();
        }
        TypeSymbol typeSymbol = parameterSymbol.get().typeDescriptor();
        if (parameterSymbol.get().paramKind() == ParameterKind.REST && typeSymbol.typeKind() == TypeDescKind.ARRAY) {
            return Optional.of(((ArrayTypeSymbol)typeSymbol).memberTypeDescriptor());
        }
        return Optional.of(typeSymbol);
    }

    public static Optional<FunctionTypeSymbol> findMethodInLangLibFunctions(MethodCallExpressionNode methodCallExprNode, DocumentServiceContext context) {
        if (methodCallExprNode.methodName().kind() != SyntaxKind.SIMPLE_NAME_REFERENCE) {
            return Optional.empty();
        }
        SimpleNameReferenceNode typeRefNode = (SimpleNameReferenceNode)methodCallExprNode.methodName();
        Optional typeSymbol = context.currentSemanticModel().flatMap(semanticModel -> semanticModel.typeOf((Node)methodCallExprNode.expression()));
        return typeSymbol.flatMap(value -> value.langLibMethods().stream().filter(method -> method.getName().orElse("").equals(typeRefNode.name().text())).findFirst().map(FunctionSymbol::typeDescriptor));
    }

    public static Boolean isInFunctionCallParameterContext(FunctionCallExpressionNode node, int cursorPosition) {
        return TypeResolverUtil.isWithinParenthesis(node.openParenToken(), node.closeParenToken(), cursorPosition);
    }

    public static Boolean isInMethodCallParameterContext(MethodCallExpressionNode node, int cursorPosition) {
        return TypeResolverUtil.isWithinParenthesis(node.openParenToken(), node.closeParenToken(), cursorPosition);
    }

    public static Boolean isInMethodCallParameterContext(RemoteMethodCallActionNode node, int cursorPosition) {
        return TypeResolverUtil.isWithinParenthesis(node.openParenToken(), node.closeParenToken(), cursorPosition);
    }

    public static Boolean isInNewExpressionParameterContext(ImplicitNewExpressionNode node, int cursorPosition) {
        Optional argList = node.parenthesizedArgList();
        if (argList.isEmpty()) {
            return false;
        }
        return TypeResolverUtil.isWithinParenthesis(((ParenthesizedArgList)argList.get()).openParenToken(), ((ParenthesizedArgList)argList.get()).closeParenToken(), cursorPosition);
    }

    public static Boolean isInNewExpressionParameterContext(ExplicitNewExpressionNode node, int cursorPosition) {
        ParenthesizedArgList argList = node.parenthesizedArgList();
        return TypeResolverUtil.isWithinParenthesis(argList.openParenToken(), argList.closeParenToken(), cursorPosition);
    }

    private static Optional<ParameterSymbol> resolveParameterSymbol(FunctionTypeSymbol functionTypeSymbol, NodeList<FunctionArgumentNode> arguments, boolean isLangLibFunction, int cursorPosition) {
        int argIndex = 0;
        for (Node child : arguments) {
            if (child.textRange().endOffset() >= cursorPosition) continue;
            ++argIndex;
        }
        Optional parameterSymbols = functionTypeSymbol.params();
        Optional restParam = functionTypeSymbol.restParam();
        if (restParam.isEmpty() && (parameterSymbols.isEmpty() || ((List)parameterSymbols.get()).size() < argIndex + 1)) {
            return Optional.empty();
        }
        if (isLangLibFunction) {
            ++argIndex;
        }
        if (parameterSymbols.isPresent() && ((List)parameterSymbols.get()).size() > argIndex) {
            return Optional.of((ParameterSymbol)((List)parameterSymbols.get()).get(argIndex));
        }
        return restParam;
    }

    private static boolean isWithinParenthesis(Token openParen, Token closedParen, int cursorPosition) {
        return !openParen.isMissing() && openParen.textRange().endOffset() <= cursorPosition && !closedParen.isMissing() && cursorPosition <= closedParen.textRange().startOffset();
    }
}

