/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.builder;

import io.ballerina.compiler.api.symbols.ConstantSymbol;
import io.ballerina.compiler.api.symbols.Documentation;
import io.ballerina.compiler.api.symbols.SymbolKind;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.NameUtil;
import org.ballerinalang.langserver.commons.CompletionContext;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.MarkupContent;

public final class ConstantCompletionItemBuilder {
    private ConstantCompletionItemBuilder() {
    }

    public static CompletionItem build(ConstantSymbol constantSymbol, CompletionContext context) {
        String name = constantSymbol.getName().orElse("");
        CompletionItem completionItem = new CompletionItem();
        completionItem.setLabel(name);
        completionItem.setInsertText(name);
        completionItem.setDetail(NameUtil.getModifiedTypeName((DocumentServiceContext)context, constantSymbol.typeDescriptor()));
        completionItem.setDocumentation(ConstantCompletionItemBuilder.getDocumentation(constantSymbol));
        if (constantSymbol.kind() == SymbolKind.ENUM_MEMBER) {
            completionItem.setKind(CompletionItemKind.EnumMember);
        } else {
            completionItem.setKind(CompletionItemKind.Variable);
        }
        return completionItem;
    }

    private static MarkupContent getDocumentation(ConstantSymbol constantSymbol) {
        MarkupContent docMarkupContent = new MarkupContent();
        Optional docAttachment = constantSymbol.documentation();
        String description = docAttachment.isEmpty() || ((Documentation)docAttachment.get()).description().isEmpty() ? "" : (String)((Documentation)docAttachment.get()).description().get();
        docMarkupContent.setValue(description);
        docMarkupContent.setKind("markdown");
        return docMarkupContent;
    }
}

