/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.builder;

import io.ballerina.compiler.api.symbols.TypeSymbol;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.DefaultValueGenerationUtil;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;

public final class NamedArgCompletionItemBuilder {
    private NamedArgCompletionItemBuilder() {
    }

    public static CompletionItem build(String argName, TypeSymbol argSymbol) {
        String defaultValueToInsert = DefaultValueGenerationUtil.getDefaultPlaceholderForType(argSymbol).orElse("");
        String defaultValueToDetail = DefaultValueGenerationUtil.getDefaultValueForType(argSymbol).orElse("");
        String label = argName + " = ...";
        String insertText = CommonUtil.escapeSpecialCharsInInsertText(argName) + " = ${1:" + defaultValueToInsert + "}";
        String detail = argName + " = " + defaultValueToDetail;
        CompletionItem item = new CompletionItem();
        item.setLabel(label);
        item.setInsertText(insertText);
        item.setDetail(detail);
        item.setKind(CompletionItemKind.Snippet);
        item.setFilterText(argName);
        return item;
    }
}

