/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.builder;

import io.ballerina.compiler.api.symbols.Documentable;
import io.ballerina.compiler.api.symbols.Documentation;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.SymbolUtil;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;

public final class TypeCompletionItemBuilder {
    private TypeCompletionItemBuilder() {
    }

    public static CompletionItem build(Symbol bSymbol, String label) {
        CompletionItem item = new CompletionItem();
        item.setLabel(label);
        String insertText = CommonUtil.escapeSpecialCharsInInsertText(label);
        item.setInsertText(insertText);
        TypeCompletionItemBuilder.setMeta(item, bSymbol);
        return item;
    }

    private static void setMeta(CompletionItem item, Symbol bSymbol) {
        Documentable documentableSymbol;
        if (bSymbol == null) {
            item.setKind(CompletionItemKind.Unit);
            item.setDetail("type");
            return;
        }
        if (bSymbol.kind() == SymbolKind.MODULE) {
            item.setKind(CompletionItemKind.Module);
            return;
        }
        if (bSymbol.kind() == SymbolKind.ENUM) {
            item.setKind(CompletionItemKind.Enum);
            item.setDetail("enum");
            return;
        }
        Optional<TypeSymbol> typeDescriptor = SymbolUtil.getTypeDescriptor(bSymbol);
        Optional<TypeSymbol> optional = typeDescriptor = typeDescriptor.isPresent() && typeDescriptor.get().typeKind() == TypeDescKind.TYPE_REFERENCE ? Optional.of(((TypeReferenceTypeSymbol)typeDescriptor.get()).typeDescriptor()) : typeDescriptor;
        if (typeDescriptor.isEmpty() || typeDescriptor.get().typeKind() == null || typeDescriptor.get().typeKind() == TypeDescKind.COMPILATION_ERROR) {
            item.setKind(CompletionItemKind.Unit);
            item.setDetail("type");
            return;
        }
        block0 : switch (typeDescriptor.get().typeKind()) {
            case UNION: {
                ArrayList memberTypes = new ArrayList(((UnionTypeSymbol)typeDescriptor.get()).memberTypeDescriptors());
                if (memberTypes.isEmpty()) {
                    item.setKind(CompletionItemKind.Unit);
                    item.setDetail("type");
                    return;
                }
                boolean allMatch = memberTypes.stream().allMatch(typeDesc -> typeDesc.typeKind() == ((TypeSymbol)memberTypes.get(0)).typeKind());
                if (allMatch) {
                    switch (((TypeSymbol)memberTypes.get(0)).typeKind()) {
                        case ERROR: {
                            item.setKind(CompletionItemKind.Event);
                            break block0;
                        }
                        case RECORD: {
                            item.setKind(CompletionItemKind.Struct);
                            break block0;
                        }
                        case OBJECT: {
                            item.setKind(CompletionItemKind.Interface);
                            break block0;
                        }
                    }
                    item.setKind(CompletionItemKind.TypeParameter);
                    break;
                }
                item.setKind(CompletionItemKind.Enum);
                break;
            }
            case RECORD: {
                item.setKind(CompletionItemKind.Struct);
                break;
            }
            case OBJECT: {
                item.setKind(CompletionItemKind.Interface);
                break;
            }
            case ERROR: {
                item.setKind(CompletionItemKind.Event);
                break;
            }
            default: {
                item.setKind(CompletionItemKind.TypeParameter);
            }
        }
        Documentable documentable = documentableSymbol = bSymbol instanceof Documentable ? (Documentable)bSymbol : null;
        if (documentableSymbol != null && documentableSymbol.documentation().isPresent() && ((Documentation)documentableSymbol.documentation().get()).description().isPresent()) {
            item.setDocumentation((String)((Documentation)documentableSymbol.documentation().get()).description().get());
        }
        String name = typeDescriptor.get().kind() == SymbolKind.CLASS ? typeDescriptor.get().kind().name() : typeDescriptor.get().typeKind().getName();
        String detail = name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1).toLowerCase(Locale.ENGLISH);
        item.setDetail(detail);
    }
}

