/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.Types;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.ErrorConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.projects.Document;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.TextRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.SymbolUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.NamedArgCompletionItem;
import org.ballerinalang.langserver.completions.builder.NamedArgCompletionItemBuilder;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.SortingUtil;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.wso2.ballerinalang.compiler.util.Names;

public class ErrorConstructorExpressionNodeContext
extends AbstractCompletionProvider<ErrorConstructorExpressionNode> {
    public ErrorConstructorExpressionNodeContext() {
        super(ErrorConstructorExpressionNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, ErrorConstructorExpressionNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (this.withinArgs(context, node)) {
            completionItems.addAll(this.getCompletionWithinArgs(context, node));
        } else if (this.withinTypeRefContext(context, node)) {
            completionItems.addAll(this.getErrorTypeRefCompletions(context));
        }
        this.sort(context, node, (List<LSCompletionItem>)completionItems);
        return completionItems;
    }

    private boolean withinTypeRefContext(BallerinaCompletionContext context, ErrorConstructorExpressionNode node) {
        int cursor = context.getCursorPositionInTree();
        Token errorKeyword = node.errorKeyword();
        Optional typeDescNode = node.typeReference();
        return cursor >= errorKeyword.textRange().endOffset() + 1 && (typeDescNode.isEmpty() || cursor <= ((TypeDescriptorNode)typeDescNode.get()).textRange().endOffset());
    }

    private List<LSCompletionItem> getCompletionWithinArgs(BallerinaCompletionContext ctx, ErrorConstructorExpressionNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        NonTerminalNode nodeAtCursor = ctx.getNodeAtCursor();
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)ctx, (Node)nodeAtCursor)) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nodeAtCursor;
            return this.getCompletionItemList(QNameRefCompletionUtil.getExpressionContextEntries(ctx, qNameRef), ctx);
        }
        completionItems.addAll(this.expressionCompletions(ctx));
        completionItems.addAll(this.getNamedArgExpressionCompletionItems(ctx, node));
        completionItems.addAll(this.actionKWCompletions(ctx));
        return completionItems;
    }

    private List<LSCompletionItem> getErrorTypeRefCompletions(BallerinaCompletionContext ctx) {
        NonTerminalNode nodeAtCursor = ctx.getNodeAtCursor();
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)ctx, (Node)nodeAtCursor)) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nodeAtCursor;
            List<Symbol> moduleContent = QNameRefCompletionUtil.getModuleContent((PositionedOperationContext)ctx, qNameRef, SymbolUtil.isOfType(TypeDescKind.ERROR));
            return this.getCompletionItemList(moduleContent, ctx);
        }
        List<Symbol> errorTypes = ctx.visibleSymbols(ctx.getCursorPosition()).stream().filter(SymbolUtil.isOfType(TypeDescKind.ERROR).and(symbol -> !symbol.getName().orElse("").equals(Names.ERROR.getValue()))).toList();
        List<LSCompletionItem> completionItems = this.getCompletionItemList(errorTypes, ctx);
        completionItems.addAll(this.getModuleCompletionItems(ctx));
        return completionItems;
    }

    @Override
    public void sort(BallerinaCompletionContext context, ErrorConstructorExpressionNode node, List<LSCompletionItem> completionItems) {
        if (!this.withinArgs(context, node) || context.currentSemanticModel().isEmpty()) {
            super.sort(context, node, completionItems);
            return;
        }
        Types types = ((SemanticModel)context.currentSemanticModel().get()).types();
        if (this.isInErrorMessageArgContext(context, node)) {
            for (LSCompletionItem completionItem : completionItems) {
                completionItem.getCompletionItem().setSortText(SortingUtil.genSortTextByAssignability(context, completionItem, types.STRING));
            }
            return;
        }
        if (this.isInErrorCauseArgContext(context, node) || node.typeReference().isPresent()) {
            UnionTypeSymbol optionalErrorTypeSymbol = types.builder().UNION_TYPE.withMemberTypes(new TypeSymbol[]{types.ERROR, types.NIL}).build();
            for (LSCompletionItem completionItem : completionItems) {
                Object sortText = completionItem.getType() == LSCompletionItem.CompletionItemType.NAMED_ARG ? (this.isInErrorCauseArgContext(context, node) ? SortingUtil.genSortText(1) + SortingUtil.genSortText(SortingUtil.toRank(context, completionItem)) : SortingUtil.genSortText(1)) : SortingUtil.genSortTextByAssignability(context, completionItem, (TypeSymbol)optionalErrorTypeSymbol);
                completionItem.getCompletionItem().setSortText((String)sortText);
            }
            return;
        }
        super.sort(context, node, completionItems);
    }

    private boolean withinArgs(BallerinaCompletionContext context, ErrorConstructorExpressionNode node) {
        int cursor = context.getCursorPositionInTree();
        Token openParenToken = node.openParenToken();
        Token closeParenToken = node.closeParenToken();
        return !openParenToken.isMissing() && !closeParenToken.isMissing() && cursor >= openParenToken.textRange().endOffset() && cursor <= closeParenToken.textRange().startOffset();
    }

    private boolean isInErrorMessageArgContext(BallerinaCompletionContext context, ErrorConstructorExpressionNode node) {
        if (!this.withinArgs(context, node)) {
            return false;
        }
        if (node.arguments().isEmpty()) {
            return true;
        }
        FunctionArgumentNode firstNode = (FunctionArgumentNode)node.arguments().get(0);
        TextRange textRange = firstNode.textRange();
        int cursor = context.getCursorPositionInTree();
        return cursor < textRange.startOffset() || firstNode.kind() == SyntaxKind.POSITIONAL_ARG && textRange.startOffset() <= cursor && cursor <= textRange.endOffset();
    }

    private boolean isInErrorCauseArgContext(BallerinaCompletionContext context, ErrorConstructorExpressionNode node) {
        if (!this.withinArgs(context, node) || node.arguments().isEmpty() || node.arguments().size() == 1) {
            return false;
        }
        FunctionArgumentNode secondArgNode = (FunctionArgumentNode)node.arguments().get(1);
        TextRange textRange = secondArgNode.textRange();
        int cursor = context.getCursorPositionInTree();
        return cursor < textRange.startOffset() || secondArgNode.kind() == SyntaxKind.POSITIONAL_ARG && textRange.startOffset() <= cursor && cursor <= textRange.endOffset();
    }

    private List<LSCompletionItem> getNamedArgExpressionCompletionItems(BallerinaCompletionContext context, ErrorConstructorExpressionNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        Optional semanticModel = context.currentSemanticModel();
        if (semanticModel.isEmpty()) {
            return completionItems;
        }
        Optional detailTypeDesc = Optional.empty();
        if (context.currentSemanticModel().isPresent() && context.currentDocument().isPresent()) {
            LinePosition linePosition = node.location().lineRange().endLine();
            detailTypeDesc = ((SemanticModel)context.currentSemanticModel().get()).expectedType((Document)context.currentDocument().get(), linePosition);
        }
        if (detailTypeDesc.isEmpty()) {
            return completionItems;
        }
        TypeSymbol rawType = CommonUtil.getRawType((TypeSymbol)detailTypeDesc.get());
        if (rawType.typeKind() != TypeDescKind.RECORD) {
            return completionItems;
        }
        Map fields = ((RecordTypeSymbol)rawType).fieldDescriptors();
        if (fields.isEmpty()) {
            return completionItems;
        }
        List<String> existingNamedArgs = node.arguments().stream().filter(arg -> arg.kind() == SyntaxKind.NAMED_ARG).map(arg -> ((NamedArgumentNode)arg).argumentName().name().text()).toList();
        fields.entrySet().forEach(field -> {
            Optional fieldName = ((RecordFieldSymbol)field.getValue()).getName();
            if (fieldName.isEmpty() || ((String)fieldName.get()).isEmpty() || existingNamedArgs.contains(fieldName.get())) {
                return;
            }
            TypeSymbol fieldType = ((RecordFieldSymbol)field.getValue()).typeDescriptor();
            CompletionItem completionItem = NamedArgCompletionItemBuilder.build((String)fieldName.get(), fieldType);
            completionItems.add((LSCompletionItem)new NamedArgCompletionItem(context, completionItem, (Either<ParameterSymbol, RecordFieldSymbol>)Either.forRight((Object)((RecordFieldSymbol)field.getValue()))));
        });
        return completionItems;
    }
}

