/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.TextRange;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionException;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.CompletionUtil;
import org.ballerinalang.langserver.completions.util.Snippet;
import org.eclipse.lsp4j.Position;

public class FunctionDefinitionNodeContext
extends AbstractCompletionProvider<FunctionDefinitionNode> {
    public FunctionDefinitionNodeContext() {
        super(FunctionDefinitionNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, FunctionDefinitionNode node) throws LSCompletionException {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (this.canCheckWithinFunctionSignature(context, node)) {
            return CompletionUtil.route(context, (Node)node.functionSignature());
        }
        if (node.functionKeyword().isMissing()) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_FUNCTION.get()));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_FUNCTION.get()));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_EXPRESSION_BODIED_FUNCTION.get()));
        }
        this.sort(context, node, completionItems);
        return completionItems;
    }

    private boolean canCheckWithinFunctionSignature(BallerinaCompletionContext context, FunctionDefinitionNode node) {
        FunctionSignatureNode functionSignatureNode = node.functionSignature();
        if (functionSignatureNode.isMissing()) {
            return false;
        }
        LinePosition signatureEndLine = functionSignatureNode.lineRange().endLine();
        Position cursor = context.getCursorPosition();
        return signatureEndLine.line() == cursor.getLine() && signatureEndLine.offset() < cursor.getCharacter() || signatureEndLine.line() < cursor.getLine();
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, FunctionDefinitionNode node) {
        int textPosition = context.getCursorPositionInTree();
        Token functionKeyword = node.functionKeyword();
        if (functionKeyword.isMissing()) {
            return true;
        }
        TextRange textRange = functionKeyword.textRange();
        return textRange.endOffset() <= textPosition && textPosition < node.textRange().endOffset();
    }
}

