/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.FunctionTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.Minutiae;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.projects.Document;
import io.ballerina.tools.text.TextRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.Snippet;
import org.ballerinalang.langserver.completions.util.SortingUtil;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class FunctionTypeDescriptorNodeContext
extends AbstractCompletionProvider<FunctionTypeDescriptorNode> {
    public FunctionTypeDescriptorNodeContext() {
        super(FunctionTypeDescriptorNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, FunctionTypeDescriptorNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        RuleContext ruleContext = RuleContext.OTHER;
        if (this.onSuggestionsAfterQualifiers(context, (Node)node)) {
            completionItems.addAll(this.getCompletionItemsOnQualifiers((Node)node, context));
        } else if (this.withinParameterContext(context, node)) {
            if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)nodeAtCursor)) {
                List<Symbol> typesInModule = QNameRefCompletionUtil.getTypesInModule(context, (QualifiedNameReferenceNode)nodeAtCursor);
                completionItems.addAll(this.getCompletionItemList(typesInModule, context));
            } else {
                completionItems.addAll(this.getTypeDescContextItems(context));
            }
            ruleContext = RuleContext.PARAMETER_CTX;
        } else if (this.withinReturnKWContext(context, node)) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_RETURNS.get()));
        } else if (node.parent().kind() == SyntaxKind.OBJECT_FIELD) {
            SnippetCompletionItem initFuncCompletionItem = new SnippetCompletionItem(context, Snippet.DEF_INIT_FUNCTION.get());
            Token funcKW = node.functionKeyword();
            int endOffset = this.getEndPosWithoutNewLine(funcKW);
            Range range = PositionUtil.toRange(funcKW.textRange().startOffset(), endOffset, ((Document)context.currentDocument().get()).textDocument());
            TextEdit textEdit = new TextEdit(range, "");
            initFuncCompletionItem.getCompletionItem().setAdditionalTextEdits(List.of(textEdit));
            completionItems.add((LSCompletionItem)initFuncCompletionItem);
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_FUNCTION.get()));
        }
        this.sort(context, node, (List<LSCompletionItem>)completionItems, new Object[]{ruleContext});
        return completionItems;
    }

    private int getEndPosWithoutNewLine(Token token) {
        int end = token.textRangeWithMinutiae().endOffset();
        MinutiaeList minutiaeList = token.trailingMinutiae();
        int size = minutiaeList.size();
        if (size == 0) {
            return end;
        }
        Minutiae lastMinutiae = minutiaeList.get(size - 1);
        if (lastMinutiae.kind() == SyntaxKind.END_OF_LINE_MINUTIAE) {
            return size == 1 ? token.textRange().startOffset() : end - 1;
        }
        return end;
    }

    @Override
    protected List<LSCompletionItem> getCompletionItemsOnQualifiers(Node node, BallerinaCompletionContext context) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>(super.getCompletionItemsOnQualifiers(node, context));
        List<Token> qualifiers = CommonUtil.getQualifiersOfNode(context, node);
        if (qualifiers.isEmpty()) {
            return completionItems;
        }
        Token lastQualifier = qualifiers.get(qualifiers.size() - 1);
        if (lastQualifier.kind() == SyntaxKind.ISOLATED_KEYWORD) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_FUNCTION.get()));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_OBJECT_TYPE_DESC_SNIPPET.get()));
        }
        return completionItems;
    }

    private boolean withinParameterContext(BallerinaCompletionContext context, FunctionTypeDescriptorNode node) {
        if (node.functionSignature().isEmpty()) {
            return false;
        }
        FunctionSignatureNode functionSignatureNode = (FunctionSignatureNode)node.functionSignature().get();
        int txtPosInTree = context.getCursorPositionInTree();
        TextRange openParanRange = functionSignatureNode.openParenToken().textRange();
        TextRange closeParanRange = functionSignatureNode.closeParenToken().textRange();
        return openParanRange.endOffset() <= txtPosInTree && txtPosInTree <= closeParanRange.startOffset();
    }

    private boolean withinReturnKWContext(BallerinaCompletionContext context, FunctionTypeDescriptorNode node) {
        if (node.functionSignature().isEmpty()) {
            return false;
        }
        FunctionSignatureNode functionSignatureNode = (FunctionSignatureNode)node.functionSignature().get();
        int txtPosInTree = context.getCursorPositionInTree();
        TextRange closeParanRange = functionSignatureNode.closeParenToken().textRange();
        Optional returnTypeDescNode = functionSignatureNode.returnTypeDesc();
        return closeParanRange.startOffset() <= txtPosInTree && (!returnTypeDescNode.isPresent() || ((ReturnTypeDescriptorNode)returnTypeDescNode.get()).returnsKeyword().isMissing());
    }

    @Override
    protected boolean onSuggestionsAfterQualifiers(BallerinaCompletionContext context, Node node) {
        int cursor = context.getCursorPositionInTree();
        Token functionKeyword = ((FunctionTypeDescriptorNode)node).functionKeyword();
        return super.onSuggestionsAfterQualifiers(context, node) && cursor < functionKeyword.textRange().startOffset();
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, FunctionTypeDescriptorNode node) {
        return !node.functionKeyword().isMissing() && context.getCursorPositionInTree() > node.functionKeyword().textRange().startOffset();
    }

    @Override
    public void sort(BallerinaCompletionContext context, FunctionTypeDescriptorNode node, List<LSCompletionItem> completionItems, Object ... metaData) {
        if (metaData.length == 1 && metaData[0] instanceof RuleContext && metaData[0] == RuleContext.PARAMETER_CTX) {
            for (LSCompletionItem lsCItem : completionItems) {
                String sortText = SortingUtil.genSortTextForTypeDescContext(context, lsCItem);
                lsCItem.getCompletionItem().setSortText(sortText);
            }
            return;
        }
        super.sort(context, node, completionItems);
    }

    private static enum RuleContext {
        PARAMETER_CTX,
        OTHER;

    }
}

