/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.MapTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.ComputedNameFieldNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.SymbolUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SpreadCompletionItem;
import org.ballerinalang.langserver.completions.providers.context.MappingContextProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.SortingUtil;

public class MappingConstructorExpressionNodeContext
extends MappingContextProvider<MappingConstructorExpressionNode> {
    public MappingConstructorExpressionNodeContext() {
        super(MappingConstructorExpressionNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, MappingConstructorExpressionNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        Optional<Node> evalNode = CommonUtil.getMappingContextEvalNode((Node)nodeAtCursor);
        if (evalNode.isEmpty()) {
            return completionItems;
        }
        Scope scope = Scope.OTHER;
        if (this.withinValueExpression(context, evalNode.get())) {
            scope = Scope.VALUE_EXPR;
            completionItems.addAll(this.getCompletionsInValueExpressionContext(context));
        } else if (this.withinComputedNameContext(context, evalNode.get())) {
            scope = Scope.COMPUTED_FIELD_NAME;
            if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)nodeAtCursor)) {
                QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nodeAtCursor;
                completionItems.addAll(this.getExpressionsCompletionsForQNameRef(context, qNameRef));
            } else {
                completionItems.addAll(this.getComputedNameCompletions(context));
            }
        } else {
            scope = Scope.FIELD_NAME;
            completionItems.addAll(this.getFieldCompletionItems(context, node, evalNode.get()));
        }
        this.sort(context, node, (List<LSCompletionItem>)completionItems, new Object[]{scope});
        return completionItems;
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, MappingConstructorExpressionNode node) {
        int cursor = context.getCursorPositionInTree();
        return !node.openBrace().isMissing() && !node.closeBrace().isMissing() && cursor > node.openBrace().textRange().startOffset() && cursor < node.closeBrace().textRange().endOffset();
    }

    @Override
    public void sort(BallerinaCompletionContext context, MappingConstructorExpressionNode node, List<LSCompletionItem> completionItems, Object ... metaData) {
        Scope scope = metaData.length > 0 && metaData[0] instanceof Scope ? (Scope)((Object)metaData[0]) : Scope.OTHER;
        Optional contextType = context.getContextType();
        if (contextType.isEmpty()) {
            super.sort(context, node, completionItems);
            return;
        }
        completionItems.forEach(lsCItem -> {
            Optional<Symbol> expression;
            Optional<TypeSymbol> mapTypeParam;
            if (scope == Scope.FIELD_NAME && lsCItem.getType() == LSCompletionItem.CompletionItemType.SPREAD && ((mapTypeParam = (expression = ((SpreadCompletionItem)((Object)lsCItem)).getExpression()).flatMap(SymbolUtil::getTypeDescriptor).filter(typeDesc -> typeDesc.typeKind() == TypeDescKind.MAP).map(typeDesc -> (MapTypeSymbol)typeDesc).map(MapTypeSymbol::typeParam)).isPresent() && mapTypeParam.get().subtypeOf((TypeSymbol)contextType.get()) || expression.isPresent())) {
                int lastRank = expression.map(expr -> expr.kind() == SymbolKind.FUNCTION ? 4 : 3).orElse(3);
                String sortText = SortingUtil.genSortText(1) + SortingUtil.genSortText(lastRank);
                lsCItem.getCompletionItem().setSortText(sortText);
                return;
            }
            String sortText = SortingUtil.genSortTextByAssignability(context, lsCItem, (TypeSymbol)contextType.get());
            lsCItem.getCompletionItem().setSortText(sortText);
        });
    }

    private boolean withinComputedNameContext(BallerinaCompletionContext context, Node evalNodeAtCursor) {
        if (evalNodeAtCursor.kind() != SyntaxKind.COMPUTED_NAME_FIELD) {
            return false;
        }
        int openBracketEnd = ((ComputedNameFieldNode)evalNodeAtCursor).openBracket().textRange().endOffset();
        int closeBracketStart = ((ComputedNameFieldNode)evalNodeAtCursor).closeBracket().textRange().startOffset();
        int cursorPosInTree = context.getCursorPositionInTree();
        return cursorPosInTree >= openBracketEnd && cursorPosInTree <= closeBracketStart;
    }

    private List<LSCompletionItem> getComputedNameCompletions(BallerinaCompletionContext context) {
        List visibleSymbols = context.visibleSymbols(context.getCursorPosition());
        List<Symbol> filteredList = visibleSymbols.stream().filter(symbol -> symbol instanceof VariableSymbol || symbol.kind() == SymbolKind.FUNCTION).toList();
        List<LSCompletionItem> completionItems = this.getCompletionItemList(filteredList, context);
        completionItems.addAll(this.getModuleCompletionItems(context));
        return completionItems;
    }

    @Override
    protected List<String> getFields(MappingConstructorExpressionNode node) {
        return node.fields().stream().filter(field -> !field.isMissing() && field.kind() == SyntaxKind.SPECIFIC_FIELD && ((SpecificFieldNode)field).fieldName().kind() == SyntaxKind.IDENTIFIER_TOKEN).map(field -> ((IdentifierToken)((SpecificFieldNode)field).fieldName()).text()).toList();
    }

    private static enum Scope {
        VALUE_EXPR,
        FIELD_NAME,
        COMPUTED_FIELD_NAME,
        OTHER;

    }
}

