/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ObjectTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.Snippet;

public class ObjectTypeDescriptorNodeContext
extends AbstractCompletionProvider<ObjectTypeDescriptorNode> {
    public ObjectTypeDescriptorNodeContext() {
        super(ObjectTypeDescriptorNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, ObjectTypeDescriptorNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (this.onSuggestionsAfterQualifiers(context, (Node)node)) {
            completionItems.addAll(this.getCompletionItemsOnQualifiers((Node)node, context));
        } else if (this.onSuggestionsWithinObjectBody(context, node)) {
            completionItems.addAll(this.getObjectBodyCompletions(context));
        }
        this.sort(context, node, completionItems);
        return completionItems;
    }

    @Override
    protected boolean onSuggestionsAfterQualifiers(BallerinaCompletionContext context, Node node) {
        if (node.kind() != SyntaxKind.OBJECT_TYPE_DESC) {
            return false;
        }
        boolean isAfterQualifier = super.onSuggestionsAfterQualifiers(context, node);
        int cursor = context.getCursorPositionInTree();
        Token objectKeyword = ((ObjectTypeDescriptorNode)node).objectKeyword();
        return isAfterQualifier && (objectKeyword.isMissing() || cursor < objectKeyword.textRange().startOffset());
    }

    @Override
    protected List<LSCompletionItem> getCompletionItemsOnQualifiers(Node node, BallerinaCompletionContext context) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>(super.getCompletionItemsOnQualifiers(node, context));
        List<Token> qualifiers = CommonUtil.getQualifiersOfNode(context, node);
        if (qualifiers.isEmpty()) {
            return completionItems;
        }
        Token lastQualifier = qualifiers.get(qualifiers.size() - 1);
        if (lastQualifier.kind() == SyntaxKind.ISOLATED_KEYWORD) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_FUNCTION.get()));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_OBJECT_TYPE_DESC_SNIPPET.get()));
        }
        return completionItems;
    }

    private boolean onSuggestionsWithinObjectBody(BallerinaCompletionContext context, ObjectTypeDescriptorNode node) {
        int cursor = context.getCursorPositionInTree();
        Token openBrace = node.openBrace();
        Token closeBrace = node.closeBrace();
        if (openBrace.isMissing() || closeBrace.isMissing()) {
            return false;
        }
        return cursor > openBrace.textRange().startOffset() && cursor < closeBrace.textRange().endOffset();
    }

    private List<LSCompletionItem> getObjectBodyCompletions(BallerinaCompletionContext context) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_PUBLIC.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_REMOTE.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_REMOTE_METHOD_DECL.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_FUNCTION_SIGNATURE.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_ISOLATED.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_TRANSACTIONAL.get()));
        completionItems.addAll(this.getTypeDescContextItems(context));
        return completionItems;
    }
}

