/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.SortingUtil;

public class ReturnTypeDescriptorNodeContext
extends AbstractCompletionProvider<ReturnTypeDescriptorNode> {
    public ReturnTypeDescriptorNodeContext() {
        super(ReturnTypeDescriptorNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, ReturnTypeDescriptorNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)context.getNodeAtCursor())) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)context.getNodeAtCursor();
            List<Symbol> typesInModule = QNameRefCompletionUtil.getTypesInModule(context, qNameRef);
            completionItems.addAll(this.getCompletionItemList(typesInModule, context));
        } else {
            completionItems.addAll(this.getTypeDescContextItems(context));
            completionItems.addAll(this.getTypeQualifierItems(context));
        }
        this.sort(context, node, (List<LSCompletionItem>)completionItems);
        return completionItems;
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, ReturnTypeDescriptorNode node) {
        return !node.returnsKeyword().isMissing();
    }

    @Override
    public void sort(BallerinaCompletionContext context, ReturnTypeDescriptorNode node, List<LSCompletionItem> completionItems) {
        completionItems.forEach(completionItem -> {
            String sortText = SortingUtil.genSortTextForTypeDescContext(context, completionItem);
            completionItem.getCompletionItem().setSortText(sortText);
        });
    }
}

