/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.syntax.tree.KeySpecifierNode;
import io.ballerina.compiler.syntax.tree.TableConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.Snippet;

public class TableConstructorExpressionNodeContext
extends AbstractCompletionProvider<TableConstructorExpressionNode> {
    public TableConstructorExpressionNodeContext() {
        super(TableConstructorExpressionNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext ctx, TableConstructorExpressionNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        int cursor = ctx.getCursorPositionInTree();
        if (this.withinBrackets(ctx, node)) {
            return Collections.emptyList();
        }
        if (this.onKeySpecifier(ctx, node)) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, Snippet.KW_KEY.get()));
        } else if (node.keySpecifier().isPresent() && ((KeySpecifierNode)node.keySpecifier().get()).textRange().endOffset() < cursor) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, Snippet.KW_FROM.get()));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, Snippet.CLAUSE_FROM.get()));
        }
        this.sort(ctx, node, completionItems);
        return completionItems;
    }

    private boolean withinBrackets(BallerinaCompletionContext context, TableConstructorExpressionNode node) {
        int cursor = context.getCursorPositionInTree();
        Token openBracketToken = node.openBracket();
        Token closeBracketToken = node.closeBracket();
        boolean isBracketMissing = openBracketToken.isMissing() || closeBracketToken.isMissing();
        return !isBracketMissing && cursor >= openBracketToken.textRange().endOffset() && cursor <= closeBracketToken.textRange().startOffset();
    }

    private boolean onKeySpecifier(BallerinaCompletionContext context, TableConstructorExpressionNode node) {
        int cursor = context.getCursorPositionInTree();
        Optional keySpecifier = node.keySpecifier();
        Token tableKeyword = node.tableKeyword();
        return cursor > tableKeyword.textRange().endOffset() && (keySpecifier.isEmpty() || cursor < ((KeySpecifierNode)keySpecifier.get()).keyKeyword().textRange().startOffset());
    }
}

