/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.WaitFieldsListNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.SortingUtil;

public class WaitFieldsListNodeContext
extends AbstractCompletionProvider<WaitFieldsListNode> {
    public WaitFieldsListNodeContext() {
        super(WaitFieldsListNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, WaitFieldsListNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)nodeAtCursor)) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nodeAtCursor;
            Predicate<Symbol> predicate = symbol -> symbol.kind() == SymbolKind.VARIABLE && ((VariableSymbol)symbol).typeDescriptor().typeKind() == TypeDescKind.FUTURE;
            List<Symbol> moduleContent = QNameRefCompletionUtil.getModuleContent((PositionedOperationContext)context, qNameRef, predicate);
            completionItems.addAll(this.getCompletionItemList(moduleContent, context));
        } else {
            completionItems.addAll(this.expressionCompletions(context));
            completionItems.addAll(this.getModuleCompletionItems(context));
        }
        this.sort(context, node, (List<LSCompletionItem>)completionItems);
        return completionItems;
    }

    @Override
    protected List<LSCompletionItem> expressionCompletions(BallerinaCompletionContext context) {
        List visibleSymbols = context.visibleSymbols(context.getCursorPosition());
        List<Symbol> filteredList = visibleSymbols.stream().filter(CommonUtil.getVariableFilterPredicate().or(symbol -> symbol.kind() == SymbolKind.WORKER)).toList();
        return this.getCompletionItemList(filteredList, context);
    }

    @Override
    public void sort(BallerinaCompletionContext context, WaitFieldsListNode node, List<LSCompletionItem> completionItems) {
        Optional contextType = context.getContextType();
        if (contextType.isPresent()) {
            completionItems.forEach(lsCItem -> {
                String sortText = SortingUtil.genSortTextByAssignability(context, lsCItem, (TypeSymbol)contextType.get());
                lsCItem.getCompletionItem().setSortText(sortText);
            });
            return;
        }
        super.sort(context, node, completionItems);
    }
}

