/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.contexts;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.projects.Document;
import io.ballerina.tools.text.LinePosition;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.CompletionContext;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.contexts.BallerinaContextUtils;
import org.ballerinalang.langserver.contexts.CompletionContextImpl;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class BallerinaCompletionContextImpl
extends CompletionContextImpl
implements BallerinaCompletionContext {
    private final List<Node> resolverChain = new ArrayList<Node>();
    private Token tokenAtCursor;
    private NonTerminalNode nodeAtCursor;
    private boolean isContextTypeCaptured = false;
    private Optional<TypeSymbol> contextType = Optional.empty();
    private boolean isCapturedEnclosingNode = false;
    private ModuleMemberDeclarationNode enclosingNode = null;
    private final CompletionParams completionParams;
    private final Position cursorPosition;
    private final Optional<Document> document;
    private final Optional<SemanticModel> semanticModel;

    public BallerinaCompletionContextImpl(CompletionContext context, LanguageServerContext serverContext, CompletionParams completionParams) {
        super(context.operation(), context.fileUri(), context.workspace(), context.getCapabilities(), context.getCursorPosition(), serverContext);
        this.completionParams = completionParams;
        this.semanticModel = context.currentSemanticModel();
        this.document = context.currentDocument();
        this.cursorPosition = context.getCursorPosition();
    }

    public BallerinaCompletionContextImpl(CompletionContext context, LanguageServerContext serverContext, CompletionParams completionParams, CancelChecker cancelChecker) {
        super(context.operation(), context.fileUri(), context.workspace(), context.getCapabilities(), context.getCursorPosition(), serverContext, cancelChecker);
        this.completionParams = completionParams;
        this.semanticModel = context.currentSemanticModel();
        this.document = context.currentDocument();
        this.cursorPosition = context.getCursorPosition();
    }

    public void setTokenAtCursor(Token token) {
        if (this.tokenAtCursor != null) {
            throw new RuntimeException("Setting the token more than once is not allowed");
        }
        this.tokenAtCursor = token;
    }

    public Token getTokenAtCursor() {
        return this.tokenAtCursor;
    }

    public void setNodeAtCursor(NonTerminalNode node) {
        if (this.nodeAtCursor != null) {
            throw new RuntimeException("Setting the node more than once is not allowed");
        }
        this.nodeAtCursor = node;
    }

    public NonTerminalNode getNodeAtCursor() {
        return this.nodeAtCursor;
    }

    public void addResolver(Node node) {
        this.resolverChain.add(node);
    }

    public List<Node> getResolverChain() {
        return this.resolverChain;
    }

    public Optional<TypeSymbol> getContextType() {
        if (!this.isContextTypeCaptured && this.semanticModel.isPresent() && this.document.isPresent()) {
            this.isContextTypeCaptured = true;
            this.contextType = this.semanticModel.get().expectedType(this.document.get(), LinePosition.from((int)this.cursorPosition.getLine(), (int)this.cursorPosition.getCharacter()));
        }
        return this.contextType;
    }

    public CompletionParams getCompletionParams() {
        return this.completionParams;
    }

    public Optional<ModuleMemberDeclarationNode> enclosedModuleMember() {
        if (!this.isCapturedEnclosingNode) {
            this.isCapturedEnclosingNode = true;
            Optional<SyntaxTree> syntaxTree = this.currentSyntaxTree();
            if (syntaxTree.isEmpty()) {
                throw new RuntimeException("Cannot find a valid syntax tree");
            }
            this.enclosingNode = BallerinaContextUtils.getEnclosingModuleMember(syntaxTree.get(), this.getCursorPositionInTree()).orElse(null);
        }
        return Optional.ofNullable(this.enclosingNode);
    }
}

