/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.diagnostic;

import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectKind;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.text.LineRange;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.ballerinalang.langserver.LSContextOperation;
import org.ballerinalang.langserver.command.CommandUtil;
import org.ballerinalang.langserver.common.utils.PathUtil;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.WorkspaceServiceContext;
import org.ballerinalang.langserver.commons.client.ExtendedLanguageClient;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.ballerinalang.langserver.workspace.BallerinaWorkspaceManager;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.services.LanguageClient;

public class DiagnosticsHelper {
    private final List<org.eclipse.lsp4j.Diagnostic> emptyDiagnosticList = new ArrayList<org.eclipse.lsp4j.Diagnostic>(0);
    private static final LanguageServerContext.Key<DiagnosticsHelper> DIAGNOSTICS_HELPER_KEY = new LanguageServerContext.Key();
    private static final long DIAGNOSTIC_DELAY = 1L;
    private final Map<Path, Map<String, List<org.eclipse.lsp4j.Diagnostic>>> lastDiagnosticMap;
    private CompletableFuture<Boolean> latestScheduled = null;
    private final Deque<String> cyclicDependencyErrors;

    public static DiagnosticsHelper getInstance(LanguageServerContext serverContext) {
        DiagnosticsHelper diagnosticsHelper = (DiagnosticsHelper)serverContext.get(DIAGNOSTICS_HELPER_KEY);
        if (diagnosticsHelper == null) {
            diagnosticsHelper = new DiagnosticsHelper(serverContext);
        }
        return diagnosticsHelper;
    }

    private DiagnosticsHelper(LanguageServerContext serverContext) {
        serverContext.put(DIAGNOSTICS_HELPER_KEY, (Object)this);
        this.lastDiagnosticMap = new HashMap<Path, Map<String, List<org.eclipse.lsp4j.Diagnostic>>>();
        this.cyclicDependencyErrors = new ConcurrentLinkedDeque<String>();
    }

    public synchronized void schedulePublishDiagnostics(ExtendedLanguageClient client, DocumentServiceContext context) {
        WorkspaceManager workspaceManager = context.workspace();
        Path projectRoot = workspaceManager.projectRoot(context.filePath());
        this.compileAndSendDiagnostics(workspaceManager, projectRoot, client);
    }

    public synchronized void schedulePublishDiagnostics(ExtendedLanguageClient client, WorkspaceServiceContext context, Path projectRoot) {
        WorkspaceManager workspaceManager = context.workspace();
        this.compileAndSendDiagnostics(workspaceManager, projectRoot, client);
    }

    public synchronized void compileAndSendDiagnostics(ExtendedLanguageClient client, DocumentServiceContext context) {
        Optional project = context.workspace().project(context.filePath());
        if (project.isEmpty()) {
            return;
        }
        Map<String, List<org.eclipse.lsp4j.Diagnostic>> latestDiagnostics = this.getLatestDiagnostics(context);
        this.sendDiagnostics(client, latestDiagnostics, ((Project)project.get()).sourceRoot());
    }

    private synchronized void compileAndSendDiagnostics(ExtendedLanguageClient client, Path projectRoot, PackageCompilation compilation, WorkspaceManager workspaceManager) {
        Map<String, List<org.eclipse.lsp4j.Diagnostic>> diagnosticMap = this.toDiagnosticsMap(compilation.diagnosticResult().diagnostics(false), projectRoot, workspaceManager);
        this.sendDiagnostics(client, diagnosticMap, projectRoot);
    }

    private synchronized void sendDiagnostics(ExtendedLanguageClient client, Map<String, List<org.eclipse.lsp4j.Diagnostic>> diagnosticMap, Path projectRoot) {
        if (client == null) {
            return;
        }
        Map lastProjectDiagnostics = this.lastDiagnosticMap.getOrDefault(projectRoot, new HashMap());
        lastProjectDiagnostics.forEach((key, value) -> {
            if (!diagnosticMap.containsKey(key)) {
                client.publishDiagnostics(new PublishDiagnosticsParams(key, this.emptyDiagnosticList));
            }
        });
        diagnosticMap.forEach((key, value) -> client.publishDiagnostics(new PublishDiagnosticsParams(key, value)));
        while (!this.cyclicDependencyErrors.isEmpty()) {
            CommandUtil.notifyClient((LanguageClient)client, MessageType.Error, this.cyclicDependencyErrors.pop());
        }
        this.lastDiagnosticMap.put(projectRoot, diagnosticMap);
    }

    public Map<String, List<org.eclipse.lsp4j.Diagnostic>> getLatestDiagnostics(DocumentServiceContext context) {
        BallerinaWorkspaceManager workspace = (BallerinaWorkspaceManager)context.workspace();
        HashMap<String, List<org.eclipse.lsp4j.Diagnostic>> diagnosticMap = new HashMap<String, List<org.eclipse.lsp4j.Diagnostic>>();
        Optional<Project> project = workspace.project(context.filePath());
        if (project.isEmpty()) {
            return diagnosticMap;
        }
        Path projectRoot = workspace.projectRoot(context.filePath());
        Path originalPath = project.get().kind() == ProjectKind.SINGLE_FILE_PROJECT ? projectRoot.getParent() : projectRoot;
        Optional<PackageCompilation> compilationResult = workspace.waitAndGetPackageCompilation(context.filePath(), context.operation() == LSContextOperation.TXT_DID_CHANGE);
        compilationResult.ifPresent(compilation -> diagnosticMap.putAll(this.toDiagnosticsMap(compilation.diagnosticResult().diagnostics(false), originalPath, workspace)));
        return diagnosticMap;
    }

    private Map<String, List<org.eclipse.lsp4j.Diagnostic>> toDiagnosticsMap(Collection<Diagnostic> diags, Path projectRoot, WorkspaceManager workspaceManager) {
        HashMap<String, List<org.eclipse.lsp4j.Diagnostic>> diagnosticsMap = new HashMap<String, List<org.eclipse.lsp4j.Diagnostic>>();
        for (Diagnostic diag : diags) {
            if (diag.diagnosticInfo().code().equals(DiagnosticErrorCode.CYCLIC_MODULE_IMPORTS_DETECTED.diagnosticId())) {
                this.cyclicDependencyErrors.push(diag.message());
            }
            LineRange lineRange = diag.location().lineRange();
            org.eclipse.lsp4j.Diagnostic diagnostic = DiagnosticsHelper.getLSDiagnosticsFromCompilationDiagnostics(lineRange, diag);
            Path resolvedPath = projectRoot.toFile().isDirectory() ? projectRoot.resolve(lineRange.fileName()) : projectRoot;
            String resolvedUri = resolvedPath.toUri().toString();
            String fileURI = PathUtil.getModifiedUri(workspaceManager, resolvedUri);
            List clientDiagnostics = diagnosticsMap.computeIfAbsent(fileURI, s -> new ArrayList());
            clientDiagnostics.add(diagnostic);
        }
        return diagnosticsMap;
    }

    private synchronized void compileAndSendDiagnostics(WorkspaceManager workspaceManager, Path projectRoot, ExtendedLanguageClient client) {
        if (this.latestScheduled != null && !this.latestScheduled.isDone()) {
            this.latestScheduled.completeExceptionally(new Throwable("Cancelled diagnostic publisher"));
        }
        Executor delayedExecutor = CompletableFuture.delayedExecutor(1L, TimeUnit.SECONDS);
        CompletableFuture<Boolean> scheduledFuture = CompletableFuture.supplyAsync(() -> true, delayedExecutor);
        this.latestScheduled = scheduledFuture;
        ((CompletableFuture)scheduledFuture.thenApplyAsync(bool -> workspaceManager.waitAndGetPackageCompilation(projectRoot))).thenAccept(compilation -> compilation.ifPresent(pkgCompilation -> this.compileAndSendDiagnostics(client, projectRoot, (PackageCompilation)pkgCompilation, workspaceManager)));
    }

    public static org.eclipse.lsp4j.Diagnostic getLSDiagnosticsFromCompilationDiagnostics(LineRange lineRange, Diagnostic diag) {
        int startLine = lineRange.startLine().line();
        int startChar = lineRange.startLine().offset();
        int endLine = lineRange.endLine().line();
        int endChar = lineRange.endLine().offset();
        endLine = endLine <= 0 ? startLine : endLine;
        endChar = endChar <= 0 ? startChar + 1 : endChar;
        Range range = new Range(new Position(startLine, startChar), new Position(endLine, endChar));
        org.eclipse.lsp4j.Diagnostic diagnostic = new org.eclipse.lsp4j.Diagnostic(range, diag.message(), null, null, diag.diagnosticInfo().code());
        switch (diag.diagnosticInfo().severity()) {
            case ERROR: {
                diagnostic.setSeverity(DiagnosticSeverity.Error);
                break;
            }
            case WARNING: {
                diagnostic.setSeverity(DiagnosticSeverity.Warning);
                break;
            }
            case HINT: {
                diagnostic.setSeverity(DiagnosticSeverity.Hint);
                break;
            }
            case INFO: {
                diagnostic.setSeverity(DiagnosticSeverity.Information);
                break;
            }
        }
        return diagnostic;
    }
}

