/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.extensions.ballerina.document;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextRange;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.eclipse.lsp4j.Range;

public final class BallerinaLocateSyntaxTreeUtil {
    private static final String POSITION = "position";
    private static final String LOCATE_PATH_PROPERTY = "isNodePath";
    private static final String LOCATED_NODE_PROPERTY = "isLocatedNode";
    private static final String START_LINE = "startLine";
    private static final String START_COLUMN = "startColumn";
    private static final String END_LINE = "endLine";
    private static final String END_COLUMN = "endColumn";

    private BallerinaLocateSyntaxTreeUtil() {
    }

    public static JsonElement mapNodePath(Range range, SyntaxTree syntaxTree, JsonElement syntaxTreeJson) {
        syntaxTreeJson.getAsJsonObject().addProperty(LOCATE_PATH_PROPERTY, Boolean.valueOf(true));
        NonTerminalNode node = CommonUtil.findNode(range, syntaxTree);
        if (node.kind() == SyntaxKind.LIST) {
            node = node.parent();
        }
        if (node == syntaxTree.rootNode()) {
            syntaxTreeJson.getAsJsonObject().addProperty(LOCATED_NODE_PROPERTY, Boolean.valueOf(true));
            return syntaxTreeJson;
        }
        return BallerinaLocateSyntaxTreeUtil.findNodePath(syntaxTreeJson, syntaxTree, node);
    }

    private static JsonElement findNodePath(JsonElement syntaxTreeJson, SyntaxTree syntaxTree, NonTerminalNode node) {
        Optional<JsonElement> temp = Optional.of(syntaxTreeJson);
        while (temp.isPresent()) {
            temp = BallerinaLocateSyntaxTreeUtil.findChildren(syntaxTree, node, temp.get());
        }
        return syntaxTreeJson;
    }

    private static Optional<JsonElement> findChildren(SyntaxTree syntaxTree, NonTerminalNode node, JsonElement jsonNode) {
        for (Map.Entry childEntry : jsonNode.getAsJsonObject().entrySet()) {
            if (((JsonElement)childEntry.getValue()).isJsonArray()) {
                for (JsonElement childProps : ((JsonElement)childEntry.getValue()).getAsJsonArray()) {
                    NodeRange nodeRange = BallerinaLocateSyntaxTreeUtil.evaluateRange(syntaxTree, node, childProps, childProps.getAsJsonObject().get(POSITION).getAsJsonObject());
                    if (nodeRange == NodeRange.INCLUSIVE) {
                        return Optional.of(childProps);
                    }
                    if (nodeRange != NodeRange.EQUALS) continue;
                    return Optional.empty();
                }
                continue;
            }
            if (!((JsonElement)childEntry.getValue()).isJsonObject() || !((JsonElement)childEntry.getValue()).getAsJsonObject().has(POSITION)) continue;
            NodeRange nodeRange = BallerinaLocateSyntaxTreeUtil.evaluateRange(syntaxTree, node, (JsonElement)childEntry.getValue(), ((JsonElement)childEntry.getValue()).getAsJsonObject().get(POSITION).getAsJsonObject());
            if (nodeRange == NodeRange.INCLUSIVE) {
                return Optional.ofNullable((JsonElement)childEntry.getValue());
            }
            if (nodeRange != NodeRange.EQUALS) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static NodeRange evaluateRange(SyntaxTree syntaxTree, NonTerminalNode node, JsonElement jsonNode, JsonObject position) {
        TextDocument textDocument = syntaxTree.textDocument();
        int start = textDocument.textPositionFrom(LinePosition.from((int)position.get(START_LINE).getAsInt(), (int)position.get(START_COLUMN).getAsInt()));
        int end = textDocument.textPositionFrom(LinePosition.from((int)position.get(END_LINE).getAsInt(), (int)position.get(END_COLUMN).getAsInt()));
        TextRange textRange = TextRange.from((int)start, (int)(end - start));
        if (node.textRange().startOffset() >= textRange.startOffset() && node.textRange().endOffset() <= textRange.endOffset()) {
            jsonNode.getAsJsonObject().addProperty(LOCATE_PATH_PROPERTY, Boolean.valueOf(true));
            if (textRange.equals((Object)node.textRange())) {
                jsonNode.getAsJsonObject().addProperty(LOCATED_NODE_PROPERTY, Boolean.valueOf(true));
                return NodeRange.EQUALS;
            }
            return NodeRange.INCLUSIVE;
        }
        return NodeRange.EXCLUSIVE;
    }

    private static enum NodeRange {
        INCLUSIVE,
        EQUALS,
        EXCLUSIVE;

    }
}

