/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.extensions.ballerina.packages;

import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.langserver.extensions.ballerina.packages.DataObject;
import org.ballerinalang.langserver.extensions.ballerina.packages.MapperObject;

public class ModuleObject {
    private final List<DataObject> functions = new ArrayList<DataObject>();
    private final List<DataObject> services = new ArrayList<DataObject>();
    private final List<DataObject> records = new ArrayList<DataObject>();
    private final List<DataObject> objects = new ArrayList<DataObject>();
    private final List<DataObject> classes = new ArrayList<DataObject>();
    private final List<DataObject> types = new ArrayList<DataObject>();
    private final List<DataObject> constants = new ArrayList<DataObject>();
    private final List<DataObject> enums = new ArrayList<DataObject>();
    private final List<DataObject> listeners = new ArrayList<DataObject>();
    private final List<DataObject> moduleVariables = new ArrayList<DataObject>();
    private final List<DataObject> configurableVariables = new ArrayList<DataObject>();
    private final List<DataObject> automations = new ArrayList<DataObject>();
    private final List<DataObject> naturalFunctions = new ArrayList<DataObject>();
    private String name;

    protected void setName(String name) {
        this.name = name;
    }

    protected String getName() {
        return this.name;
    }

    protected void addFunction(DataObject dataObject) {
        this.functions.add(dataObject);
    }

    private void addConstant(DataObject dataObject) {
        this.constants.add(dataObject);
    }

    private void addService(DataObject dataObject) {
        this.services.add(dataObject);
    }

    private void addRecord(DataObject dataObject) {
        this.records.add(dataObject);
    }

    private void addObject(DataObject dataObject) {
        this.objects.add(dataObject);
    }

    private void addClass(DataObject dataObject) {
        this.classes.add(dataObject);
    }

    private void addType(DataObject dataObject) {
        this.types.add(dataObject);
    }

    private void addAutomation(DataObject dataObject) {
        this.automations.add(dataObject);
        this.functions.add(dataObject);
    }

    private void addNaturalFunction(DataObject dataObject) {
        this.naturalFunctions.add(dataObject);
    }

    private void addModuleVariable(DataObject dataObject) {
        this.moduleVariables.add(dataObject);
    }

    private void addConfigurableVariable(DataObject dataObject) {
        this.configurableVariables.add(dataObject);
        this.moduleVariables.add(dataObject);
    }

    private void addListener(DataObject dataObject) {
        this.listeners.add(dataObject);
    }

    private void addEnum(DataObject dataObject) {
        this.enums.add(dataObject);
    }

    protected void addDataObject(MapperObject mapperObject) {
        switch (mapperObject.getKey()) {
            case "functions": {
                this.addFunction(mapperObject.getDataObject());
                break;
            }
            case "services": {
                this.addService(mapperObject.getDataObject());
                break;
            }
            case "constants": {
                this.addConstant(mapperObject.getDataObject());
                break;
            }
            case "records": {
                this.addRecord(mapperObject.getDataObject());
                break;
            }
            case "objects": {
                this.addObject(mapperObject.getDataObject());
                break;
            }
            case "classes": {
                this.addClass(mapperObject.getDataObject());
                break;
            }
            case "types": {
                this.addType(mapperObject.getDataObject());
                break;
            }
            case "enums": {
                this.addEnum(mapperObject.getDataObject());
                break;
            }
            case "listeners": {
                this.addListener(mapperObject.getDataObject());
                break;
            }
            case "moduleVariables": {
                this.addModuleVariable(mapperObject.getDataObject());
                break;
            }
            case "configurableVariables": {
                this.addConfigurableVariable(mapperObject.getDataObject());
                break;
            }
            case "automations": {
                this.addAutomation(mapperObject.getDataObject());
                break;
            }
            case "naturalFunctions": {
                this.addNaturalFunction(mapperObject.getDataObject());
                break;
            }
        }
    }
}

