/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.foldingrange;

import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.DoStatementNode;
import io.ballerina.compiler.syntax.tree.ElseBlockNode;
import io.ballerina.compiler.syntax.tree.EnumDeclarationNode;
import io.ballerina.compiler.syntax.tree.ExternalFunctionBodyNode;
import io.ballerina.compiler.syntax.tree.ForEachStatementNode;
import io.ballerina.compiler.syntax.tree.ForkStatementNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyBlockNode;
import io.ballerina.compiler.syntax.tree.IfElseStatementNode;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.LockStatementNode;
import io.ballerina.compiler.syntax.tree.MatchClauseNode;
import io.ballerina.compiler.syntax.tree.MatchStatementNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.MethodDeclarationNode;
import io.ballerina.compiler.syntax.tree.NamedWorkerDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.ObjectTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.OnFailClauseNode;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.RetryStatementNode;
import io.ballerina.compiler.syntax.tree.ReturnStatementNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.TransactionStatementNode;
import io.ballerina.compiler.syntax.tree.WhileStatementNode;
import io.ballerina.tools.text.LineRange;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.lsp4j.FoldingRange;

public class FoldingRangeFinder
extends NodeVisitor {
    private final List<FoldingRange> foldingRanges = new ArrayList<FoldingRange>();
    private final List<ImportDeclarationNode> imports = new ArrayList<ImportDeclarationNode>();
    private final boolean lineFoldingOnly;

    FoldingRangeFinder(boolean lineFoldingOnly) {
        this.lineFoldingOnly = lineFoldingOnly;
    }

    public void visit(ImportDeclarationNode importDeclarationNode) {
        this.imports.add(importDeclarationNode);
    }

    public void visit(RecordTypeDescriptorNode recordTypeDescriptorNode) {
        this.appendNodeFoldingRanges((Node)recordTypeDescriptorNode);
    }

    public void visit(IfElseStatementNode ifElseStatementNode) {
        LineRange ifElseLineRange = ifElseStatementNode.lineRange();
        LineRange ifBodyLineRange = ifElseStatementNode.ifBody().lineRange();
        this.foldingRanges.removeIf(foldingRange -> ifElseLineRange.startLine().line() == foldingRange.getStartLine());
        this.foldingRanges.add(this.createFoldingRange(ifElseLineRange.startLine().line(), ifBodyLineRange.endLine().line() - 1, ifElseLineRange.startLine().offset(), ifBodyLineRange.endLine().offset(), "region"));
        this.visitSyntaxNode((Node)ifElseStatementNode);
    }

    public void visit(ElseBlockNode elseBlockNode) {
        this.appendNodeFoldingRanges((Node)elseBlockNode);
        this.visitSyntaxNode((Node)elseBlockNode);
    }

    public void visit(FunctionBodyBlockNode functionBodyBlockNode) {
        this.appendNodeFoldingRanges((Node)functionBodyBlockNode);
        this.visitSyntaxNode((Node)functionBodyBlockNode);
    }

    public void visit(ClassDefinitionNode classDefinitionNode) {
        this.foldingRanges.add(this.createFoldingRange(classDefinitionNode.openBrace().lineRange().startLine().line(), classDefinitionNode.closeBrace().lineRange().endLine().line() - 1, classDefinitionNode.openBrace().lineRange().startLine().offset(), classDefinitionNode.closeBrace().lineRange().endLine().offset(), "region"));
        this.visitSyntaxNode((Node)classDefinitionNode);
    }

    public void visit(MethodDeclarationNode methodDeclarationNode) {
        int functionKeyWordLine = methodDeclarationNode.functionKeyword().lineRange().startLine().line();
        int semicolonLine = methodDeclarationNode.semicolon().lineRange().startLine().line();
        this.foldingRanges.add(this.createFoldingRange(functionKeyWordLine, semicolonLine, methodDeclarationNode.functionKeyword().lineRange().startLine().offset(), methodDeclarationNode.semicolon().lineRange().startLine().offset(), "region"));
        this.visitSyntaxNode((Node)methodDeclarationNode);
    }

    public void visit(ObjectTypeDescriptorNode objectTypeDescriptorNode) {
        this.foldingRanges.add(this.createFoldingRange(objectTypeDescriptorNode.openBrace().lineRange().startLine().line(), objectTypeDescriptorNode.closeBrace().lineRange().endLine().line() - 1, objectTypeDescriptorNode.openBrace().lineRange().startLine().offset(), objectTypeDescriptorNode.closeBrace().lineRange().endLine().offset(), "region"));
        this.visitSyntaxNode((Node)objectTypeDescriptorNode);
    }

    public void visit(ServiceDeclarationNode serviceDeclarationNode) {
        this.foldingRanges.add(this.createFoldingRange(serviceDeclarationNode.openBraceToken().lineRange().startLine().line(), serviceDeclarationNode.closeBraceToken().lineRange().endLine().line() - 1, serviceDeclarationNode.openBraceToken().lineRange().startLine().offset(), serviceDeclarationNode.closeBraceToken().lineRange().startLine().offset(), "region"));
        this.visitSyntaxNode((Node)serviceDeclarationNode);
    }

    public void visit(MetadataNode metadataNode) {
        LineRange lineRange = metadataNode.lineRange();
        this.foldingRanges.add(this.createFoldingRange(lineRange.startLine().line(), lineRange.endLine().line(), lineRange.startLine().offset(), lineRange.endLine().offset(), "comment"));
    }

    public void visit(ForEachStatementNode forEachStatementNode) {
        this.appendBlockFoldingRanges(forEachStatementNode.blockStatement());
        this.visitSyntaxNode((Node)forEachStatementNode);
    }

    public void visit(WhileStatementNode whileStatementNode) {
        this.appendBlockFoldingRanges(whileStatementNode.whileBody());
        this.visitSyntaxNode((Node)whileStatementNode);
    }

    public void visit(EnumDeclarationNode enumDeclarationNode) {
        this.foldingRanges.add(this.createFoldingRange(enumDeclarationNode.openBraceToken().lineRange().startLine().line(), enumDeclarationNode.closeBraceToken().lineRange().endLine().line() - 1, enumDeclarationNode.openBraceToken().lineRange().startLine().offset(), enumDeclarationNode.closeBraceToken().lineRange().startLine().offset(), "region"));
        this.visitSyntaxNode((Node)enumDeclarationNode);
    }

    public void visit(TransactionStatementNode transactionStatementNode) {
        this.appendBlockFoldingRanges(transactionStatementNode.blockStatement());
        this.visitSyntaxNode((Node)transactionStatementNode);
    }

    public void visit(ExternalFunctionBodyNode externalFunctionBodyNode) {
        this.appendNodeFoldingRanges((Node)externalFunctionBodyNode);
        this.visitSyntaxNode((Node)externalFunctionBodyNode);
    }

    public void visit(MatchStatementNode matchStatementNode) {
        this.foldingRanges.add(this.createFoldingRange(matchStatementNode.openBrace().lineRange().startLine().line(), matchStatementNode.closeBrace().lineRange().endLine().line() - 1, matchStatementNode.openBrace().lineRange().startLine().offset(), matchStatementNode.closeBrace().lineRange().startLine().offset(), "region"));
        this.visitSyntaxNode((Node)matchStatementNode);
    }

    public void visit(MatchClauseNode matchClauseNode) {
        this.appendBlockFoldingRanges(matchClauseNode.blockStatement());
        this.visitSyntaxNode((Node)matchClauseNode);
    }

    public void visit(ForkStatementNode forkStatementNode) {
        this.foldingRanges.add(this.createFoldingRange(forkStatementNode.openBraceToken().lineRange().startLine().line(), forkStatementNode.closeBraceToken().lineRange().endLine().line() - 1, forkStatementNode.openBraceToken().lineRange().startLine().offset(), forkStatementNode.closeBraceToken().lineRange().startLine().offset(), "region"));
        this.visitSyntaxNode((Node)forkStatementNode);
    }

    public void visit(RetryStatementNode retryStatementNode) {
        this.appendNodeFoldingRanges((Node)retryStatementNode.retryBody());
        this.visitSyntaxNode((Node)retryStatementNode);
    }

    public void visit(NamedWorkerDeclarationNode namedWorkerDeclarationNode) {
        this.appendBlockFoldingRanges(namedWorkerDeclarationNode.workerBody());
        this.visitSyntaxNode((Node)namedWorkerDeclarationNode);
    }

    public void visit(OnFailClauseNode onFailClauseNode) {
        this.appendBlockFoldingRanges(onFailClauseNode.blockStatement());
        this.visitSyntaxNode((Node)onFailClauseNode);
    }

    public void visit(DoStatementNode doStatementNode) {
        this.appendBlockFoldingRanges(doStatementNode.blockStatement());
        this.visitSyntaxNode((Node)doStatementNode);
    }

    public void visit(LockStatementNode lockStatementNode) {
        this.appendBlockFoldingRanges(lockStatementNode.blockStatement());
        this.visitSyntaxNode((Node)lockStatementNode);
    }

    public void visit(ReturnStatementNode returnStatementNode) {
        LineRange lineRange = returnStatementNode.lineRange();
        this.foldingRanges.add(this.createFoldingRange(lineRange.startLine().line(), lineRange.endLine().line(), lineRange.startLine().offset(), lineRange.endLine().offset(), "region"));
        this.visitSyntaxNode((Node)returnStatementNode);
    }

    public List<FoldingRange> getFoldingRange(Node node) {
        this.visitSyntaxNode(node);
        int length = this.imports.size();
        if (length > 1) {
            ImportDeclarationNode firstImport = this.imports.get(0);
            ImportDeclarationNode lastImport = this.imports.get(length - 1);
            this.foldingRanges.add(this.createFoldingRange(firstImport.lineRange().startLine().line(), lastImport.lineRange().endLine().line(), firstImport.importKeyword().lineRange().startLine().offset(), lastImport.semicolon().lineRange().endLine().offset(), "region"));
        }
        return this.foldingRanges;
    }

    public FoldingRange createFoldingRange(int startLine, int endLine, int startCharacter, int endCharacter, String kind) {
        FoldingRange foldingRange = new FoldingRange(startLine, endLine);
        foldingRange.setKind(kind);
        if (!this.lineFoldingOnly) {
            foldingRange.setStartCharacter(Integer.valueOf(startCharacter));
            foldingRange.setEndCharacter(Integer.valueOf(endCharacter));
        }
        return foldingRange;
    }

    private void appendNodeFoldingRanges(Node node) {
        LineRange lineRange = node.lineRange();
        this.foldingRanges.add(this.createFoldingRange(lineRange.startLine().line(), lineRange.endLine().line() - 1, lineRange.startLine().offset(), lineRange.endLine().offset(), "region"));
    }

    private void appendBlockFoldingRanges(BlockStatementNode blockStatementNode) {
        this.foldingRanges.add(this.createFoldingRange(blockStatementNode.openBraceToken().lineRange().startLine().line(), blockStatementNode.closeBraceToken().lineRange().endLine().line() - 1, blockStatementNode.openBraceToken().lineRange().startLine().offset(), blockStatementNode.closeBraceToken().lineRange().startLine().offset(), "region"));
    }
}

