/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.hover;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.projects.Package;
import io.ballerina.projects.Project;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.commons.HoverContext;

public class HoverSymbolResolver
extends NodeTransformer<Optional<Symbol>> {
    private final List<Node> visitedNodes = new ArrayList<Node>();
    private final SemanticModel semanticModel;
    private final HoverContext context;
    private boolean isSymbolReferable = true;

    public HoverSymbolResolver(HoverContext context, SemanticModel semanticModel) {
        this.semanticModel = semanticModel;
        this.context = context;
    }

    protected Optional<Symbol> transformSyntaxNode(Node node) {
        return this.visit((Node)node.parent());
    }

    private Optional<Symbol> visit(Node node) {
        if (node == null || this.visitedNodes.contains(node)) {
            return Optional.empty();
        }
        this.visitedNodes.add(node);
        return (Optional)node.apply((NodeTransformer)this);
    }

    public Optional<Symbol> transform(QualifiedNameReferenceNode qualifiedNameReferenceNode) {
        Optional symbol = this.semanticModel.symbol((Node)qualifiedNameReferenceNode);
        symbol.ifPresent(this::setSymbolReferable);
        return symbol;
    }

    public void setSymbolReferable(Symbol symbol) {
        Optional<Package> currentPackage = this.context.workspace().project(this.context.filePath()).map(Project::currentPackage);
        Optional<ModuleID> moduleID = symbol.getModule().map(ModuleSymbol::id);
        if (currentPackage.isEmpty() || moduleID.isEmpty()) {
            this.isSymbolReferable = false;
            return;
        }
        if (moduleID.get().packageName().equals(currentPackage.get().packageName().toString()) && moduleID.get().orgName().equals(currentPackage.get().packageOrg().value())) {
            this.isSymbolReferable = false;
            return;
        }
        this.isSymbolReferable = true;
    }

    public boolean isSymbolReferable() {
        return Boolean.TRUE.equals(this.isSymbolReferable);
    }
}

