/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.semantictokens;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.IntersectionTypeSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.AnnotationDeclarationNode;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.ConstantDeclarationNode;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.EnumDeclarationNode;
import io.ballerina.compiler.syntax.tree.EnumMemberNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.IncludedRecordParameterNode;
import io.ballerina.compiler.syntax.tree.IntersectionTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.KeySpecifierNode;
import io.ballerina.compiler.syntax.tree.MarkdownParameterDocumentationLineNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.MethodDeclarationNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.RecordFieldNode;
import io.ballerina.compiler.syntax.tree.RecordFieldWithDefaultValueNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.RestParameterNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.projects.Document;
import io.ballerina.projects.Module;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.ballerinalang.langserver.commons.SemanticTokensContext;
import org.eclipse.lsp4j.SemanticTokens;

public class SemanticTokensVisitor
extends NodeVisitor {
    private final Set<SemanticToken> semanticTokens = new TreeSet<SemanticToken>(SemanticToken.semanticTokenComparator);
    private final SemanticTokensContext semanticTokensContext;

    public SemanticTokensVisitor(SemanticTokensContext semanticTokensContext) {
        this.semanticTokensContext = semanticTokensContext;
    }

    public SemanticTokens getSemanticTokens(Node node) {
        ArrayList<Integer> data = new ArrayList<Integer>();
        this.visitSyntaxNode(node);
        SemanticToken previousToken = null;
        for (SemanticToken semanticToken : this.semanticTokens) {
            previousToken = semanticToken.processSemanticToken(data, previousToken);
        }
        return new SemanticTokens(data);
    }

    public void visit(ImportDeclarationNode importDeclarationNode) {
        Optional importPrefixNode = importDeclarationNode.prefix();
        importPrefixNode.ifPresent(prefixNode -> this.addSemanticToken((Node)prefixNode.prefix(), SemanticTokensContext.TokenTypes.NAMESPACE.getId(), SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId(), true, SemanticTokensContext.TokenTypes.NAMESPACE.getId(), 0));
    }

    public void visit(FunctionDefinitionNode functionDefinitionNode) {
        int type;
        int n = type = functionDefinitionNode.kind() == SyntaxKind.OBJECT_METHOD_DEFINITION ? SemanticTokensContext.TokenTypes.METHOD.getId() : SemanticTokensContext.TokenTypes.FUNCTION.getId();
        if (functionDefinitionNode.kind() == SyntaxKind.RESOURCE_ACCESSOR_DEFINITION) {
            this.addSemanticToken((Node)functionDefinitionNode.functionName(), type, SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId(), false, -1, -1);
            functionDefinitionNode.relativeResourcePath().stream().filter(resourcePath -> resourcePath.kind() == SyntaxKind.IDENTIFIER_TOKEN).forEach(resourcePath -> this.addSemanticToken((Node)resourcePath, type, SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId(), false, -1, -1));
        } else {
            this.addSemanticToken((Node)functionDefinitionNode.functionName(), type, SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId(), true, type, 0);
        }
        this.visitSyntaxNode((Node)functionDefinitionNode);
    }

    public void visit(MethodDeclarationNode methodDeclarationNode) {
        this.addSemanticToken((Node)methodDeclarationNode.methodName(), SemanticTokensContext.TokenTypes.METHOD.getId(), SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId(), false, -1, -1);
        this.visitSyntaxNode((Node)methodDeclarationNode);
    }

    public void visit(FunctionCallExpressionNode functionCallExpressionNode) {
        NameReferenceNode functionName = functionCallExpressionNode.functionName();
        if (functionName instanceof QualifiedNameReferenceNode) {
            QualifiedNameReferenceNode qualifiedNameReferenceNode = (QualifiedNameReferenceNode)functionName;
            functionName = qualifiedNameReferenceNode.identifier();
        }
        this.addSemanticToken((Node)functionName, SemanticTokensContext.TokenTypes.FUNCTION.getId(), 0, false, -1, -1);
        this.visitSyntaxNode((Node)functionCallExpressionNode);
    }

    public void visit(MethodCallExpressionNode methodCallExpressionNode) {
        this.addSemanticToken((Node)methodCallExpressionNode.methodName(), SemanticTokensContext.TokenTypes.METHOD.getId(), SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId(), false, -1, -1);
        this.visitSyntaxNode((Node)methodCallExpressionNode);
    }

    public void visit(RequiredParameterNode requiredParameterNode) {
        boolean isReadonly = this.isReadonly(requiredParameterNode.typeName());
        requiredParameterNode.paramName().ifPresent(token -> this.addSemanticToken((Node)token, SemanticTokensContext.TokenTypes.PARAMETER.getId(), isReadonly ? SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId() | SemanticTokensContext.TokenTypeModifiers.READONLY.getId() : SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId(), true, SemanticTokensContext.TokenTypes.PARAMETER.getId(), isReadonly ? SemanticTokensContext.TokenTypeModifiers.READONLY.getId() : 0));
        this.visitSyntaxNode((Node)requiredParameterNode);
    }

    public void visit(TypedBindingPatternNode typedBindingPatternNode) {
        TypeDescriptorNode typeDescriptorNode = typedBindingPatternNode.typeDescriptor();
        this.processSymbols((Node)typeDescriptorNode, typeDescriptorNode.lineRange().startLine());
        this.visitSyntaxNode((Node)typedBindingPatternNode);
    }

    public void visit(CaptureBindingPatternNode captureBindingPatternNode) {
        boolean readonly = false;
        if (captureBindingPatternNode.parent() instanceof TypedBindingPatternNode) {
            readonly = this.isReadonly((Node)((TypedBindingPatternNode)captureBindingPatternNode.parent()).typeDescriptor());
        }
        this.addSemanticToken((Node)captureBindingPatternNode, SemanticTokensContext.TokenTypes.VARIABLE.getId(), readonly ? SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId() | SemanticTokensContext.TokenTypeModifiers.READONLY.getId() : SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId(), true, SemanticTokensContext.TokenTypes.VARIABLE.getId(), readonly ? SemanticTokensContext.TokenTypeModifiers.READONLY.getId() : 0);
        this.visitSyntaxNode((Node)captureBindingPatternNode);
    }

    public void visit(SimpleNameReferenceNode simpleNameReferenceNode) {
        if (!"self".equals(simpleNameReferenceNode.name().text())) {
            this.processSymbols((Node)simpleNameReferenceNode, simpleNameReferenceNode.lineRange().startLine());
        }
        this.visitSyntaxNode((Node)simpleNameReferenceNode);
    }

    public void visit(QualifiedNameReferenceNode qualifiedNameReferenceNode) {
        this.addSemanticToken((Node)qualifiedNameReferenceNode.modulePrefix(), SemanticTokensContext.TokenTypes.NAMESPACE.getId(), 0, false, -1, -1);
        IdentifierToken identifier = qualifiedNameReferenceNode.identifier();
        this.processSymbols((Node)identifier, identifier.lineRange().startLine());
        this.visitSyntaxNode((Node)qualifiedNameReferenceNode);
    }

    public void visit(ConstantDeclarationNode constantDeclarationNode) {
        this.addSemanticToken((Node)constantDeclarationNode.variableName(), SemanticTokensContext.TokenTypes.VARIABLE.getId(), SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId() | SemanticTokensContext.TokenTypeModifiers.READONLY.getId(), true, SemanticTokensContext.TokenTypes.VARIABLE.getId(), SemanticTokensContext.TokenTypeModifiers.READONLY.getId());
        this.visitSyntaxNode((Node)constantDeclarationNode);
    }

    public void visit(ClassDefinitionNode classDefinitionNode) {
        boolean isReadonly = false;
        if (!classDefinitionNode.classTypeQualifiers().isEmpty() && classDefinitionNode.classTypeQualifiers().stream().anyMatch(qualifier -> qualifier.text().equals("readonly"))) {
            isReadonly = true;
        }
        this.addSemanticToken((Node)classDefinitionNode.className(), SemanticTokensContext.TokenTypes.CLASS.getId(), isReadonly ? SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId() | SemanticTokensContext.TokenTypeModifiers.READONLY.getId() : SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId(), true, SemanticTokensContext.TokenTypes.CLASS.getId(), isReadonly ? SemanticTokensContext.TokenTypeModifiers.READONLY.getId() : 0);
        this.visitSyntaxNode((Node)classDefinitionNode);
    }

    public void visit(ServiceDeclarationNode serviceDeclarationNode) {
        serviceDeclarationNode.absoluteResourcePath().forEach(serviceName -> {
            LinePosition startLine = serviceName.lineRange().startLine();
            SemanticToken semanticToken = new SemanticToken(startLine.line(), startLine.offset(), serviceName.textRange().length(), SemanticTokensContext.TokenTypes.TYPE.getId(), SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId());
            this.semanticTokens.add(semanticToken);
        });
        this.visitSyntaxNode((Node)serviceDeclarationNode);
    }

    public void visit(EnumDeclarationNode enumDeclarationNode) {
        this.addSemanticToken((Node)enumDeclarationNode.identifier(), SemanticTokensContext.TokenTypes.ENUM.getId(), SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId(), true, SemanticTokensContext.TokenTypes.ENUM.getId(), 0);
        this.visitSyntaxNode((Node)enumDeclarationNode);
    }

    public void visit(EnumMemberNode enumMemberNode) {
        this.addSemanticToken((Node)enumMemberNode.identifier(), SemanticTokensContext.TokenTypes.ENUM_MEMBER.getId(), SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId() | SemanticTokensContext.TokenTypeModifiers.READONLY.getId(), true, SemanticTokensContext.TokenTypes.ENUM_MEMBER.getId(), SemanticTokensContext.TokenTypeModifiers.READONLY.getId());
        this.visitSyntaxNode((Node)enumMemberNode);
    }

    public void visit(AnnotationNode annotationNode) {
        this.addSemanticToken((Node)annotationNode.atToken(), SemanticTokensContext.TokenTypes.NAMESPACE.getId(), 0, false, -1, -1);
        this.visitSyntaxNode((Node)annotationNode);
    }

    public void visit(MarkdownParameterDocumentationLineNode markdownParameterDocumentationLineNode) {
        if (!markdownParameterDocumentationLineNode.parameterName().text().equals("return")) {
            int type;
            switch (markdownParameterDocumentationLineNode.parent().parent().parent().kind()) {
                case RECORD_FIELD: 
                case OBJECT_FIELD: {
                    type = SemanticTokensContext.TokenTypes.PROPERTY.getId();
                    break;
                }
                case TYPE_DEFINITION: {
                    TypeDefinitionNode typeDefinitionNode;
                    SyntaxKind kind;
                    NonTerminalNode node = markdownParameterDocumentationLineNode.parent().parent().parent();
                    type = SemanticTokensContext.TokenTypes.TYPE_PARAMETER.getId();
                    if (!(node instanceof TypeDefinitionNode) || (kind = (typeDefinitionNode = (TypeDefinitionNode)node).typeDescriptor().kind()) != SyntaxKind.OBJECT_TYPE_DESC && kind != SyntaxKind.RECORD_TYPE_DESC) break;
                    type = SemanticTokensContext.TokenTypes.PROPERTY.getId();
                    break;
                }
                default: {
                    type = SemanticTokensContext.TokenTypes.PARAMETER.getId();
                }
            }
            this.addSemanticToken((Node)markdownParameterDocumentationLineNode.parameterName(), type, SemanticTokensContext.TokenTypeModifiers.DOCUMENTATION.getId(), false, -1, -1);
        }
        this.visitSyntaxNode((Node)markdownParameterDocumentationLineNode);
    }

    public void visit(TypeDefinitionNode typeDefinitionNode) {
        int type = SemanticTokensContext.TokenTypes.TYPE.getId();
        int modifiers = 0;
        int refModifiers = 0;
        Node typeDescriptor = typeDefinitionNode.typeDescriptor();
        switch (typeDescriptor.kind()) {
            case OBJECT_TYPE_DESC: {
                type = SemanticTokensContext.TokenTypes.INTERFACE.getId();
                modifiers = SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId();
                break;
            }
            case RECORD_TYPE_DESC: {
                type = SemanticTokensContext.TokenTypes.STRUCT.getId();
                modifiers = SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId();
                break;
            }
            case INTERSECTION_TYPE_DESC: {
                if (!(typeDescriptor instanceof IntersectionTypeDescriptorNode)) break;
                IntersectionTypeDescriptorNode intSecDescriptor = (IntersectionTypeDescriptorNode)typeDescriptor;
                SyntaxKind left = intSecDescriptor.leftTypeDesc().kind();
                SyntaxKind right = intSecDescriptor.rightTypeDesc().kind();
                if (left == SyntaxKind.RECORD_TYPE_DESC || right == SyntaxKind.RECORD_TYPE_DESC) {
                    type = SemanticTokensContext.TokenTypes.STRUCT.getId();
                }
                if (left == SyntaxKind.READONLY_TYPE_DESC || right == SyntaxKind.READONLY_TYPE_DESC) {
                    modifiers = SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId() | SemanticTokensContext.TokenTypeModifiers.READONLY.getId();
                    refModifiers = SemanticTokensContext.TokenTypeModifiers.READONLY.getId();
                    break;
                }
                modifiers = SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId();
                break;
            }
            default: {
                type = SemanticTokensContext.TokenTypes.TYPE.getId();
                modifiers = SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId();
            }
        }
        this.addSemanticToken((Node)typeDefinitionNode.typeName(), type, modifiers, true, type, refModifiers);
        this.visitSyntaxNode((Node)typeDefinitionNode);
    }

    public void visit(RecordFieldNode recordFieldNode) {
        Token token = recordFieldNode.fieldName();
        LinePosition startLine = token.lineRange().startLine();
        SemanticToken semanticToken = new SemanticToken(startLine.line(), startLine.offset());
        if (!this.semanticTokens.contains(semanticToken)) {
            int refModifiers;
            int modifiers;
            int length = token.text().trim().length();
            if (recordFieldNode.readonlyKeyword().isPresent()) {
                modifiers = SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId() | SemanticTokensContext.TokenTypeModifiers.READONLY.getId();
                refModifiers = SemanticTokensContext.TokenTypeModifiers.READONLY.getId();
            } else {
                modifiers = SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId();
                refModifiers = 0;
            }
            semanticToken.setProperties(length, SemanticTokensContext.TokenTypes.PROPERTY.getId(), modifiers);
            this.semanticTokens.add(semanticToken);
            this.handleReferences(startLine, length, SemanticTokensContext.TokenTypes.PROPERTY.getId(), refModifiers);
        }
        this.visitSyntaxNode((Node)recordFieldNode);
    }

    public void visit(RecordFieldWithDefaultValueNode recordFieldWithDefaultValueNode) {
        Token token = recordFieldWithDefaultValueNode.fieldName();
        LinePosition startLine = token.lineRange().startLine();
        SemanticToken semanticToken = new SemanticToken(startLine.line(), startLine.offset());
        if (!this.semanticTokens.contains(semanticToken)) {
            int refModifiers;
            int modifiers;
            int length = token.text().trim().length();
            if (recordFieldWithDefaultValueNode.readonlyKeyword().isPresent()) {
                modifiers = SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId() | SemanticTokensContext.TokenTypeModifiers.READONLY.getId();
                refModifiers = SemanticTokensContext.TokenTypeModifiers.READONLY.getId();
            } else {
                modifiers = SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId();
                refModifiers = 0;
            }
            semanticToken.setProperties(length, SemanticTokensContext.TokenTypes.PROPERTY.getId(), modifiers);
            this.semanticTokens.add(semanticToken);
            this.handleReferences(startLine, length, SemanticTokensContext.TokenTypes.PROPERTY.getId(), refModifiers);
        }
        this.visitSyntaxNode((Node)recordFieldWithDefaultValueNode);
    }

    public void visit(KeySpecifierNode keySpecifierNode) {
        keySpecifierNode.fieldNames().forEach(field -> this.addSemanticToken((Node)field, SemanticTokensContext.TokenTypes.PROPERTY.getId(), SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId(), false, -1, -1));
        this.visitSyntaxNode((Node)keySpecifierNode);
    }

    public void visit(SpecificFieldNode specificFieldNode) {
        this.processSymbols(specificFieldNode.fieldName(), specificFieldNode.fieldName().location().lineRange().startLine());
        this.visitSyntaxNode((Node)specificFieldNode);
    }

    public void visit(ObjectFieldNode objectFieldNode) {
        SyntaxKind kind = objectFieldNode.parent().kind();
        int type = kind == SyntaxKind.CLASS_DEFINITION || kind == SyntaxKind.OBJECT_TYPE_DESC || kind == SyntaxKind.RECORD_TYPE_DESC || kind == SyntaxKind.OBJECT_CONSTRUCTOR ? SemanticTokensContext.TokenTypes.PROPERTY.getId() : (kind == SyntaxKind.SERVICE_DECLARATION ? SemanticTokensContext.TokenTypes.VARIABLE.getId() : SemanticTokensContext.TokenTypes.TYPE_PARAMETER.getId());
        boolean isReadOnly = this.isReadonly(objectFieldNode.typeName());
        this.addSemanticToken((Node)objectFieldNode.fieldName(), type, isReadOnly ? SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId() | SemanticTokensContext.TokenTypeModifiers.READONLY.getId() : SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId(), true, type, isReadOnly ? SemanticTokensContext.TokenTypeModifiers.READONLY.getId() : 0);
        this.visitSyntaxNode((Node)objectFieldNode);
    }

    public void visit(AnnotationDeclarationNode annotationDeclarationNode) {
        this.addSemanticToken((Node)annotationDeclarationNode.annotationTag(), SemanticTokensContext.TokenTypes.TYPE.getId(), SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId(), true, SemanticTokensContext.TokenTypes.TYPE.getId(), 0);
        this.visitSyntaxNode((Node)annotationDeclarationNode);
    }

    public void visit(DefaultableParameterNode defaultableParameterNode) {
        defaultableParameterNode.paramName().ifPresent(token -> this.addSemanticToken((Node)token, SemanticTokensContext.TokenTypes.PARAMETER.getId(), SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId(), true, SemanticTokensContext.TokenTypes.PARAMETER.getId(), 0));
        this.visitSyntaxNode((Node)defaultableParameterNode);
    }

    public void visit(IncludedRecordParameterNode includedRecordParameterNode) {
        includedRecordParameterNode.paramName().ifPresent(token -> this.addSemanticToken((Node)token, SemanticTokensContext.TokenTypes.PARAMETER.getId(), SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId(), true, SemanticTokensContext.TokenTypes.PARAMETER.getId(), 0));
        this.visitSyntaxNode((Node)includedRecordParameterNode);
    }

    public void visit(RestParameterNode restParameterNode) {
        restParameterNode.paramName().ifPresent(token -> this.addSemanticToken((Node)token, SemanticTokensContext.TokenTypes.PARAMETER.getId(), SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId(), true, SemanticTokensContext.TokenTypes.PARAMETER.getId(), 0));
        this.visitSyntaxNode((Node)restParameterNode);
    }

    public void visit(NamedArgumentNode namedArgumentNode) {
        this.addSemanticToken((Node)namedArgumentNode.argumentName(), SemanticTokensContext.TokenTypes.VARIABLE.getId(), SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId(), false, -1, -1);
        this.visitSyntaxNode((Node)namedArgumentNode);
    }

    private boolean isReadonly(Node node) {
        if (node instanceof IntersectionTypeDescriptorNode) {
            IntersectionTypeDescriptorNode intSecDescriptor = (IntersectionTypeDescriptorNode)node;
            SyntaxKind left = intSecDescriptor.leftTypeDesc().kind();
            SyntaxKind right = intSecDescriptor.rightTypeDesc().kind();
            return left == SyntaxKind.READONLY_TYPE_DESC || right == SyntaxKind.READONLY_TYPE_DESC;
        }
        return false;
    }

    private void processSymbols(Node node, LinePosition startLine) {
        if (node.kind() == SyntaxKind.STRING_LITERAL || this.semanticTokens.contains(new SemanticToken(startLine.line(), startLine.offset()))) {
            return;
        }
        Optional semanticModel = this.semanticTokensContext.currentSemanticModel();
        if (semanticModel.isEmpty()) {
            return;
        }
        Optional symbol = ((SemanticModel)semanticModel.get()).symbol(node);
        if (symbol.isEmpty() || ((Symbol)symbol.get()).getLocation().isEmpty()) {
            return;
        }
        LineRange symbolLineRange = ((Location)((Symbol)symbol.get()).getLocation().get()).lineRange();
        LinePosition linePosition = symbolLineRange.startLine();
        SymbolKind kind = ((Symbol)symbol.get()).kind();
        String nodeName = node.toString().trim();
        if (nodeName.equals("self")) {
            return;
        }
        int declarationType = -1;
        int declarationModifiers = -1;
        int referenceType = -1;
        int referenceModifiers = -1;
        switch (kind) {
            case CLASS: {
                declarationType = SemanticTokensContext.TokenTypes.CLASS.getId();
                declarationModifiers = SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId();
                referenceType = SemanticTokensContext.TokenTypes.CLASS.getId();
                break;
            }
            case CLASS_FIELD: {
                declarationType = SemanticTokensContext.TokenTypes.PROPERTY.getId();
                declarationModifiers = SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId();
                referenceType = SemanticTokensContext.TokenTypes.PROPERTY.getId();
                break;
            }
            case CONSTANT: {
                declarationType = SemanticTokensContext.TokenTypes.VARIABLE.getId();
                declarationModifiers = SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId() | SemanticTokensContext.TokenTypeModifiers.READONLY.getId();
                referenceType = SemanticTokensContext.TokenTypes.VARIABLE.getId();
                referenceModifiers = SemanticTokensContext.TokenTypeModifiers.READONLY.getId();
                break;
            }
            case VARIABLE: {
                boolean isReadonly = ((VariableSymbol)symbol.get()).typeDescriptor().typeKind() == TypeDescKind.INTERSECTION && ((IntersectionTypeSymbol)((VariableSymbol)symbol.get()).typeDescriptor()).memberTypeDescriptors().stream().anyMatch(desc -> desc.typeKind() == TypeDescKind.READONLY);
                declarationType = SemanticTokensContext.TokenTypes.VARIABLE.getId();
                declarationModifiers = isReadonly ? SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId() | SemanticTokensContext.TokenTypeModifiers.READONLY.getId() : SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId();
                referenceType = SemanticTokensContext.TokenTypes.VARIABLE.getId();
                referenceModifiers = isReadonly ? SemanticTokensContext.TokenTypeModifiers.READONLY.getId() : 0;
                break;
            }
            case TYPE: {
                if (symbol.get() instanceof TypeReferenceTypeSymbol) {
                    TypeSymbol typeDescriptor = ((TypeReferenceTypeSymbol)symbol.get()).typeDescriptor();
                    int type = SemanticTokensContext.TokenTypes.TYPE.getId();
                    block12 : switch (typeDescriptor.kind()) {
                        case CLASS: {
                            type = SemanticTokensContext.TokenTypes.CLASS.getId();
                            if (typeDescriptor instanceof ClassSymbol && ((ClassSymbol)typeDescriptor).qualifiers().contains(Qualifier.READONLY)) {
                                declarationModifiers = SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId() | SemanticTokensContext.TokenTypeModifiers.READONLY.getId();
                                referenceModifiers = SemanticTokensContext.TokenTypeModifiers.READONLY.getId();
                                break;
                            }
                            declarationModifiers = SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId();
                            break;
                        }
                        case TYPE: {
                            switch (typeDescriptor.typeKind()) {
                                case RECORD: {
                                    type = SemanticTokensContext.TokenTypes.STRUCT.getId();
                                    declarationModifiers = SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId();
                                    break;
                                }
                                case OBJECT: {
                                    type = SemanticTokensContext.TokenTypes.INTERFACE.getId();
                                    break;
                                }
                                case INTERSECTION: {
                                    IntersectionTypeSymbol intSecSymbol = (IntersectionTypeSymbol)typeDescriptor;
                                    if (intSecSymbol.effectiveTypeDescriptor().typeKind() != TypeDescKind.RECORD) break block12;
                                    type = SemanticTokensContext.TokenTypes.STRUCT.getId();
                                    if (intSecSymbol.memberTypeDescriptors().stream().anyMatch(desc -> desc.typeKind() == TypeDescKind.READONLY)) {
                                        declarationModifiers = SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId() | SemanticTokensContext.TokenTypeModifiers.READONLY.getId();
                                        referenceModifiers = SemanticTokensContext.TokenTypeModifiers.READONLY.getId();
                                        break;
                                    }
                                    declarationModifiers = SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId();
                                    break;
                                }
                                case UNION: {
                                    if (((TypeReferenceTypeSymbol)symbol.get()).definition().kind() != SymbolKind.ENUM) break block12;
                                    type = SemanticTokensContext.TokenTypes.ENUM.getId();
                                    declarationModifiers = SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId();
                                    break;
                                }
                                default: {
                                    type = SemanticTokensContext.TokenTypes.TYPE.getId();
                                    break;
                                }
                            }
                            break;
                        }
                        default: {
                            type = SemanticTokensContext.TokenTypes.TYPE.getId();
                        }
                    }
                    declarationType = type;
                    referenceType = type;
                    break;
                }
                declarationType = SemanticTokensContext.TokenTypes.TYPE.getId();
                referenceType = SemanticTokensContext.TokenTypes.TYPE.getId();
                declarationModifiers = SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId();
                break;
            }
            case RECORD_FIELD: {
                declarationType = SemanticTokensContext.TokenTypes.PROPERTY.getId();
                referenceType = SemanticTokensContext.TokenTypes.PROPERTY.getId();
                if (symbol.get() instanceof RecordFieldSymbol && ((RecordFieldSymbol)symbol.get()).qualifiers().contains(Qualifier.READONLY)) {
                    declarationModifiers = SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId() | SemanticTokensContext.TokenTypeModifiers.READONLY.getId();
                    referenceModifiers = SemanticTokensContext.TokenTypeModifiers.READONLY.getId();
                    break;
                }
                declarationModifiers = SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId();
                break;
            }
            case ENUM_MEMBER: {
                declarationType = SemanticTokensContext.TokenTypes.ENUM_MEMBER.getId();
                declarationModifiers = SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId() | SemanticTokensContext.TokenTypeModifiers.READONLY.getId();
                referenceType = SemanticTokensContext.TokenTypes.ENUM_MEMBER.getId();
                referenceModifiers = SemanticTokensContext.TokenTypeModifiers.READONLY.getId();
                break;
            }
            case FUNCTION: {
                declarationType = SemanticTokensContext.TokenTypes.FUNCTION.getId();
                declarationModifiers = SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId();
                referenceType = SemanticTokensContext.TokenTypes.FUNCTION.getId();
                break;
            }
            case METHOD: {
                declarationType = SemanticTokensContext.TokenTypes.METHOD.getId();
                declarationModifiers = SemanticTokensContext.TokenTypeModifiers.DECLARATION.getId();
                referenceType = SemanticTokensContext.TokenTypes.METHOD.getId();
                break;
            }
            case ANNOTATION: {
                this.addSemanticToken(node, SemanticTokensContext.TokenTypes.TYPE.getId(), 0, false, -1, -1);
                break;
            }
        }
        int length = node.textRange().length();
        if (declarationType != -1) {
            SemanticToken semanticToken;
            Optional moduleSymbol = ((Symbol)symbol.get()).getModule();
            if (symbolLineRange.fileName().equals(((Document)this.semanticTokensContext.currentDocument().get()).name()) && moduleSymbol.isPresent() && ((ModuleSymbol)moduleSymbol.get()).getName().isPresent() && this.semanticTokensContext.currentModule().isPresent() && ((String)((ModuleSymbol)moduleSymbol.get()).getName().get()).equals(((Module)this.semanticTokensContext.currentModule().get()).moduleId().moduleName()) && !this.semanticTokens.contains(semanticToken = new SemanticToken(linePosition.line(), linePosition.offset()))) {
                semanticToken.setProperties(length, declarationType, declarationModifiers == -1 ? 0 : declarationModifiers);
                this.semanticTokens.add(semanticToken);
            }
        }
        if (referenceType != -1) {
            int type = referenceType;
            int modifiers = referenceModifiers == -1 ? 0 : referenceModifiers;
            List locations = ((SemanticModel)semanticModel.get()).references((Symbol)symbol.get(), (Document)this.semanticTokensContext.currentDocument().get(), false);
            locations.stream().filter(location -> location.lineRange().fileName().equals(((Document)this.semanticTokensContext.currentDocument().get()).name())).forEach(location -> {
                LinePosition position = location.lineRange().startLine();
                SemanticToken semanticToken = new SemanticToken(position.line(), position.offset());
                if (!this.semanticTokens.contains(semanticToken) && location.textRange().length() == length) {
                    semanticToken.setProperties(length, type, modifiers);
                    this.semanticTokens.add(semanticToken);
                }
            });
        }
    }

    private void addSemanticToken(Node node, int type, int modifiers, boolean processReferences, int refType, int refModifiers) {
        LinePosition startLine = node.lineRange().startLine();
        SemanticToken semanticToken = new SemanticToken(startLine.line(), startLine.offset());
        if (!this.semanticTokens.contains(semanticToken)) {
            int length = node instanceof Token ? ((Token)node).text().trim().length() : node.textRange().length();
            semanticToken.setProperties(length, type, modifiers);
            this.semanticTokens.add(semanticToken);
            if (processReferences) {
                this.handleReferences(startLine, length, refType, refModifiers);
            }
        }
    }

    private void handleReferences(LinePosition linePosition, int length, int type, int modifiers) {
        Optional semanticModel = this.semanticTokensContext.currentSemanticModel();
        if (semanticModel.isEmpty()) {
            return;
        }
        Document document = (Document)this.semanticTokensContext.currentDocument().get();
        List locations = ((SemanticModel)semanticModel.get()).references(document, document, linePosition, false);
        locations.stream().filter(location -> location.lineRange().fileName().equals(document.name())).forEach(location -> {
            LinePosition position = location.lineRange().startLine();
            SemanticToken semanticToken = new SemanticToken(position.line(), position.offset());
            if (!this.semanticTokens.contains(semanticToken) && location.textRange().length() == length) {
                semanticToken.setProperties(length, type, modifiers);
                this.semanticTokens.add(semanticToken);
            }
        });
    }

    static class SemanticToken
    implements Comparable<SemanticToken> {
        private final int line;
        private final int column;
        private int length;
        private int type;
        private int modifiers;
        public static Comparator<SemanticToken> semanticTokenComparator = SemanticToken::compareTo;

        private SemanticToken(int line, int column) {
            this.line = line;
            this.column = column;
        }

        private SemanticToken(int line, int column, int length, int type, int modifiers) {
            this.line = line;
            this.column = column;
            this.length = length;
            this.type = type;
            this.modifiers = modifiers;
        }

        private int getLine() {
            return this.line;
        }

        private int getColumn() {
            return this.column;
        }

        private int getLength() {
            return this.length;
        }

        private int getType() {
            return this.type;
        }

        private int getModifiers() {
            return this.modifiers;
        }

        public void setProperties(int length, int type, int modifiers) {
            this.length = length;
            this.type = type;
            this.modifiers = modifiers;
        }

        public SemanticToken processSemanticToken(List<Integer> data, SemanticToken previousToken) {
            int line = this.getLine();
            int column = this.getColumn();
            int prevTokenLine = line;
            int prevTokenColumn = column;
            if (previousToken != null) {
                if (line == previousToken.getLine()) {
                    column -= previousToken.getColumn();
                }
                line -= previousToken.getLine();
            }
            data.add(line);
            data.add(column);
            data.add(this.getLength());
            data.add(this.getType());
            data.add(this.getModifiers());
            return new SemanticToken(prevTokenLine, prevTokenColumn);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            SemanticToken semanticToken = (SemanticToken)obj;
            return this.line == semanticToken.line && this.column == semanticToken.column;
        }

        public int hashCode() {
            return Objects.hash(this.line, this.column);
        }

        @Override
        public int compareTo(SemanticToken semanticToken) {
            if (this.line == semanticToken.line) {
                return this.column - semanticToken.column;
            }
            return this.line - semanticToken.line;
        }
    }
}

