/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.telemetry;

import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.LSClientLogger;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.codeaction.spi.LSCodeActionProvider;
import org.ballerinalang.langserver.commons.command.CommandArgument;
import org.ballerinalang.langserver.commons.command.spi.LSCommandExecutor;
import org.ballerinalang.langserver.telemetry.LSFeatureUsageTelemetryEvent;
import org.ballerinalang.langserver.telemetry.LSTelemetryEvent;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;

public final class TelemetryUtil {
    private static final String ARG_FEATURE_NAME = "feature.Name";
    private static final String ARG_FEATURE_CLASS = "feature.Class";
    private static final String ARG_FEATURE_TITLE = "feature.Title";

    private TelemetryUtil() {
    }

    public static void sendTelemetryEvent(LanguageServerContext serverContext, LSTelemetryEvent event) {
        LSClientLogger clientLogger = LSClientLogger.getInstance(serverContext);
        clientLogger.telemetryEvent(event);
    }

    public static Optional<LSFeatureUsageTelemetryEvent> featureUsageEventFromCommandArgs(List<CommandArgument> arguments) {
        String featureName = null;
        String featureClass = null;
        String featureTitle = null;
        for (CommandArgument argument : arguments) {
            switch (argument.key()) {
                case "feature.Name": {
                    featureName = (String)argument.valueAs(String.class);
                    break;
                }
                case "feature.Class": {
                    featureClass = (String)argument.valueAs(String.class);
                    break;
                }
                case "feature.Title": {
                    featureTitle = (String)argument.valueAs(String.class);
                    break;
                }
            }
        }
        LSFeatureUsageTelemetryEvent telemetryEvent = null;
        if (featureName != null) {
            telemetryEvent = LSFeatureUsageTelemetryEvent.from(featureName, featureClass, featureTitle);
        }
        return Optional.ofNullable(telemetryEvent);
    }

    public static Optional<LSFeatureUsageTelemetryEvent> featureUsageEventFromCommandExecutor(LSCommandExecutor commandExecutor) {
        LSFeatureUsageTelemetryEvent telemetryEvent = null;
        if (!"REPORT_FEATURE_USAGE".equals(commandExecutor.getCommand())) {
            telemetryEvent = LSFeatureUsageTelemetryEvent.from(commandExecutor.getCommand(), commandExecutor.getClass().getName(), null);
        }
        return Optional.ofNullable(telemetryEvent);
    }

    public static void addReportFeatureUsageCommandToCodeAction(CodeAction codeAction, LSCodeActionProvider codeActionProvider) {
        if (codeAction.getCommand() == null) {
            CommandArgument nameArg = CommandArgument.from((String)ARG_FEATURE_NAME, (Object)codeActionProvider.getName());
            CommandArgument classArg = CommandArgument.from((String)ARG_FEATURE_CLASS, (Object)codeActionProvider.getClass().getName());
            CommandArgument titleArg = CommandArgument.from((String)ARG_FEATURE_TITLE, (Object)codeAction.getTitle());
            List<CommandArgument> args = List.of(nameArg, classArg, titleArg);
            codeAction.setCommand(new Command("Report usage statistics", "REPORT_FEATURE_USAGE", args));
        }
    }
}

