/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.toml.ballerinatoml.completion;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.BallerinaToml;
import io.ballerina.projects.Document;
import io.ballerina.projects.Module;
import io.ballerina.projects.Project;
import io.ballerina.toml.syntax.tree.NonTerminalNode;
import io.ballerina.tools.text.LinePosition;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.langserver.commons.CompletionContext;
import org.ballerinalang.langserver.commons.LSOperation;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.toml.TomlCompletionContext;
import org.ballerinalang.langserver.commons.toml.common.TomlCommonUtil;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.eclipse.lsp4j.CompletionCapabilities;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;

public class BallerinaTomlCompletionContext
implements TomlCompletionContext {
    private List<Symbol> visibleSymbols;
    private Map<ImportDeclarationNode, ModuleSymbol> currentDocImportsMap;
    private final LanguageServerContext languageServerContext;
    private final CompletionCapabilities capabilities;
    private final Position cursorPosition;
    private int cursorPosInTree = -1;
    private final LSOperation operation;
    private final Path filePath;
    private final String fileUri;
    private final WorkspaceManager workspaceManager;
    private NonTerminalNode nodeAtCursor;

    BallerinaTomlCompletionContext(CompletionContext context, LanguageServerContext serverContext) {
        this.operation = context.operation();
        this.fileUri = context.fileUri();
        this.workspaceManager = context.workspace();
        this.capabilities = context.getCapabilities();
        this.cursorPosition = context.getCursorPosition();
        this.languageServerContext = serverContext;
        Optional optFilePath = TomlCommonUtil.getPathFromURI((String)this.fileUri);
        if (optFilePath.isEmpty()) {
            throw new RuntimeException("Invalid file uri: " + this.fileUri);
        }
        this.filePath = (Path)optFilePath.get();
    }

    public List<Symbol> visibleSymbols(Position position) {
        if (this.visibleSymbols == null) {
            Optional semanticModel = this.workspace().semanticModel(this.filePath());
            Optional srcFile = this.workspace().document(this.filePath());
            if (semanticModel.isEmpty() || srcFile.isEmpty()) {
                return Collections.emptyList();
            }
            this.visibleSymbols = ((SemanticModel)semanticModel.get()).visibleSymbols((Document)srcFile.get(), LinePosition.from((int)position.getLine(), (int)position.getCharacter()));
        }
        return this.visibleSymbols;
    }

    public List<ImportDeclarationNode> currentDocImports() {
        Optional document = this.workspace().document(this.filePath());
        if (document.isEmpty()) {
            throw new RuntimeException("Cannot find a valid document");
        }
        return ((ModulePartNode)((Document)document.get()).syntaxTree().rootNode()).imports().stream().toList();
    }

    public Map<ImportDeclarationNode, ModuleSymbol> currentDocImportsMap() {
        Optional semanticModel = this.workspace().semanticModel(this.filePath());
        if (semanticModel.isEmpty()) {
            throw new RuntimeException("Semantic Model Cannot be Empty");
        }
        if (this.currentDocImportsMap == null) {
            this.currentDocImportsMap = new LinkedHashMap<ImportDeclarationNode, ModuleSymbol>();
            Optional document = this.workspace().document(this.filePath());
            if (document.isEmpty()) {
                throw new RuntimeException("Cannot find a valid document");
            }
            ModulePartNode modulePartNode = (ModulePartNode)((Document)document.get()).syntaxTree().rootNode();
            for (ImportDeclarationNode importDeclaration : modulePartNode.imports()) {
                Optional symbol = ((SemanticModel)semanticModel.get()).symbol((Node)importDeclaration);
                if (symbol.isEmpty() || ((Symbol)symbol.get()).kind() != SymbolKind.MODULE) continue;
                this.currentDocImportsMap.put(importDeclaration, (ModuleSymbol)symbol.get());
            }
        }
        return this.currentDocImportsMap;
    }

    public Optional<Document> currentDocument() {
        return this.workspace().document(this.filePath());
    }

    public Optional<Module> currentModule() {
        return this.workspace().module(this.filePath());
    }

    public Optional<SemanticModel> currentSemanticModel() {
        return this.workspace().semanticModel(this.filePath());
    }

    public Optional<SyntaxTree> currentSyntaxTree() {
        return this.workspace().syntaxTree(this.filePath());
    }

    @NonNull
    public Path filePath() {
        return this.filePath;
    }

    public String fileUri() {
        return this.fileUri;
    }

    public LSOperation operation() {
        return this.operation;
    }

    public void setCursorPositionInTree(int offset) {
        if (this.cursorPosInTree > -1) {
            throw new RuntimeException("Setting the cursor offset more than once is not allowed");
        }
        this.cursorPosInTree = offset;
    }

    public int getCursorPositionInTree() {
        return this.cursorPosInTree;
    }

    public LanguageServerContext languageServercontext() {
        return this.languageServerContext;
    }

    public CompletionCapabilities getCapabilities() {
        return this.capabilities;
    }

    public WorkspaceManager workspace() {
        return this.workspaceManager;
    }

    public Position getCursorPosition() {
        return this.cursorPosition;
    }

    public void setNodeAtCursor(NonTerminalNode nonTerminalNode) {
        if (this.nodeAtCursor != null) {
            throw new RuntimeException("Setting the node more than once is not allowed");
        }
        this.nodeAtCursor = nonTerminalNode;
    }

    public Optional<NonTerminalNode> getNodeAtCursor() {
        return Optional.of(this.nodeAtCursor);
    }

    public Optional<io.ballerina.toml.syntax.tree.SyntaxTree> getTomlSyntaxTree() {
        return Optional.of(((BallerinaToml)((Project)this.workspace().project(this.filePath()).orElseThrow()).currentPackage().ballerinaToml().orElseThrow()).tomlDocument().syntaxTree());
    }

    public LanguageServerContext getLanguageServerContext() {
        return this.languageServerContext;
    }
}

