/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.email.server;

import io.ballerina.stdlib.email.server.EmailConnectorException;
import io.ballerina.stdlib.email.server.EmailConsumer;
import io.ballerina.stdlib.email.server.EmailListener;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailConnector {
    private static final Logger log = LoggerFactory.getLogger(EmailConnector.class);
    private EmailConsumer consumer;
    private AtomicBoolean isPollOperationOccupied = new AtomicBoolean(false);

    public EmailConnector(Map<String, Object> properties, EmailListener emailListener) throws EmailConnectorException, GeneralSecurityException, IOException {
        log.debug("Email listener configurations: " + String.valueOf(properties.keySet()));
        this.consumer = new EmailConsumer(properties, emailListener);
    }

    public void poll() {
        if (this.isPollOperationOccupied.compareAndSet(false, true)) {
            try {
                this.consumer.consume();
            }
            catch (Exception e) {
                log.error("Error executing the polling cycle of RemoteFileSystemServer", (Throwable)e);
            }
            finally {
                this.isPollOperationOccupied.set(false);
            }
        } else {
            log.warn("A scheduled email polling job was skipped as the previous job was still processing.");
        }
    }

    public void close() {
        if (this.isPollOperationOccupied.compareAndSet(false, true)) {
            try {
                this.consumer.close();
            }
            catch (Exception e) {
                log.error("Error executing the closing cycle of RemoteFileSystemServer", (Throwable)e);
            }
            finally {
                this.isPollOperationOccupied.set(false);
            }
        } else {
            log.warn("A scheduled email closing job was skipped as the previous poll/close job was still processing.");
        }
    }

    protected EmailListener getEmailListener() {
        return this.consumer.getEmailListener();
    }
}

