/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.email.server;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.email.client.EmailAccessClient;
import io.ballerina.stdlib.email.server.EmailConnectorException;
import io.ballerina.stdlib.email.server.EmailEvent;
import io.ballerina.stdlib.email.server.EmailListener;
import io.ballerina.stdlib.email.util.EmailConstants;
import io.ballerina.stdlib.email.util.EmailUtils;
import io.ballerina.stdlib.email.util.ExcludeCoverageFromGeneratedReport;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailConsumer {
    private static final Logger log = LoggerFactory.getLogger(EmailConsumer.class);
    private EmailListener emailListener;
    private BObject client;

    public EmailConsumer(Map<String, Object> emailProperties, EmailListener listener) throws EmailConnectorException {
        this.emailListener = listener;
        String host = (String)emailProperties.get(EmailConstants.PROPS_HOST.getValue());
        String username = (String)emailProperties.get(EmailConstants.PROPS_USERNAME.getValue());
        String password = (String)emailProperties.get(EmailConstants.PROPS_PASSWORD.getValue());
        String protocol = (String)emailProperties.get(EmailConstants.PROPS_PROTOCOL.getValue());
        BMap protocolConfig = (BMap)emailProperties.get(EmailConstants.PROTOCOL_CONFIG.getValue());
        if (protocol.equals("IMAP")) {
            this.client = ValueCreator.createObjectValue((Module)EmailUtils.getEmailPackage(), (String)"ImapClient", (Object[])new Object[]{StringUtils.fromString((String)host), StringUtils.fromString((String)username), StringUtils.fromString((String)password), protocolConfig});
            EmailAccessClient.initImapClientEndpoint(this.client, StringUtils.fromString((String)host), StringUtils.fromString((String)username), StringUtils.fromString((String)password), (BMap<BString, Object>)protocolConfig);
        } else if (protocol.equals("POP")) {
            this.client = ValueCreator.createObjectValue((Module)EmailUtils.getEmailPackage(), (String)"PopClient", (Object[])new Object[]{StringUtils.fromString((String)host), StringUtils.fromString((String)username), StringUtils.fromString((String)password), protocolConfig});
            EmailAccessClient.initPopClientEndpoint(this.client, StringUtils.fromString((String)host), StringUtils.fromString((String)username), StringUtils.fromString((String)password), (BMap<BString, Object>)protocolConfig);
        } else {
            String errorMsg = "Protocol should either be 'IMAP' or 'POP'.";
            throw new EmailConnectorException(errorMsg);
        }
    }

    public void consume() {
        this.printConsumeDebugLogs();
        Object message = EmailAccessClient.readMessage(this.client, StringUtils.fromString((String)"INBOX"), BDecimal.valueOf((int)0));
        if (message != null) {
            if (message instanceof BMap) {
                this.emailListener.onMessage(new EmailEvent(message));
            } else if (message instanceof BError) {
                this.emailListener.onError(message);
            } else {
                this.emailListener.onError(ErrorCreator.createError((Throwable)new EmailConnectorException("Received an undefined message from email server.")));
            }
        } else {
            log.debug("No emails found in the inbox.");
        }
    }

    public void close() {
        this.printCloseDebugLogs();
        Object message = EmailAccessClient.close(this.client);
        if (message instanceof BError) {
            this.emailListener.onClose(message);
        } else {
            this.emailListener.onClose(null);
        }
    }

    protected EmailListener getEmailListener() {
        return this.emailListener;
    }

    @ExcludeCoverageFromGeneratedReport
    private void printConsumeDebugLogs() {
        if (log.isDebugEnabled()) {
            log.debug("Consumer thread name: " + Thread.currentThread().getName());
            log.debug("Consumer hashcode: " + this.hashCode());
            log.debug("Polling for an email...");
        }
    }

    @ExcludeCoverageFromGeneratedReport
    private void printCloseDebugLogs() {
        if (log.isDebugEnabled()) {
            log.debug("Close thread name: " + Thread.currentThread().getName());
            log.debug("Close hashcode: " + this.hashCode());
            log.debug("Polling for closing...");
        }
    }
}

