/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.email.server;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.email.server.EmailConnector;
import io.ballerina.stdlib.email.server.EmailConnectorException;
import io.ballerina.stdlib.email.server.EmailConnectorFactory;
import io.ballerina.stdlib.email.server.EmailListener;
import io.ballerina.stdlib.email.util.CommonUtil;
import io.ballerina.stdlib.email.util.EmailConstants;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;

public class EmailListenerHelper {
    private EmailListenerHelper() {
    }

    public static Object init(Environment env, BObject emailListener, BMap<BString, Object> serviceEndpointConfig, BMap<BString, Object> protocolConfig, BString protocol) {
        EmailListener listener = new EmailListener(env.getRuntime());
        Map<String, Object> paramMap = EmailListenerHelper.getServerConnectorParamMap(serviceEndpointConfig, protocolConfig, protocol.getValue());
        EmailConnector emailConnector = null;
        try {
            emailConnector = EmailConnectorFactory.createServerConnector(paramMap, listener);
        }
        catch (EmailConnectorException | IOException | GeneralSecurityException e) {
            return CommonUtil.getBallerinaError("Error", "Error while initializing the email listener: " + e.getMessage());
        }
        emailListener.addNativeData("serverConnector", (Object)emailConnector);
        return null;
    }

    public static void register(BObject emailListener, BObject service) {
        EmailConnector emailConnector = (EmailConnector)emailListener.getNativeData("serverConnector");
        EmailListener listener = emailConnector.getEmailListener();
        listener.addService(service);
    }

    private static Map<String, Object> getServerConnectorParamMap(BMap<BString, Object> serviceEndpointConfig, BMap<BString, Object> protocolConfig, String protocol) {
        HashMap<String, Object> params = new HashMap<String, Object>(7);
        if (protocolConfig != null) {
            params.put(EmailConstants.PROTOCOL_CONFIG.getValue(), protocolConfig);
        }
        params.put(EmailConstants.PROPS_HOST.getValue(), serviceEndpointConfig.getStringValue(EmailConstants.PROPS_HOST).getValue());
        params.put(EmailConstants.PROPS_USERNAME.getValue(), serviceEndpointConfig.getStringValue(EmailConstants.PROPS_USERNAME).getValue());
        params.put(EmailConstants.PROPS_PASSWORD.getValue(), serviceEndpointConfig.getStringValue(EmailConstants.PROPS_PASSWORD).getValue());
        params.put(EmailConstants.PROPS_PROTOCOL.getValue(), protocol);
        return params;
    }

    public static Object poll(BObject emailListener) {
        EmailConnector connector = (EmailConnector)emailListener.getNativeData("serverConnector");
        try {
            connector.poll();
        }
        catch (Exception e) {
            return CommonUtil.getBallerinaError("Error", "Error while polling in the email listener: " + e.getMessage());
        }
        return null;
    }

    public static Object close(BObject emailListener) {
        EmailConnector connector = (EmailConnector)emailListener.getNativeData("serverConnector");
        try {
            connector.close();
        }
        catch (Exception e) {
            return CommonUtil.getBallerinaError("Error", "Error while closing email listener: " + e.getMessage());
        }
        return null;
    }
}

