/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.email.util;

import com.sun.mail.util.MailSSLSocketFactory;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.email.util.ModuleUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtil {
    private static final Logger log = LoggerFactory.getLogger(CommonUtil.class);

    private CommonUtil() {
    }

    protected static boolean isTextBased(String contentType) {
        return contentType.startsWith("text/") || contentType.endsWith("+xml") || contentType.endsWith("+json") || contentType.startsWith("application/json") || contentType.startsWith("application/xml") || contentType.startsWith("application/x-www-form-urlencoded");
    }

    protected static boolean isJsonBased(String contentType) {
        return Pattern.compile(Pattern.quote(contentType), 2).matcher("json").find();
    }

    protected static boolean isXmlBased(String contentType) {
        return Pattern.compile(Pattern.quote(contentType), 2).matcher("xml").find();
    }

    public static byte[] convertInputStreamToByteArray(InputStream inputStream) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        return buffer.toByteArray();
    }

    protected static SSLSocketFactory createSSLSocketFactory(File crtFile, String protocol) throws GeneralSecurityException, IOException {
        X509Certificate result;
        SSLContext sslContext = SSLContext.getInstance(protocol);
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        trustStore.load(null, null);
        try (FileInputStream input = new FileInputStream(crtFile);){
            result = (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(input);
        }
        trustStore.setCertificateEntry(crtFile.getName(), result);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(trustStore);
        TrustManager[] trustManagers = tmf.getTrustManagers();
        sslContext.init(null, trustManagers, new SecureRandom());
        return sslContext.getSocketFactory();
    }

    protected static SSLSocketFactory createDefaultSSLSocketFactory() throws GeneralSecurityException {
        MailSSLSocketFactory mailSSLSocketFactory = new MailSSLSocketFactory();
        TrustManager[] mailTrustManagers = mailSSLSocketFactory.getTrustManagers();
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, mailTrustManagers, new SecureRandom());
        return sslContext.getSocketFactory();
    }

    public static BError getBallerinaError(String typeId, String message) {
        return ErrorCreator.createError((Module)ModuleUtils.getModule(), (String)typeId, (BString)StringUtils.fromString((String)message), null, null);
    }
}

