/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websub;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.Parameter;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.websub.ModuleUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public final class NativeHttpToWebsubAdaptor {
    private NativeHttpToWebsubAdaptor() {
    }

    public static void externInit(BObject adaptor, BObject service) {
        adaptor.addNativeData("WEBSUB_SERVICE_OBJECT", (Object)service);
    }

    public static BMap<BString, Object> retrieveSubscriberConfig(BObject httpService) {
        Object config = httpService.getNativeData("SUBSCRIBER_CONFIG");
        if (Objects.nonNull(config)) {
            return (BMap)config;
        }
        return null;
    }

    public static BArray getServiceMethodNames(BObject adaptor) {
        BObject serviceObj = (BObject)adaptor.getNativeData("WEBSUB_SERVICE_OBJECT");
        ArrayList<BString> methodNamesList = new ArrayList<BString>();
        ObjectType objectType = (ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)serviceObj));
        for (MethodType method : objectType.getMethods()) {
            methodNamesList.add(StringUtils.fromString((String)method.getName()));
        }
        return ValueCreator.createArrayValue((BString[])((BString[])methodNamesList.toArray(BString[]::new)));
    }

    public static Object callOnSubscriptionVerificationMethod(Environment env, BObject adaptor, BMap<BString, Object> message) {
        BObject serviceObj = (BObject)adaptor.getNativeData("WEBSUB_SERVICE_OBJECT");
        boolean isReadOnly = NativeHttpToWebsubAdaptor.isReadOnlyParam(serviceObj, "onSubscriptionVerification");
        if (isReadOnly) {
            message.freezeDirect();
        }
        return NativeHttpToWebsubAdaptor.invokeRemoteFunction(env, serviceObj, message, "callOnSubscriptionVerificationMethod", "onSubscriptionVerification");
    }

    public static Object callOnUnsubscriptionVerificationMethod(Environment env, BObject adaptor, BMap<BString, Object> message) {
        BObject serviceObj = (BObject)adaptor.getNativeData("WEBSUB_SERVICE_OBJECT");
        boolean isReadOnly = NativeHttpToWebsubAdaptor.isReadOnlyParam(serviceObj, "onUnsubscriptionVerification");
        if (isReadOnly) {
            message.freezeDirect();
        }
        return NativeHttpToWebsubAdaptor.invokeRemoteFunction(env, serviceObj, message, "callOnUnsubscriptionVerificationMethod", "onUnsubscriptionVerification");
    }

    public static Object callOnSubscriptionDeniedMethod(Environment env, BObject adaptor, BError message) {
        BObject serviceObj = (BObject)adaptor.getNativeData("WEBSUB_SERVICE_OBJECT");
        return NativeHttpToWebsubAdaptor.invokeRemoteFunction(env, serviceObj, (Object)message, "callOnSubscriptionDeniedMethod", "onSubscriptionValidationDenied");
    }

    public static Object callOnEventNotificationMethod(Environment env, BObject adaptor, BMap<BString, Object> message, BObject bHttpRequest) {
        message.addNativeData("HTTP_REQUEST", (Object)bHttpRequest);
        BObject serviceObj = (BObject)adaptor.getNativeData("WEBSUB_SERVICE_OBJECT");
        boolean isReadOnly = NativeHttpToWebsubAdaptor.isReadOnlyParam(serviceObj, "onEventNotification");
        if (isReadOnly) {
            message.freezeDirect();
        }
        return NativeHttpToWebsubAdaptor.invokeRemoteFunction(env, serviceObj, message, "callOnEventNotificationMethod", "onEventNotification");
    }

    private static boolean isReadOnlyParam(BObject serviceObj, String remoteMethod) {
        ObjectType objectType = (ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)serviceObj));
        for (MethodType method : objectType.getMethods()) {
            Parameter[] parameters;
            if (!method.getName().equals(remoteMethod) || (parameters = method.getParameters()).length < 1) continue;
            Parameter parameter = parameters[0];
            Type paramType = parameter.type;
            if (!(paramType instanceof IntersectionType)) continue;
            List constituentTypes = ((IntersectionType)paramType).getConstituentTypes();
            return constituentTypes.stream().anyMatch(t -> 51 == t.getTag());
        }
        return false;
    }

    public static BObject retrieveHttpRequest(BMap<BString, Object> message) {
        return (BObject)message.getNativeData("HTTP_REQUEST");
    }

    private static Object invokeRemoteFunction(Environment env, BObject bSubscriberService, Object message, String parentFunctionName, String remoteFunctionName) {
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
            Module module = ModuleUtils.getModule();
            Object[] args = new Object[]{message};
            ObjectType serviceType = (ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)bSubscriberService));
            try {
                Object result = env.getRuntime().callMethod(bSubscriberService, remoteFunctionName, null, args);
                ModuleUtils.notifySuccess(balFuture, result);
                return ModuleUtils.getResult(balFuture);
            }
            catch (BError bError) {
                return ModuleUtils.notifyFailure(bError, module);
            }
        });
    }
}

