/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websubhub.task.validator;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.symbols.ErrorTypeSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeLocation;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.websubhub.WebSubHubDiagnosticCodes;
import io.ballerina.stdlib.websubhub.task.AnalyserUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class ServiceDeclarationValidator {
    private static final ServiceDeclarationValidator INSTANCE = new ServiceDeclarationValidator();
    private static final List<String> allowedMethods = List.of("onRegisterTopic", "onDeregisterTopic", "onUpdateMessage", "onSubscription", "onSubscriptionValidation", "onSubscriptionIntentVerified", "onUnsubscription", "onUnsubscriptionValidation", "onUnsubscriptionIntentVerified");
    private static final List<String> requiredMethods = List.of("onRegisterTopic", "onDeregisterTopic", "onUpdateMessage", "onSubscriptionIntentVerified", "onUnsubscriptionIntentVerified");
    private static final Map<String, List<String>> allowedParameterTypes = Map.of("onRegisterTopic", List.of("websubhub:TopicRegistration", "http:Headers"), "onDeregisterTopic", List.of("websubhub:TopicDeregistration", "http:Headers"), "onUpdateMessage", List.of("websubhub:UpdateMessage", "http:Headers"), "onSubscription", List.of("websubhub:Subscription", "http:Headers", "websubhub:Controller"), "onSubscriptionValidation", Collections.singletonList("websubhub:Subscription"), "onSubscriptionIntentVerified", Collections.singletonList("websubhub:VerifiedSubscription"), "onUnsubscription", List.of("websubhub:Unsubscription", "http:Headers", "websubhub:Controller"), "onUnsubscriptionValidation", Collections.singletonList("websubhub:Unsubscription"), "onUnsubscriptionIntentVerified", Collections.singletonList("websubhub:VerifiedUnsubscription"));
    private static final Map<String, List<String>> allowedReturnTypes = Map.of("onRegisterTopic", List.of("websubhub:TopicRegistrationSuccess", "websubhub:TopicRegistrationError"), "onDeregisterTopic", List.of("websubhub:TopicDeregistrationSuccess", "websubhub:TopicDeregistrationError"), "onUpdateMessage", List.of("websubhub:Acknowledgement", "websubhub:UpdateMessageError"), "onSubscription", List.of("websubhub:SubscriptionAccepted", "websubhub:SubscriptionPermanentRedirect", "websubhub:SubscriptionTemporaryRedirect", "websubhub:BadSubscriptionError", "websubhub:InternalSubscriptionError"), "onSubscriptionValidation", Collections.singletonList("websubhub:SubscriptionDeniedError"), "onSubscriptionIntentVerified", Collections.emptyList(), "onUnsubscription", List.of("websubhub:UnsubscriptionAccepted", "websubhub:BadUnsubscriptionError", "websubhub:InternalUnsubscriptionError"), "onUnsubscriptionValidation", Collections.singletonList("websubhub:UnsubscriptionDeniedError"), "onUnsubscriptionIntentVerified", Collections.emptyList());
    private static final List<String> methodsWithOptionalReturnTypes = List.of("onSubscriptionValidation", "onSubscriptionIntentVerified", "onUnsubscriptionValidation", "onUnsubscriptionIntentVerified");

    private ServiceDeclarationValidator() {
    }

    public static ServiceDeclarationValidator getInstance() {
        return INSTANCE;
    }

    public void validate(SyntaxNodeAnalysisContext context, ServiceDeclarationNode serviceNode) {
        List<FunctionDefinitionNode> availableFunctionDeclarations = serviceNode.members().stream().filter(member -> member.kind() == SyntaxKind.OBJECT_METHOD_DEFINITION).map(member -> (FunctionDefinitionNode)member).collect(Collectors.toList());
        this.executeRequiredMethodValidation(context, availableFunctionDeclarations, serviceNode.location());
        availableFunctionDeclarations.forEach(fd -> context.semanticModel().symbol((Node)fd).ifPresent(fs -> {
            NodeLocation location = fd.location();
            this.executeRemoteMethodValidation(context, (FunctionSymbol)fs, location);
            this.executeMethodParameterValidation(context, (FunctionDefinitionNode)fd, ((FunctionSymbol)fs).typeDescriptor());
            this.executeMethodReturnTypeValidation(context, (FunctionDefinitionNode)fd, ((FunctionSymbol)fs).typeDescriptor());
        }));
    }

    private void executeRemoteMethodValidation(SyntaxNodeAnalysisContext context, FunctionSymbol functionSymbol, NodeLocation location) {
        Optional functionNameOpt = functionSymbol.getName();
        if (functionNameOpt.isPresent()) {
            WebSubHubDiagnosticCodes errorCode;
            String functionName = (String)functionNameOpt.get();
            boolean isRemoteMethod = AnalyserUtils.isRemoteMethod(functionSymbol);
            boolean isAllowedMethod = allowedMethods.contains(functionName);
            if (isRemoteMethod && !isAllowedMethod) {
                errorCode = WebSubHubDiagnosticCodes.WEBSUBHUB_104;
                AnalyserUtils.updateContext(context, errorCode, location, functionName);
            }
            if (!isRemoteMethod && isAllowedMethod) {
                errorCode = WebSubHubDiagnosticCodes.WEBSUBHUB_102;
                AnalyserUtils.updateContext(context, errorCode, location, functionName);
            }
        }
    }

    private void executeRequiredMethodValidation(SyntaxNodeAnalysisContext context, List<FunctionDefinitionNode> availableFunctionDeclarations, NodeLocation location) {
        List availableMethods = availableFunctionDeclarations.stream().map(fd -> fd.functionName().toString()).collect(Collectors.toList());
        boolean requiredMethodsImplemented = availableMethods.containsAll(requiredMethods);
        if (!requiredMethodsImplemented) {
            List unavailableRequiredMethods = requiredMethods.stream().filter(e -> !availableMethods.contains(e)).collect(Collectors.toList());
            WebSubHubDiagnosticCodes errorCode = WebSubHubDiagnosticCodes.WEBSUBHUB_103;
            String requiredMethodsMsg = String.join((CharSequence)",", unavailableRequiredMethods);
            AnalyserUtils.updateContext(context, errorCode, location, requiredMethodsMsg);
        }
    }

    private void executeMethodParameterValidation(SyntaxNodeAnalysisContext context, FunctionDefinitionNode functionDefinition, FunctionTypeSymbol typeSymbol) {
        String functionName = functionDefinition.functionName().toString();
        if (allowedMethods.contains(functionName)) {
            List<String> allowedParameters = allowedParameterTypes.get(functionName);
            Optional paramOpt = typeSymbol.params();
            if (paramOpt.isPresent()) {
                List params = (List)paramOpt.get();
                if (params.isEmpty()) {
                    if (!allowedParameters.isEmpty()) {
                        WebSubHubDiagnosticCodes errorCode = WebSubHubDiagnosticCodes.WEBSUBHUB_106;
                        AnalyserUtils.updateContext(context, errorCode, functionDefinition.location(), functionName, String.join((CharSequence)",", allowedParameters));
                    }
                } else {
                    List<String> availableParamNames = params.stream().map(e -> AnalyserUtils.getTypeDescription(e.typeDescriptor())).toList();
                    if (allowedParameters.containsAll(availableParamNames)) {
                        return;
                    }
                    List notAllowedParams = availableParamNames.stream().filter(e -> !allowedParameters.contains(e)).collect(Collectors.toList());
                    String message = String.join((CharSequence)",", notAllowedParams);
                    WebSubHubDiagnosticCodes errorCode = WebSubHubDiagnosticCodes.WEBSUBHUB_105;
                    AnalyserUtils.updateContext(context, errorCode, functionDefinition.location(), message, functionName);
                }
            } else if (!allowedParameters.isEmpty()) {
                WebSubHubDiagnosticCodes errorCode = WebSubHubDiagnosticCodes.WEBSUBHUB_106;
                AnalyserUtils.updateContext(context, errorCode, functionDefinition.location(), functionName, String.join((CharSequence)",", allowedParameters));
            }
        }
    }

    private void executeMethodReturnTypeValidation(SyntaxNodeAnalysisContext context, FunctionDefinitionNode functionDefinition, FunctionTypeSymbol typeSymbol) {
        String functionName = functionDefinition.functionName().toString();
        List<String> predefinedReturnTypes = allowedReturnTypes.get(functionName);
        boolean nilableReturnTypeAllowed = methodsWithOptionalReturnTypes.contains(functionName);
        if (allowedMethods.contains(functionName)) {
            Optional returnTypesOpt = typeSymbol.returnTypeDescriptor();
            if (returnTypesOpt.isPresent()) {
                TypeSymbol returnTypeDescription = (TypeSymbol)returnTypesOpt.get();
                if (returnTypeDescription.typeKind().equals((Object)TypeDescKind.NIL) && !nilableReturnTypeAllowed) {
                    WebSubHubDiagnosticCodes errorCode = WebSubHubDiagnosticCodes.WEBSUBHUB_108;
                    AnalyserUtils.updateContext(context, errorCode, functionDefinition.location(), functionName, String.join((CharSequence)"|", predefinedReturnTypes));
                    return;
                }
                boolean invalidReturnTypePresent = this.isReturnTypeNotAllowed(predefinedReturnTypes, returnTypeDescription, nilableReturnTypeAllowed);
                if (invalidReturnTypePresent) {
                    String returnTypeName = AnalyserUtils.getTypeDescription(returnTypeDescription);
                    WebSubHubDiagnosticCodes errorCode = WebSubHubDiagnosticCodes.WEBSUBHUB_107;
                    AnalyserUtils.updateContext(context, errorCode, functionDefinition.location(), returnTypeName, functionName);
                }
            } else if (!nilableReturnTypeAllowed) {
                WebSubHubDiagnosticCodes errorCode = WebSubHubDiagnosticCodes.WEBSUBHUB_108;
                AnalyserUtils.updateContext(context, errorCode, functionDefinition.location(), functionName, String.join((CharSequence)"|", predefinedReturnTypes));
            }
        }
    }

    private boolean isReturnTypeNotAllowed(List<String> allowedReturnTypes, TypeSymbol returnTypeDescriptor, boolean nilableReturnTypeAllowed) {
        TypeDescKind typeKind = returnTypeDescriptor.typeKind();
        if (TypeDescKind.UNION.equals((Object)typeKind)) {
            return ((UnionTypeSymbol)returnTypeDescriptor).memberTypeDescriptors().stream().map(e -> this.isReturnTypeNotAllowed(allowedReturnTypes, (TypeSymbol)e, nilableReturnTypeAllowed)).reduce(false, (a, b) -> a != false || b != false);
        }
        if (TypeDescKind.TYPE_REFERENCE.equals((Object)typeKind)) {
            TypeSymbol internalType = ((TypeReferenceTypeSymbol)returnTypeDescriptor).typeDescriptor();
            if (internalType instanceof ErrorTypeSymbol) {
                return this.isInvalidErrorReturn(allowedReturnTypes, returnTypeDescriptor);
            }
            String moduleName = returnTypeDescriptor.getModule().flatMap(Symbol::getName).orElse("");
            String paramType = returnTypeDescriptor.getName().orElse("");
            String qualifiedParamType = AnalyserUtils.getQualifiedType(paramType, moduleName);
            return !allowedReturnTypes.contains(qualifiedParamType);
        }
        if (TypeDescKind.ERROR.equals((Object)typeKind)) {
            return this.isInvalidErrorReturn(allowedReturnTypes, returnTypeDescriptor);
        }
        if (TypeDescKind.NIL.equals((Object)typeKind)) {
            return !nilableReturnTypeAllowed;
        }
        return true;
    }

    private boolean isInvalidErrorReturn(List<String> allowedReturnTypes, TypeSymbol internalType) {
        String moduleName;
        Optional<ModuleID> moduleIdOpt;
        String moduleId;
        String signature = internalType.signature();
        String paramType = signature.replace(moduleId = (moduleIdOpt = internalType.getModule().map(ModuleSymbol::id)).map(ModuleID::toString).orElse(""), "").replace(":", "");
        String qualifiedParamType = AnalyserUtils.getQualifiedType(paramType, moduleName = moduleIdOpt.map(ModuleID::modulePrefix).orElse(""));
        if ("annotations:error".equals(qualifiedParamType)) {
            return false;
        }
        return !allowedReturnTypes.contains(qualifiedParamType);
    }
}

