/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.csvdata.utils;

import io.ballerina.lib.data.csvdata.utils.DiagnosticLog;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.stdlib.constraint.Constraints;

public final class DataUtils {
    private DataUtils() {
    }

    public static Object validateConstraints(Object convertedValue, BTypedesc typed, boolean requireValidation) {
        if (!requireValidation) {
            return convertedValue;
        }
        Object result = Constraints.validate((Object)convertedValue, (BTypedesc)typed);
        if (result instanceof BError) {
            BError bError = (BError)((Object)result);
            return DiagnosticLog.getCsvError(DataUtils.getPrintableErrorMsg(bError));
        }
        return convertedValue;
    }

    private static String getPrintableErrorMsg(BError err) {
        StringBuilder errorBuilder = new StringBuilder(err.getMessage() != null ? err.getMessage() : "");
        Object details = err.getDetails();
        if (details != null && !details.toString().equals("{}")) {
            errorBuilder.append((String)(!errorBuilder.isEmpty() ? ", " : String.valueOf(details)));
        }
        return errorBuilder.toString();
    }
}

