/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.cli.TaskExecutor;
import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.cli.task.CleanTargetDirTask;
import io.ballerina.cli.task.CreateDependencyGraphTask;
import io.ballerina.cli.task.ResolveMavenDependenciesTask;
import io.ballerina.cli.task.RunBuildToolsTask;
import io.ballerina.cli.utils.FileUtils;
import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.directory.BuildProject;
import io.ballerina.projects.directory.SingleFileProject;
import java.io.PrintStream;
import java.nio.file.Path;
import org.wso2.ballerinalang.util.RepoUtils;
import picocli.CommandLine;

@CommandLine.Command(name="graph", description={"Print the dependency graph in the console"})
public class GraphCommand
implements BLauncherCmd {
    private Project project;
    private final PrintStream outStream;
    private final PrintStream errStream;
    private final boolean exitWhenFinish;
    @CommandLine.Parameters(arity="0..1")
    private final Path projectPath;
    @CommandLine.Option(names={"--dump-raw-graphs"}, description={"Print all intermediate graphs created in the dependency resolution process."}, defaultValue="false")
    private boolean dumpRawGraphs;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true, defaultValue="false")
    private boolean helpFlag;
    @CommandLine.Option(names={"--offline"}, description={"Print the dependency graph offline without downloading dependencies."})
    private boolean offline;
    @CommandLine.Option(names={"--sticky"}, description={"stick to exact versions locked (if exists)"}, defaultValue="false")
    private boolean sticky;

    public GraphCommand() {
        this.projectPath = Path.of(System.getProperty("user.dir"), new String[0]);
        this.outStream = System.out;
        this.errStream = System.err;
        this.exitWhenFinish = true;
    }

    GraphCommand(Path projectPath, PrintStream outStream, PrintStream errStream, boolean exitWhenFinish) {
        this.projectPath = projectPath;
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        this.offline = true;
    }

    @Override
    public void execute() {
        if (this.helpFlag) {
            this.printHelpCommandInfo();
            return;
        }
        try {
            this.loadProject();
        }
        catch (ProjectException e) {
            this.printErrorAndExit(e.getMessage());
            return;
        }
        this.validateSettingsToml();
        TaskExecutor taskExecutor = new TaskExecutor.TaskBuilder().addTask(new CleanTargetDirTask(true, false), this.isSingleFileProject()).addTask(new RunBuildToolsTask(this.outStream), this.isSingleFileProject()).addTask(new ResolveMavenDependenciesTask(this.outStream)).addTask(new CreateDependencyGraphTask(this.outStream, this.errStream)).build();
        taskExecutor.executeTasks(this.project);
        this.exitIfRequired();
    }

    private void printHelpCommandInfo() {
        String commandUsageInfo = BLauncherCmd.getCommandUsageInfo("graph");
        this.outStream.println(commandUsageInfo);
    }

    private void loadProject() {
        BuildOptions buildOptions = this.constructBuildOptions();
        this.project = this.isSingleFileProject() ? SingleFileProject.load((Path)this.projectPath, (BuildOptions)buildOptions) : BuildProject.load((Path)this.projectPath, (BuildOptions)buildOptions);
    }

    private void printErrorAndExit(String errorMessage) {
        CommandUtil.printError(this.errStream, errorMessage, null, false);
        CommandUtil.exitError(this.exitWhenFinish);
    }

    private void validateSettingsToml() {
        RepoUtils.readSettings();
    }

    private void exitIfRequired() {
        if (this.exitWhenFinish) {
            Runtime.getRuntime().exit(0);
        }
    }

    private BuildOptions constructBuildOptions() {
        boolean dumpGraph = !this.dumpRawGraphs;
        BuildOptions.BuildOptionsBuilder buildOptionsBuilder = BuildOptions.builder();
        buildOptionsBuilder.setDumpGraph(Boolean.valueOf(dumpGraph)).setDumpRawGraphs(Boolean.valueOf(this.dumpRawGraphs)).setOffline(Boolean.valueOf(this.offline)).setSticky(Boolean.valueOf(this.sticky));
        return buildOptionsBuilder.build();
    }

    private boolean isSingleFileProject() {
        return FileUtils.hasExtension(this.projectPath);
    }

    @Override
    public String getName() {
        return "graph";
    }

    @Override
    public void printLongDesc(StringBuilder out) {
        out.append(BLauncherCmd.getCommandUsageInfo("graph"));
    }

    @Override
    public void printUsage(StringBuilder out) {
        out.append("  bal graph [--dump-raw-graph] [--offline] [--sticky] \\n\" +\n            \"                    [<ballerina-file | package-path>]");
    }

    @Override
    public void setParentCmdParser(CommandLine parentCmdParser) {
    }
}

