/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.cli.TaskExecutor;
import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.cli.task.CleanTargetDirTask;
import io.ballerina.cli.task.CompileTask;
import io.ballerina.cli.task.CreateExecutableTask;
import io.ballerina.cli.task.DumpBuildTimeTask;
import io.ballerina.cli.task.ResolveMavenDependenciesTask;
import io.ballerina.cli.task.RunBuildToolsTask;
import io.ballerina.cli.task.RunProfilerTask;
import io.ballerina.cli.utils.FileUtils;
import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.directory.BuildProject;
import io.ballerina.projects.directory.SingleFileProject;
import io.ballerina.projects.util.ProjectUtils;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="profile", description={"Compile and profile the current package"})
public class ProfileCommand
implements BLauncherCmd {
    private static final String ENV_OPTION_BAL_PROFILE_DEBUG = "BAL_PROFILE_JAVA_DEBUG";
    private final PrintStream outStream;
    private final PrintStream errStream;
    private Path projectPath;
    private boolean exitWhenFinish;
    @CommandLine.Parameters(description={"Program arguments"})
    private final List<String> argList = new ArrayList<String>();
    @CommandLine.Option(names={"--help", "-h", "?"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--offline"}, description={"Builds offline without downloading dependencies and then run."})
    private Boolean offline;
    @CommandLine.Option(names={"--debug"}, hidden=true)
    private String debugPort;
    @CommandLine.Option(names={"--generate-config-schema"}, hidden=true)
    private Boolean configSchemaGen;
    @CommandLine.Option(names={"--target-dir"}, description={"target directory path"})
    private Path targetDir;
    @CommandLine.Option(names={"--enable-cache"}, description={"enable caches for the compilation"}, hidden=true)
    private Boolean enableCache;
    @CommandLine.Option(names={"--disable-syntax-tree-caching"}, hidden=true, description={"disable syntax tree caching for source files"}, defaultValue="false")
    private Boolean disableSyntaxTreeCaching;
    @CommandLine.Option(names={"--show-dependency-diagnostics"}, description={"Show the diagnostics generated by the dependencies"})
    private Boolean showDependencyDiagnostics;
    @CommandLine.Option(names={"--optimize-dependency-compilation"}, hidden=true, description={"experimental memory optimization for large projects"})
    private Boolean optimizeDependencyCompilation;
    private static final String PROFILE_CMD = "bal profile [--debug <port>] [<ballerina-file | package-path>]\n ";

    public ProfileCommand() {
        this.projectPath = Path.of(System.getProperty("user.dir"), new String[0]);
        this.outStream = System.err;
        this.errStream = System.err;
    }

    ProfileCommand(Path projectPath, PrintStream outStream, boolean exitWhenFinish) {
        this.projectPath = projectPath;
        this.exitWhenFinish = exitWhenFinish;
        this.outStream = outStream;
        this.errStream = outStream;
        this.offline = true;
    }

    @Override
    public void execute() {
        if (this.helpFlag) {
            this.printCommandUsageInfo();
            return;
        }
        this.setupDebugPort();
        this.setupProfileDebugPort();
        String[] args = this.getArgumentsFromArgList();
        BuildOptions buildOptions = this.constructBuildOptions();
        Project project = this.loadProject(buildOptions);
        if (project == null) {
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        boolean isPackageModified = ProjectUtils.isProjectUpdated((Project)project);
        TaskExecutor taskExecutor = this.createTaskExecutor(isPackageModified, args, buildOptions, project.kind() == ProjectKind.SINGLE_FILE_PROJECT);
        taskExecutor.executeTasks(project);
    }

    private void setupProfileDebugPort() {
        if (this.debugPort != null) {
            System.setProperty("profilerDebug", this.debugPort);
        }
    }

    private void printCommandUsageInfo() {
        String commandUsageInfo = BLauncherCmd.getCommandUsageInfo("profile");
        this.errStream.println(commandUsageInfo);
    }

    private void setupDebugPort() {
        String port = System.getenv(ENV_OPTION_BAL_PROFILE_DEBUG);
        if (port != null) {
            System.setProperty("debug", port);
        }
    }

    private String[] getArgumentsFromArgList() {
        String[] args = new String[]{};
        if (!this.argList.isEmpty()) {
            if (!this.argList.get(0).equals("--")) {
                this.projectPath = Path.of(this.argList.get(0), new String[0]);
                if (this.argList.size() > 2 && this.argList.get(1).equals("--")) {
                    args = this.argList.subList(2, this.argList.size()).toArray(new String[0]);
                }
            } else if (this.argList.size() > 1 && this.argList.get(0).equals("--")) {
                args = this.argList.subList(1, this.argList.size()).toArray(new String[0]);
            }
        }
        return args;
    }

    private Project loadProject(BuildOptions buildOptions) {
        if (FileUtils.hasExtension(this.projectPath)) {
            return this.loadSingleFileProject(buildOptions);
        }
        return this.loadBuildProject(buildOptions);
    }

    private Project loadSingleFileProject(BuildOptions buildOptions) {
        try {
            return SingleFileProject.load((Path)this.projectPath, (BuildOptions)buildOptions);
        }
        catch (ProjectException e) {
            CommandUtil.printError(this.errStream, e.getMessage(), PROFILE_CMD, false);
            return null;
        }
    }

    private Project loadBuildProject(BuildOptions buildOptions) {
        try {
            return BuildProject.load((Path)this.projectPath, (BuildOptions)buildOptions);
        }
        catch (ProjectException e) {
            CommandUtil.printError(this.errStream, e.getMessage(), PROFILE_CMD, false);
            return null;
        }
    }

    private TaskExecutor createTaskExecutor(boolean isPackageModified, String[] args, BuildOptions buildOptions, boolean isSingleFileBuild) {
        return new TaskExecutor.TaskBuilder().addTask(new CleanTargetDirTask(isPackageModified, buildOptions.enableCache()), isSingleFileBuild).addTask(new RunBuildToolsTask(this.outStream), isSingleFileBuild).addTask(new ResolveMavenDependenciesTask(this.outStream)).addTask(new CompileTask(this.outStream, this.errStream, false, false, isPackageModified, buildOptions.enableCache())).addTask(new CreateExecutableTask(this.outStream, null, null, false), false).addTask(new DumpBuildTimeTask(this.outStream), false).addTask(new RunProfilerTask(this.errStream), false).build();
    }

    @Override
    public String getName() {
        return "profile";
    }

    @Override
    public void printLongDesc(StringBuilder out) {
        out.append(BLauncherCmd.getCommandUsageInfo("profile"));
    }

    @Override
    public void printUsage(StringBuilder out) {
        out.append("  bal profile [--debug <port>] [<balfile> | <project-path>]\n");
    }

    @Override
    public void setParentCmdParser(CommandLine parentCmdParser) {
    }

    private BuildOptions constructBuildOptions() {
        BuildOptions.BuildOptionsBuilder buildOptionsBuilder = BuildOptions.builder();
        buildOptionsBuilder.setCodeCoverage(Boolean.valueOf(false)).setOffline(this.offline).setSkipTests(Boolean.valueOf(true)).setTestReport(Boolean.valueOf(false)).setConfigSchemaGen(this.configSchemaGen).disableSyntaxTreeCaching(this.disableSyntaxTreeCaching).setShowDependencyDiagnostics(this.showDependencyDiagnostics).setOptimizeDependencyCompilation(this.optimizeDependencyCompilation);
        if (this.targetDir != null) {
            buildOptionsBuilder.targetDir(this.targetDir.toString());
        }
        return buildOptionsBuilder.build();
    }
}

