/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ballerina.cli.BLauncherCmd;
import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.cli.utils.PrintUtils;
import io.ballerina.projects.BalToolsManifest;
import io.ballerina.projects.BalToolsToml;
import io.ballerina.projects.JvmTarget;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.SemanticVersion;
import io.ballerina.projects.Settings;
import io.ballerina.projects.internal.BalToolsManifestBuilder;
import io.ballerina.projects.internal.BalaFiles;
import io.ballerina.projects.internal.model.PackageJson;
import io.ballerina.projects.internal.model.Proxy;
import io.ballerina.projects.util.ProjectUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ballerinalang.central.client.CentralAPIClient;
import org.ballerinalang.central.client.exceptions.CentralClientException;
import org.ballerinalang.central.client.exceptions.PackageAlreadyExistsException;
import org.ballerinalang.central.client.model.ToolSearchResult;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.util.RepoUtils;
import picocli.CommandLine;

@CommandLine.Command(name="tool", description={"Manage ballerina tool commands"})
public class ToolCommand
implements BLauncherCmd {
    private static final String TOOL_PULL_COMMAND = "pull";
    private static final String TOOL_LIST_COMMAND = "list";
    private static final String TOOL_SEARCH_COMMAND = "search";
    private static final String TOOL_REMOVE_COMMAND = "remove";
    private static final String TOOL_USE_COMMAND = "use";
    private static final String TOOL_UPDATE_COMMAND = "update";
    private static final String HYPHEN = "-";
    private static final String TOOL_USAGE_TEXT = "bal tool <sub-command> [args]";
    private static final String TOOL_PULL_USAGE_TEXT = "bal tool pull <tool-id>[:<version>]";
    private static final String TOOL_USE_USAGE_TEXT = "bal tool use <tool-id>:<version>";
    private static final String TOOL_LIST_USAGE_TEXT = "bal tool list";
    private static final String TOOL_REMOVE_USAGE_TEXT = "bal tool remove <tool-id>:[<version>]";
    private static final String TOOL_SEARCH_USAGE_TEXT = "bal tool search [<tool-id>|<text>]";
    private static final String TOOL_UPDATE_USAGE_TEXT = "bal tool update <tool-id>";
    private static final String EMPTY_STRING = Names.EMPTY.getValue();
    private final boolean exitWhenFinish;
    private final PrintStream outStream;
    private final PrintStream errStream;
    Path balToolsTomlPath = RepoUtils.createAndGetHomeReposPath().resolve(Path.of(".config", "bal-tools.toml"));
    @CommandLine.Parameters(description={"Manage ballerina tools"})
    private List<String> argList;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--repository"})
    private String repositoryName;
    private String toolId;
    private String org;
    private String name;
    private String version;

    public ToolCommand() {
        this.outStream = System.out;
        this.errStream = System.err;
        this.exitWhenFinish = true;
    }

    public ToolCommand(PrintStream outStream, PrintStream errStream, boolean exitWhenFinish) {
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
    }

    @Override
    public String getName() {
        return "tool";
    }

    @Override
    public void printLongDesc(StringBuilder out) {
        out.append(BLauncherCmd.getCommandUsageInfo("tool"));
    }

    @Override
    public void printUsage(StringBuilder out) {
        out.append(TOOL_USAGE_TEXT);
    }

    @Override
    public void setParentCmdParser(CommandLine parentCmdParser) {
    }

    @Override
    public void execute() {
        String command;
        if (this.helpFlag) {
            this.handleHelpFlag();
            return;
        }
        if (this.argList == null || this.argList.isEmpty()) {
            CommandUtil.printError(this.errStream, "no sub-command given.", TOOL_USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (this.repositoryName != null && !this.repositoryName.equals("local")) {
            String errMsg = "unsupported repository '" + this.repositoryName + "' found. Only 'local' repository is supported.";
            CommandUtil.printError(this.errStream, errMsg, null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        switch (command = this.argList.get(0)) {
            case "pull": {
                this.handlePullCommand();
                break;
            }
            case "use": {
                this.handleUseCommand();
                break;
            }
            case "list": {
                this.handleListCommand();
                break;
            }
            case "search": {
                this.handleSearchCommand();
                break;
            }
            case "remove": {
                this.handleRemoveCommand();
                break;
            }
            case "update": {
                this.handleUpdateCommand();
                break;
            }
            default: {
                CommandUtil.printError(this.errStream, "invalid sub-command given.", TOOL_USAGE_TEXT, false);
                CommandUtil.exitError(this.exitWhenFinish);
            }
        }
    }

    private void handleHelpFlag() {
        String command;
        String commandUsageInfo = switch (command = this.argList == null || this.argList.isEmpty() ? "tool" : this.argList.get(0)) {
            case TOOL_PULL_COMMAND -> BLauncherCmd.getCommandUsageInfo("tool-pull");
            case TOOL_USE_COMMAND -> BLauncherCmd.getCommandUsageInfo("tool-use");
            case TOOL_LIST_COMMAND -> BLauncherCmd.getCommandUsageInfo("tool-list");
            case TOOL_REMOVE_COMMAND -> BLauncherCmd.getCommandUsageInfo("tool-remove");
            case TOOL_SEARCH_COMMAND -> BLauncherCmd.getCommandUsageInfo("tool-search");
            case TOOL_UPDATE_COMMAND -> BLauncherCmd.getCommandUsageInfo("tool-update");
            default -> BLauncherCmd.getCommandUsageInfo("tool");
        };
        this.outStream.println(commandUsageInfo);
    }

    private void handlePullCommand() {
        if (this.argList.size() < 2) {
            CommandUtil.printError(this.errStream, "tool id is not provided.", TOOL_PULL_USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (this.argList.size() > 2) {
            CommandUtil.printError(this.errStream, "too many arguments.", TOOL_PULL_USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        String toolIdAndVersion = this.argList.get(1);
        String[] toolInfo = toolIdAndVersion.split(":");
        if (toolInfo.length == 2) {
            this.toolId = toolInfo[0];
            this.version = toolInfo[1];
        } else if (toolInfo.length == 1) {
            this.toolId = toolIdAndVersion;
            this.version = Names.EMPTY.getValue();
        } else {
            CommandUtil.printError(this.errStream, "invalid tool id.", TOOL_PULL_USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if ("local".equals(this.repositoryName) && EMPTY_STRING.equals(this.version)) {
            CommandUtil.printError(this.errStream, "tool version should be provided when pulling a tool from local repository", null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (!ProjectUtils.validateToolName((String)this.toolId)) {
            CommandUtil.printError(this.errStream, "invalid tool id.", TOOL_PULL_USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (!Names.EMPTY.getValue().equals(this.version)) {
            try {
                SemanticVersion.from((String)this.version);
            }
            catch (ProjectException e) {
                CommandUtil.printError(this.errStream, "invalid tool version. " + e.getMessage(), TOOL_PULL_USAGE_TEXT, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
        }
        this.pullToolAndUpdateBalToolsToml(this.toolId, this.version);
    }

    private void handleUseCommand() {
        if (this.argList.size() < 2) {
            CommandUtil.printError(this.errStream, "tool id is not provided.", TOOL_USE_USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (this.argList.size() > 2) {
            CommandUtil.printError(this.errStream, "too many arguments.", TOOL_USE_USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        String toolIdAndVersion = this.argList.get(1);
        String[] toolInfo = toolIdAndVersion.split(":");
        if (toolInfo.length != 2) {
            CommandUtil.printError(this.errStream, "invalid tool id.", TOOL_USE_USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        this.toolId = toolInfo[0];
        this.version = toolInfo[1];
        if (!ProjectUtils.validateToolName((String)this.toolId)) {
            CommandUtil.printError(this.errStream, "invalid tool id.", TOOL_USE_USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        try {
            SemanticVersion.from((String)this.version);
        }
        catch (ProjectException e) {
            CommandUtil.printError(this.errStream, "invalid tool version. " + e.getMessage(), TOOL_USE_USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        BalToolsToml balToolsToml = BalToolsToml.from((Path)this.balToolsTomlPath);
        BalToolsManifest balToolsManifest = BalToolsManifestBuilder.from((BalToolsToml)balToolsToml).build();
        Optional tool = balToolsManifest.getTool(this.toolId, this.version, this.repositoryName);
        if (tool.isEmpty()) {
            boolean isLocalTool = this.isToolAvailableInLocalRepo(this.toolId, this.version);
            if (isLocalTool) {
                CommandUtil.printError(this.errStream, "tool '" + this.toolId + ":" + this.version + "' is not found. Run 'bal tool pull " + this.toolId + ":" + this.version + "' or 'bal tool pull " + this.toolId + ":" + this.version + " --repository=local' to fetch and set as the active version.", null, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            CommandUtil.printError(this.errStream, "tool '" + this.toolId + ":" + this.version + "' is not found. Run 'bal tool pull " + this.toolId + ":" + this.version + "' to fetch and set as the active version.", null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        this.org = ((BalToolsManifest.Tool)tool.get()).org();
        this.name = ((BalToolsManifest.Tool)tool.get()).name();
        Optional currentActiveTool = balToolsManifest.getActiveTool(this.toolId);
        if (currentActiveTool.isPresent() && ((BalToolsManifest.Tool)currentActiveTool.get()).version().equals(((BalToolsManifest.Tool)tool.get()).version()) && Objects.equals(((BalToolsManifest.Tool)currentActiveTool.get()).repository(), ((BalToolsManifest.Tool)tool.get()).repository())) {
            this.outStream.println("tool '" + this.toolId + ":" + this.version + "' is the current active version.");
            return;
        }
        boolean isDistsCompatible = this.checkToolDistCompatibility();
        if (!isDistsCompatible) {
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        balToolsManifest.setActiveToolVersion(this.toolId, this.version, this.repositoryName);
        balToolsToml.modify(balToolsManifest);
        this.outStream.println("tool '" + this.toolId + ":" + this.version + "' successfully set as the active version.");
    }

    private void handleListCommand() {
        if (this.argList.size() > 1) {
            CommandUtil.printError(this.errStream, "too many arguments.", TOOL_LIST_USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        List<BalToolsManifest.Tool> tools = this.listBalToolsTomlFile();
        if (tools.isEmpty()) {
            this.outStream.println("no tools found locally.");
            return;
        }
        PrintUtils.printLocalTools(tools, RepoUtils.getTerminalWidth());
    }

    private void handleSearchCommand() {
        if (this.argList.size() < 2) {
            CommandUtil.printError(this.errStream, "no keyword given.", TOOL_SEARCH_USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (this.argList.size() > 2) {
            CommandUtil.printError(this.errStream, "too many arguments.", TOOL_SEARCH_USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if ("local".equals(this.repositoryName)) {
            CommandUtil.printError(this.errStream, "Local repository option is not supported with tool search command", null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        String searchArgs = this.argList.get(1);
        this.searchToolsInCentral(searchArgs);
    }

    private void handleRemoveCommand() {
        if (this.argList.size() < 2) {
            CommandUtil.printError(this.errStream, "tool id is not provided.", TOOL_REMOVE_USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (this.argList.size() > 2) {
            CommandUtil.printError(this.errStream, "too many arguments.", TOOL_REMOVE_USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        String toolIdAndVersion = this.argList.get(1);
        String[] toolInfo = toolIdAndVersion.split(":");
        if (toolInfo.length == 2) {
            this.toolId = toolInfo[0];
            this.version = toolInfo[1];
        } else if (toolInfo.length == 1) {
            this.toolId = toolIdAndVersion;
            this.version = Names.EMPTY.getValue();
        } else {
            CommandUtil.printError(this.errStream, "invalid tool id.", TOOL_REMOVE_USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (!ProjectUtils.validateToolName((String)this.toolId)) {
            CommandUtil.printError(this.errStream, "invalid tool id.", TOOL_REMOVE_USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (!Names.EMPTY.getValue().equals(this.version)) {
            try {
                SemanticVersion.from((String)this.version);
            }
            catch (ProjectException e) {
                CommandUtil.printError(this.errStream, "invalid tool version. " + e.getMessage(), TOOL_REMOVE_USAGE_TEXT, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
        }
        if (Names.EMPTY.getValue().equals(this.version)) {
            this.removeAllToolVersions();
        } else {
            this.removeSpecificToolVersion();
        }
    }

    private void handleUpdateCommand() {
        if (this.argList.size() < 2) {
            CommandUtil.printError(this.errStream, "tool id is not provided.", TOOL_UPDATE_USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (this.argList.size() > 2) {
            CommandUtil.printError(this.errStream, "too many arguments.", TOOL_UPDATE_USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if ("local".equals(this.repositoryName)) {
            CommandUtil.printError(this.errStream, "tool update command is not supported for local repository.", null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        this.toolId = this.argList.get(1);
        if (!ProjectUtils.validateToolName((String)this.toolId)) {
            CommandUtil.printError(this.errStream, "invalid tool id.", TOOL_UPDATE_USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        this.updateToolToLatestVersion();
    }

    public void pullToolAndUpdateBalToolsToml(String toolIdArg, String versionArg) {
        this.toolId = toolIdArg;
        this.version = versionArg;
        Path balaCacheDirPath = RepoUtils.createAndGetHomeReposPath().resolve("repositories").resolve("central.ballerina.io").resolve("bala");
        String supportedPlatform = Arrays.stream(JvmTarget.values()).map(JvmTarget::code).collect(Collectors.joining(","));
        if ("local".equals(this.repositoryName)) {
            if (!this.isToolAvailableInLocalRepo(this.toolId, this.version)) {
                this.errStream.println("tool '" + this.toolId + ":" + this.version + "' is not available in local repository.\nUse 'bal push --repository=local' to publish it.");
                CommandUtil.exitError(this.exitWhenFinish);
            }
            this.addToBalToolsToml();
            return;
        }
        try {
            if (this.isToolAvailableLocally(this.toolId, this.version)) {
                this.outStream.println("tool '" + this.toolId + ":" + this.version + "' is already available locally.");
            } else {
                this.pullToolFromCentral(supportedPlatform, balaCacheDirPath);
            }
            this.addToBalToolsToml();
        }
        catch (PackageAlreadyExistsException e) {
            this.errStream.println(e.getMessage());
            CommandUtil.exitError(this.exitWhenFinish);
        }
        catch (ProjectException | CentralClientException e) {
            CommandUtil.printError(this.errStream, "unexpected error occurred while pulling tool:" + e.getMessage(), null, false);
            CommandUtil.exitError(this.exitWhenFinish);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isToolAvailableInLocalRepo(String toolId, String version) {
        Gson gson = new Gson();
        Path localBalaPath = RepoUtils.createAndGetHomeReposPath().resolve(Path.of("repositories", "local", "bala"));
        Path localToolJsonPath = localBalaPath.resolve("local-tools.json");
        if (!Files.exists(localToolJsonPath, new LinkOption[0])) {
            return false;
        }
        try (BufferedReader bufferedReader = Files.newBufferedReader(localToolJsonPath, StandardCharsets.UTF_8);){
            JsonObject localToolJson = (JsonObject)gson.fromJson((Reader)bufferedReader, JsonObject.class);
            JsonElement localTool = localToolJson.get(toolId);
            if (localTool == null) {
                boolean bl = false;
                return bl;
            }
            JsonObject pkgDesc = localTool.getAsJsonObject();
            if (pkgDesc.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            this.org = pkgDesc.get("org").getAsString();
            this.name = pkgDesc.get("name").getAsString();
            boolean bl = Files.exists(localBalaPath.resolve(this.org).resolve(this.name).resolve(version), new LinkOption[0]);
            return bl;
        }
        catch (IOException e) {
            throw new ProjectException("Failed to read local-tools.json file: " + e.getMessage());
        }
    }

    private void pullToolFromCentral(String supportedPlatform, Path balaCacheDirPath) throws CentralClientException {
        Settings settings = RepoUtils.readSettings();
        System.setProperty("enableOutputStream", "true");
        CentralAPIClient client = new CentralAPIClient(RepoUtils.getRemoteRepoURL(), ProjectUtils.initializeProxy((Proxy)settings.getProxy()), settings.getProxy().username(), settings.getProxy().password(), ProjectUtils.getAccessTokenOfCLI((Settings)settings), settings.getCentral().getConnectTimeout(), settings.getCentral().getReadTimeout(), settings.getCentral().getWriteTimeout(), settings.getCentral().getCallTimeout(), settings.getCentral().getMaxRetries());
        String[] toolInfo = client.pullTool(this.toolId, this.version, balaCacheDirPath, supportedPlatform, RepoUtils.getBallerinaVersion(), false);
        boolean isPulled = Boolean.parseBoolean(toolInfo[0]);
        this.org = toolInfo[1];
        this.name = toolInfo[2];
        this.version = toolInfo[3];
        if (isPulled) {
            this.outStream.println("tool '" + this.toolId + ":" + this.version + "' pulled successfully.");
        } else {
            this.outStream.println("tool '" + this.toolId + ":" + this.version + "' is already available locally.");
        }
    }

    private void addToBalToolsToml() {
        BalToolsToml balToolsToml = BalToolsToml.from((Path)this.balToolsTomlPath);
        BalToolsManifest balToolsManifest = BalToolsManifestBuilder.from((BalToolsToml)balToolsToml).build();
        boolean isDistsCompatible = this.checkToolDistCompatibility();
        if (!isDistsCompatible) {
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (this.isToolVersionAlreadyActive(this.toolId, this.version)) {
            this.outStream.println("tool '" + this.toolId + ":" + this.version + "' is already active.");
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        balToolsManifest.addTool(this.toolId, this.org, this.name, this.version, Boolean.valueOf(true), this.repositoryName);
        balToolsToml.modify(balToolsManifest);
        this.outStream.println("tool '" + this.toolId + ":" + this.version + "' successfully set as the active version.");
    }

    private List<BalToolsManifest.Tool> listBalToolsTomlFile() {
        BalToolsToml balToolsToml = BalToolsToml.from((Path)this.balToolsTomlPath);
        BalToolsManifest balToolsManifest = BalToolsManifestBuilder.from((BalToolsToml)balToolsToml).build();
        ArrayList<BalToolsManifest.Tool> flattenedTools = new ArrayList<BalToolsManifest.Tool>();
        balToolsManifest.tools().values().stream().flatMap(map -> map.values().stream()).flatMap(map -> map.values().stream()).sorted(Comparator.comparing(BalToolsManifest.Tool::id).thenComparing(BalToolsManifest.Tool::version).reversed()).forEach(flattenedTools::add);
        return flattenedTools;
    }

    private void removeAllToolVersions() {
        BalToolsToml balToolsToml = BalToolsToml.from((Path)this.balToolsTomlPath);
        BalToolsManifest balToolsManifest = BalToolsManifestBuilder.from((BalToolsToml)balToolsToml).build();
        Optional<Map> toolVersions = Optional.ofNullable((Map)balToolsManifest.tools().get(this.toolId));
        if (toolVersions.isEmpty() || toolVersions.get().isEmpty()) {
            CommandUtil.printError(this.errStream, "tool '" + this.toolId + "' not found.", null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        balToolsManifest.removeTool(this.toolId);
        balToolsToml.modify(balToolsManifest);
        if (this.repositoryName != null) {
            this.outStream.println("tool '" + this.toolId + "' successfully removed.");
            return;
        }
        Optional tool = toolVersions.get().values().stream().findAny().flatMap(value -> value.values().stream().findAny());
        tool.ifPresent(value -> this.deleteAllCachedToolVersions(value.org(), value.name()));
        this.outStream.println("tool '" + this.toolId + "' successfully removed.");
    }

    private void removeSpecificToolVersion() {
        BalToolsToml balToolsToml = BalToolsToml.from((Path)this.balToolsTomlPath);
        BalToolsManifest balToolsManifest = BalToolsManifestBuilder.from((BalToolsToml)balToolsToml).build();
        Optional tool = balToolsManifest.getTool(this.toolId, this.version, this.repositoryName);
        if (tool.isEmpty()) {
            CommandUtil.printError(this.errStream, "tool '" + this.toolId + ":" + this.version + "' not found.", null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (((BalToolsManifest.Tool)tool.get()).active().booleanValue()) {
            CommandUtil.printError(this.errStream, "cannot remove active tool '" + this.toolId + ":" + this.version + "'.", null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        this.org = ((BalToolsManifest.Tool)tool.get()).org();
        this.name = ((BalToolsManifest.Tool)tool.get()).name();
        boolean isDistsCompatible = this.checkToolDistCompatibility();
        if (!isDistsCompatible) {
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        balToolsManifest.removeToolVersion(this.toolId, this.version, this.repositoryName);
        balToolsToml.modify(balToolsManifest);
        if (this.repositoryName != null) {
            this.outStream.println("tool '" + this.toolId + ":" + this.version + "' successfully removed.");
            return;
        }
        this.deleteCachedToolVersion(((BalToolsManifest.Tool)tool.get()).org(), ((BalToolsManifest.Tool)tool.get()).name(), this.version);
        this.outStream.println("tool '" + this.toolId + ":" + this.version + "' successfully removed.");
    }

    private void deleteAllCachedToolVersions(String org, String name) {
        Path toolPath = RepoUtils.createAndGetHomeReposPath().resolve(Path.of("repositories", "central.ballerina.io", "bala", org, name));
        if (!Files.isDirectory(toolPath, new LinkOption[0])) {
            return;
        }
        ProjectUtils.deleteDirectory((Path)toolPath);
    }

    private void deleteCachedToolVersion(String org, String name, String version) {
        Path toolPath = RepoUtils.createAndGetHomeReposPath().resolve(Path.of("repositories", "central.ballerina.io", "bala", org, name, version));
        if (!Files.isDirectory(toolPath, new LinkOption[0])) {
            return;
        }
        ProjectUtils.deleteDirectory((Path)toolPath);
    }

    private void searchToolsInCentral(String keyword) {
        try {
            Settings settings = RepoUtils.readSettings();
            CentralAPIClient client = new CentralAPIClient(RepoUtils.getRemoteRepoURL(), ProjectUtils.initializeProxy((Proxy)settings.getProxy()), settings.getProxy().username(), settings.getProxy().password(), ProjectUtils.getAccessTokenOfCLI((Settings)settings), settings.getCentral().getConnectTimeout(), settings.getCentral().getReadTimeout(), settings.getCentral().getWriteTimeout(), settings.getCentral().getCallTimeout(), settings.getCentral().getMaxRetries());
            boolean foundTools = false;
            String supportedPlatform = Arrays.stream(JvmTarget.values()).map(JvmTarget::code).collect(Collectors.joining(","));
            ToolSearchResult toolSearchResult = client.searchTool(keyword, supportedPlatform, RepoUtils.getBallerinaVersion());
            List tools = toolSearchResult.getTools();
            if (tools != null && !tools.isEmpty()) {
                foundTools = true;
                PrintUtils.printTools(toolSearchResult.getTools(), RepoUtils.getTerminalWidth());
            }
            if (!foundTools) {
                this.outStream.println("no tools found.");
            }
        }
        catch (CentralClientException e) {
            String errorMessage = e.getMessage();
            if (null != errorMessage && !EMPTY_STRING.equals(errorMessage.trim())) {
                if (errorMessage.contains("\n\tat")) {
                    errorMessage = errorMessage.substring(0, errorMessage.indexOf("\n\tat"));
                }
                CommandUtil.printError(this.errStream, errorMessage, null, false);
                CommandUtil.exitError(this.exitWhenFinish);
            }
            CommandUtil.printError(this.errStream, "error while searching for tools.", null, false);
            CommandUtil.exitError(this.exitWhenFinish);
        }
    }

    private boolean isToolAvailableLocally(String toolId, String version) {
        if (version.equals(Names.EMPTY.getValue())) {
            return false;
        }
        BalToolsToml balToolsToml = BalToolsToml.from((Path)this.balToolsTomlPath);
        BalToolsManifest balToolsManifest = BalToolsManifestBuilder.from((BalToolsToml)balToolsToml).build();
        Optional toolOptional = balToolsManifest.getTool(toolId, version, this.repositoryName);
        if (toolOptional.isEmpty()) {
            return false;
        }
        BalToolsManifest.Tool tool = (BalToolsManifest.Tool)toolOptional.get();
        this.org = tool.org();
        this.name = tool.name();
        Path toolCacheDir = RepoUtils.createAndGetHomeReposPath().resolve("repositories").resolve("central.ballerina.io").resolve("bala").resolve(tool.org()).resolve(tool.name());
        if (toolCacheDir.toFile().isDirectory()) {
            boolean bl;
            block11: {
                Stream<Path> versions = Files.list(toolCacheDir);
                try {
                    bl = versions.anyMatch(path -> path.getFileName().toString().equals(version));
                    if (versions == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (versions != null) {
                            try {
                                versions.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new ProjectException("Error while looking for locally available tools: " + String.valueOf(e));
                    }
                }
                versions.close();
            }
            return bl;
        }
        return false;
    }

    private boolean checkToolDistCompatibility() {
        SemanticVersion toolDistVersion;
        SemanticVersion currentDistVersion = SemanticVersion.from((String)RepoUtils.getBallerinaShortVersion());
        SemanticVersion semanticVersion = toolDistVersion = "local".equals(this.repositoryName) ? this.getToolDistVersionFromCache("local") : this.getToolDistVersionFromCache("central.ballerina.io");
        if (!this.isCompatibleWithLocalDistVersion(currentDistVersion, toolDistVersion)) {
            CommandUtil.printError(this.errStream, "tool '" + this.toolId + ":" + this.version + "' is not compatible with the current Ballerina distribution '" + RepoUtils.getBallerinaShortVersion() + "'. Use 'bal tool search' to select a version compatible with the current Ballerina distribution.", null, false);
            return false;
        }
        return true;
    }

    private SemanticVersion getToolDistVersionFromCache(String repositoryName) {
        Path balaDirPath = RepoUtils.createAndGetHomeReposPath().resolve("repositories").resolve(repositoryName).resolve("bala");
        Path balaPath = CommandUtil.getPlatformSpecificBalaPath(this.org, this.name, this.version, balaDirPath);
        PackageJson packageJson = BalaFiles.readPackageJson((Path)balaPath);
        return SemanticVersion.from((String)packageJson.getBallerinaVersion());
    }

    private boolean isCompatibleWithLocalDistVersion(SemanticVersion localDistVersion, SemanticVersion toolDistVersion) {
        return localDistVersion.major() == toolDistVersion.major() && localDistVersion.minor() >= toolDistVersion.minor();
    }

    private boolean isToolVersionAlreadyActive(String toolId, String version) {
        if (version.equals(Names.EMPTY.getValue())) {
            return false;
        }
        BalToolsToml balToolsToml = BalToolsToml.from((Path)this.balToolsTomlPath);
        BalToolsManifest balToolsManifest = BalToolsManifestBuilder.from((BalToolsToml)balToolsToml).build();
        if (balToolsManifest.tools().containsKey(toolId)) {
            Map toolVersions = (Map)balToolsManifest.tools().get(toolId);
            return toolVersions.containsKey(version) && ((Map)toolVersions.get(version)).containsKey(this.repositoryName) && ((BalToolsManifest.Tool)((Map)toolVersions.get(version)).get(this.repositoryName)).active() != false;
        }
        return false;
    }

    private void updateToolToLatestVersion() {
        BalToolsToml balToolsToml = BalToolsToml.from((Path)this.balToolsTomlPath);
        BalToolsManifest balToolsManifest = BalToolsManifestBuilder.from((BalToolsToml)balToolsToml).build();
        Optional tool = balToolsManifest.getActiveTool(this.toolId);
        if (tool.isEmpty()) {
            CommandUtil.printError(this.errStream, "tool '" + this.toolId + "' is not installed.", null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if ("local".equals(((BalToolsManifest.Tool)tool.get()).repository())) {
            CommandUtil.printError(this.errStream, "tools from local repository can not be updated. ", null, false);
            CommandUtil.exitError(this.exitWhenFinish);
        }
        Path balaCacheDirPath = RepoUtils.createAndGetHomeReposPath().resolve("repositories").resolve("central.ballerina.io").resolve("bala");
        String supportedPlatform = Arrays.stream(JvmTarget.values()).map(JvmTarget::code).collect(Collectors.joining(","));
        try {
            this.version = this.getLatestVersionForUpdateCommand(supportedPlatform, (BalToolsManifest.Tool)tool.get());
            if (((BalToolsManifest.Tool)tool.get()).version().equals(this.version)) {
                this.outStream.println("tool '" + this.toolId + "' is already up-to-date.");
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            if (this.isToolAvailableLocally(this.toolId, this.version)) {
                this.outStream.println("tool '" + this.toolId + ":" + this.version + "' is already available locally.");
            } else {
                this.pullToolFromCentral(supportedPlatform, balaCacheDirPath);
            }
            this.addToBalToolsToml();
        }
        catch (PackageAlreadyExistsException e) {
            this.errStream.println(e.getMessage());
            CommandUtil.exitError(this.exitWhenFinish);
        }
        catch (ProjectException | CentralClientException e) {
            CommandUtil.printError(this.errStream, "unexpected error occurred while pulling tool:" + e.getMessage(), null, false);
            CommandUtil.exitError(this.exitWhenFinish);
        }
    }

    private String getLatestVersionForUpdateCommand(String supportedPlatforms, BalToolsManifest.Tool tool) throws CentralClientException {
        Settings settings = RepoUtils.readSettings();
        System.setProperty("enableOutputStream", "true");
        CentralAPIClient client = new CentralAPIClient(RepoUtils.getRemoteRepoURL(), ProjectUtils.initializeProxy((Proxy)settings.getProxy()), settings.getProxy().username(), settings.getProxy().password(), ProjectUtils.getAccessTokenOfCLI((Settings)settings), settings.getCentral().getConnectTimeout(), settings.getCentral().getReadTimeout(), settings.getCentral().getWriteTimeout(), settings.getCentral().getCallTimeout(), settings.getCentral().getMaxRetries());
        List versions = client.getPackageVersions(tool.org(), tool.name(), supportedPlatforms, RepoUtils.getBallerinaVersion());
        return this.getLatestVersion(versions, tool.version());
    }

    private String getLatestVersion(List<String> versions, String currentVersionStr) {
        Optional<String> latestVersionInSameMinor = versions.stream().map(SemanticVersion::from).max((v1, v2) -> {
            if (v1.greaterThan(v2)) {
                return 1;
            }
            if (v2.greaterThan(v1)) {
                return -1;
            }
            return 0;
        }).map(SemanticVersion::toString);
        return latestVersionInSameMinor.orElse(currentVersionStr);
    }
}

